/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountOwner;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeQuery;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeFeeCalculationDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.PageParameters;

public class GuaranteeServiceSecurity
extends BaseServiceSecurity
implements GuaranteeService {
    private GuaranteeServiceLocal guaranteeService;

    @Override
    public Guarantee acceptGuarantee(Guarantee guarantee, boolean automaticLoanAuthorization) {
        boolean hasPermission = this.permissionService.permission((guarantee = this.fetchService.fetch(guarantee, Guarantee.Relationships.BUYER, Guarantee.Relationships.ISSUER)).getBuyer()).admin(AdminMemberPermission.GUARANTEES_ACCEPT_GUARANTEES_AS_MEMBER).hasPermission();
        if (!hasPermission) {
            hasPermission = this.permissionService.permission(guarantee.getIssuer()).member(MemberPermission.GUARANTEES_ISSUE_GUARANTEES).operator(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES).hasPermission();
        }
        if (!hasPermission) {
            throw new PermissionDeniedException();
        }
        return this.guaranteeService.acceptGuarantee(guarantee, automaticLoanAuthorization && this.hasPermission(AdminSystemPermission.PAYMENTS_AUTHORIZE));
    }

    @Override
    public BigDecimal calculateFee(GuaranteeFeeCalculationDTO dto) {
        this.checkHasUser();
        return this.guaranteeService.calculateFee(dto);
    }

    @Override
    public boolean canChangeStatus(Guarantee guarantee, Guarantee.Status newStatus) {
        this.checkHasUser();
        return this.guaranteeService.canChangeStatus(guarantee, newStatus);
    }

    @Override
    public boolean canRemoveGuarantee(Guarantee guarantee) {
        this.checkHasUser();
        return this.guaranteeService.canRemoveGuarantee(guarantee);
    }

    @Override
    public Guarantee changeStatus(Long guaranteeId, Guarantee.Status newStatus) {
        Guarantee guarantee = this.guaranteeService.load(guaranteeId, Guarantee.Relationships.BUYER, Guarantee.Relationships.ISSUER);
        switch (newStatus) {
            case CANCELLED: 
            case REJECTED: {
                if (newStatus == Guarantee.Status.CANCELLED || LoggedUser.isAdministrator()) {
                    this.permissionService.permission(guarantee.getBuyer()).admin(AdminMemberPermission.GUARANTEES_CANCEL_GUARANTEES_AS_MEMBER).check();
                    break;
                }
            }
            default: {
                this.permissionService.permission(guarantee.getIssuer()).member(MemberPermission.GUARANTEES_ISSUE_GUARANTEES).operator(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES).check();
            }
        }
        return this.guaranteeService.changeStatus(guaranteeId, newStatus);
    }

    @Override
    public Collection<? extends MemberGroup> getBuyers() {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS, AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS, AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).member(MemberPermission.GUARANTEES_ISSUE_GUARANTEES, MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES, OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).check();
        return this.guaranteeService.getBuyers();
    }

    @Override
    public List<Guarantee> getGuarantees(Certification certification, PageParameters pageParameters, List<Guarantee.Status> statusList) {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS).member(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_CERTIFICATIONS, OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).check();
        return this.guaranteeService.getGuarantees(certification, pageParameters, statusList);
    }

    @Override
    public Collection<? extends MemberGroup> getIssuers() {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS, AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS, AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).member(new MemberPermission[0]).operator().check();
        return this.guaranteeService.getIssuers();
    }

    @Override
    public Collection<? extends MemberGroup> getIssuers(GuaranteeType guaranteeType) {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_REGISTER_GUARANTEES).check();
        return this.guaranteeService.getIssuers(guaranteeType);
    }

    @Override
    public Collection<GuaranteeType.Model> getRelatedGuaranteeModels() {
        this.permissionService.permission().member(new MemberPermission[0]).operator().check();
        return this.guaranteeService.getRelatedGuaranteeModels();
    }

    @Override
    public Collection<? extends MemberGroup> getSellers() {
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS, AdminMemberPermission.GUARANTEES_VIEW_CERTIFICATIONS, AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).member(MemberPermission.GUARANTEES_ISSUE_GUARANTEES, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_ISSUE_GUARANTEES, OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).check();
        return this.guaranteeService.getSellers();
    }

    @Override
    public boolean isBuyer() {
        this.checkHasUser();
        return this.guaranteeService.isBuyer();
    }

    @Override
    public boolean isIssuer() {
        this.checkHasUser();
        return this.guaranteeService.isIssuer();
    }

    @Override
    public boolean isSeller() {
        this.checkHasUser();
        return this.guaranteeService.isSeller();
    }

    @Override
    public Guarantee load(Long id, Relationship ... fetch) {
        Guarantee guarantee = this.guaranteeService.load(id, fetch);
        this.checkView(guarantee);
        return guarantee;
    }

    @Override
    public Guarantee loadFromTransfer(Transfer transfer) {
        Guarantee guarantee = this.guaranteeService.loadFromTransfer(transfer);
        if (guarantee != null && !this.canView(guarantee)) {
            guarantee = null;
        }
        return guarantee;
    }

    @Override
    public Guarantee registerGuarantee(Guarantee guarantee) {
        this.permissionService.permission(guarantee.getBuyer()).admin(AdminMemberPermission.GUARANTEES_REGISTER_GUARANTEES).check();
        if (guarantee.getIssuer() != null) {
            this.permissionService.checkManages(guarantee.getIssuer());
        }
        if (guarantee.getSeller() != null) {
            this.permissionService.checkManages(guarantee.getSeller());
        }
        if (!guarantee.isTransient()) {
            throw new PermissionDeniedException();
        }
        return this.guaranteeService.registerGuarantee(guarantee);
    }

    @Override
    public int remove(Long guaranteeId) {
        Guarantee guarantee = this.guaranteeService.load(guaranteeId, Guarantee.Relationships.BUYER);
        if (this.canRemoveGuarantee(guarantee)) {
            return this.guaranteeService.remove(guaranteeId);
        }
        throw new PermissionDeniedException();
    }

    @Override
    public Guarantee requestGuarantee(PaymentObligationPackDTO pack) {
        this.permissionService.permission().member(MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).check();
        return this.guaranteeService.requestGuarantee(pack);
    }

    @Override
    public List<Guarantee> search(GuaranteeQuery queryParameters) {
        boolean hasNoRole;
        boolean isIssuer = this.isIssuer();
        boolean isBuyer = this.isBuyer();
        boolean isSeller = this.isSeller();
        if (isIssuer) {
            Group group = (Group)this.fetchService.fetch(LoggedUser.group(), new Relationship[]{Group.Relationships.GUARANTEE_TYPES});
            if (group.getGuaranteeTypes().isEmpty()) {
                return Collections.emptyList();
            }
            if (queryParameters.getGuaranteeType() == null) {
                queryParameters.setAllowedGuaranteeTypes(group.getGuaranteeTypes());
            } else if (!group.getGuaranteeTypes().contains(queryParameters.getGuaranteeType())) {
                throw new IllegalArgumentException("Guarantee type not allowed to filter: " + queryParameters.getGuaranteeType());
            }
            queryParameters.setIssuer((Member)LoggedUser.accountOwner());
        }
        if (isBuyer && isSeller) {
            queryParameters.setLoggedMember((Member)LoggedUser.accountOwner());
        } else if (isBuyer) {
            queryParameters.setBuyer((Member)LoggedUser.accountOwner());
        } else if (isSeller) {
            queryParameters.setLoggedMember((Member)LoggedUser.accountOwner());
        }
        boolean hasAdminViewPermission = this.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES);
        boolean bl = hasNoRole = !isBuyer && !isIssuer && !isSeller && !hasAdminViewPermission;
        if (hasNoRole) {
            queryParameters.setBuyer((Member)LoggedUser.accountOwner());
        } else if (hasAdminViewPermission) {
            queryParameters.setManagedMemberGroups(this.permissionService.getManagedMemberGroups());
        }
        return this.guaranteeService.search(queryParameters);
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    @Override
    public void validate(Guarantee guarantee, boolean isAuthorization) {
        this.guaranteeService.validate(guarantee, isAuthorization);
    }

    private boolean canView(Guarantee guarantee) {
        AccountOwner owner = LoggedUser.accountOwner();
        if (guarantee.getIssuer().equals(owner) && !this.permissionService.hasPermission(MemberPermission.GUARANTEES_ISSUE_GUARANTEES, OperatorPermission.GUARANTEES_ISSUE_GUARANTEES)) {
            return false;
        }
        if (guarantee.getIssuer().equals(owner)) {
            return true;
        }
        boolean manages = false;
        if (guarantee.getGuaranteeType().getModel() == GuaranteeType.Model.WITH_BUYER_ONLY) {
            manages = this.permissionService.manages(guarantee.getBuyer());
        } else {
            boolean bl = manages = this.permissionService.manages(guarantee.getBuyer()) || this.permissionService.manages(guarantee.getSeller());
        }
        if (!manages) {
            return false;
        }
        return this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).member(new MemberPermission[0]).operator().hasPermission();
    }

    private void checkView(Guarantee guarantee) {
        if (!this.canView(guarantee)) {
            throw new PermissionDeniedException();
        }
    }
}

