/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.math.BigDecimal;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.guarantees.GuaranteeTypeDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeFeeVO;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class GuaranteeTypeServiceImpl
implements GuaranteeTypeServiceLocal {
    private GuaranteeTypeDAO guaranteeTypeDao;

    @Override
    public boolean areEnabledGuaranteeTypes() {
        GuaranteeTypeQuery queryParameters = new GuaranteeTypeQuery();
        queryParameters.setEnabled(true);
        return !this.search(queryParameters).isEmpty();
    }

    @Override
    public GuaranteeType load(Long id, Relationship ... fetch) {
        return (GuaranteeType)this.guaranteeTypeDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.guaranteeTypeDao.delete(ids);
    }

    @Override
    public GuaranteeType save(GuaranteeType guaranteeType) {
        this.validate(guaranteeType);
        this.verify(guaranteeType);
        if (guaranteeType.isTransient()) {
            return this.guaranteeTypeDao.insert(guaranteeType);
        }
        return this.guaranteeTypeDao.update(guaranteeType);
    }

    @Override
    public List<GuaranteeType> search(GuaranteeTypeQuery query) {
        List<GuaranteeType> guaranteeTypes = this.guaranteeTypeDao.search(query);
        return guaranteeTypes;
    }

    public void setGuaranteeTypeDao(GuaranteeTypeDAO guaranteeTypeDao) {
        this.guaranteeTypeDao = guaranteeTypeDao;
    }

    @Override
    public void validate(GuaranteeType guaranteeType) throws ValidationException {
        this.getValidator().validate(guaranteeType);
    }

    private Validator getValidator() {
        Validator validator = new Validator("guaranteeType");
        validator.property("name").required();
        validator.property("model").required();
        validator.property("currency").required();
        validator.property("authorizedBy").required();
        validator.property("loanTransferType").key("guaranteeType.error.loanTransferType").required();
        validator.general(new AuthorizerByValidation());
        validator.general(new TransferTypeValidation(TransferTypes.CREDIT));
        validator.general(new TransferTypeValidation(TransferTypes.ISSUE));
        validator.general(new TransferTypeValidation(TransferTypes.FORWARD));
        return validator;
    }

    private boolean isEmptyGuaranteeTypeFee(GuaranteeTypeFeeVO feeVO) {
        return BigDecimal.ZERO.compareTo(feeVO.getFee()) == 0 && feeVO.isReadonly();
    }

    private void verify(GuaranteeType guaranteeType) {
        guaranteeType.setCreditFee(this.verifyFee(guaranteeType.getCreditFee()));
        guaranteeType.setIssueFee(this.verifyFee(guaranteeType.getIssueFee()));
        if (guaranteeType.getModel() != GuaranteeType.Model.WITH_BUYER_AND_SELLER) {
            guaranteeType.setCreditFeePayer(GuaranteeType.FeePayer.SELLER);
            guaranteeType.setIssueFeePayer(GuaranteeType.FeePayer.SELLER);
        } else if (guaranteeType.getModel() == GuaranteeType.Model.WITH_BUYER_ONLY) {
            guaranteeType.setForwardTransferType(null);
        }
        if (this.isEmptyGuaranteeTypeFee(guaranteeType.getCreditFee())) {
            guaranteeType.setCreditFeeTransferType(null);
        }
        if (this.isEmptyGuaranteeTypeFee(guaranteeType.getIssueFee())) {
            guaranteeType.setIssueFeeTransferType(null);
        }
    }

    private GuaranteeTypeFeeVO verifyFee(GuaranteeTypeFeeVO fee) {
        if (fee == null) {
            fee = new GuaranteeTypeFeeVO();
        }
        if (fee.getFee() == null) {
            fee.setFee(BigDecimal.ZERO);
        }
        return fee;
    }

    private class TransferTypeValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -1616070380031832842L;
        private TransferTypes trasferType;

        public TransferTypeValidation(TransferTypes tt) {
            this.trasferType = tt;
        }

        @Override
        public ValidationError validate(Object object) {
            GuaranteeType guaranteeType = (GuaranteeType)object;
            switch (this.trasferType) {
                case CREDIT: {
                    boolean hasCreditFee;
                    boolean bl = hasCreditFee = guaranteeType.getCreditFee().getFee() != null && BigDecimal.ZERO.compareTo(guaranteeType.getCreditFee().getFee()) == -1;
                    if (guaranteeType.getCreditFeeTransferType() != null || guaranteeType.getCreditFee().isReadonly() && !hasCreditFee) break;
                    return new ValidationError("guaranteeType.error.creditFeeTransferType", new Object[0]);
                }
                case FORWARD: {
                    if (guaranteeType.getForwardTransferType() != null || guaranteeType.getModel() == GuaranteeType.Model.WITH_BUYER_ONLY) break;
                    return new ValidationError("guaranteeType.error.forwardTransferType", new Object[0]);
                }
                case ISSUE: {
                    boolean hasIssueFee;
                    boolean bl = hasIssueFee = guaranteeType.getIssueFee().getFee() != null && BigDecimal.ZERO.compareTo(guaranteeType.getIssueFee().getFee()) == -1;
                    if (guaranteeType.getIssueFeeTransferType() != null || guaranteeType.getIssueFee().isReadonly() && !hasIssueFee) break;
                    return new ValidationError("guaranteeType.error.issueFeeTransferType", new Object[0]);
                }
            }
            return null;
        }
    }

    private static enum TransferTypes {
        CREDIT,
        ISSUE,
        FORWARD;

    }

    private class AuthorizerByValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -1616070380031832842L;

        private AuthorizerByValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            GuaranteeType guaranteeType = (GuaranteeType)object;
            if (guaranteeType.getModel() == null || guaranteeType.getAuthorizedBy() == null) {
                return null;
            }
            GuaranteeType.AuthorizedBy authorizedBy = guaranteeType.getAuthorizedBy();
            if (guaranteeType.getModel() == GuaranteeType.Model.WITH_PAYMENT_OBLIGATION && authorizedBy != GuaranteeType.AuthorizedBy.ISSUER && authorizedBy != GuaranteeType.AuthorizedBy.BOTH) {
                return new ValidationError("guaranteeType.error.invalidAuthorizedBy", new Object[0]);
            }
            return null;
        }
    }
}

