/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeType;
import nl.strohalm.cyclos.entities.accounts.guarantees.GuaranteeTypeQuery;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferTypeQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeService;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeTypeServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionContext;
import nl.strohalm.cyclos.services.transfertypes.TransferTypeServiceLocal;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class GuaranteeTypeServiceSecurity
extends BaseServiceSecurity
implements GuaranteeTypeService {
    private GuaranteeTypeServiceLocal guaranteeTypeService;
    private TransferTypeServiceLocal transferTypeService;
    private GuaranteeServiceLocal guaranteeService;

    @Override
    public GuaranteeType load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        if (!this.guaranteeService.isIssuer()) {
            this.permissionService.permission().admin(AdminSystemPermission.GUARANTEE_TYPES_VIEW, AdminMemberPermission.GUARANTEES_REGISTER_GUARANTEES, AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).check();
        }
        return this.guaranteeTypeService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.GUARANTEE_TYPES_MANAGE).check();
        return this.guaranteeTypeService.remove(ids);
    }

    @Override
    public GuaranteeType save(GuaranteeType guaranteeType) {
        this.permissionService.permission().admin(AdminSystemPermission.GUARANTEE_TYPES_MANAGE).check();
        this.checkReadOnlyValues(guaranteeType);
        this.checkTransferTypes(guaranteeType);
        return this.guaranteeTypeService.save(guaranteeType);
    }

    @Override
    public List<GuaranteeType> search(GuaranteeTypeQuery guaranteeTypeQuery) {
        this.permissionService.permission().admin(AdminSystemPermission.GUARANTEE_TYPES_VIEW, AdminMemberPermission.GUARANTEES_VIEW_GUARANTEES).check();
        return this.guaranteeTypeService.search(guaranteeTypeQuery);
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setGuaranteeTypeServiceLocal(GuaranteeTypeServiceLocal guaranteeTypeService) {
        this.guaranteeTypeService = guaranteeTypeService;
    }

    public void setTransferTypeServiceLocal(TransferTypeServiceLocal transferTypeService) {
        this.transferTypeService = transferTypeService;
    }

    @Override
    public void validate(GuaranteeType guaranteeType) throws ValidationException {
        this.guaranteeTypeService.validate(guaranteeType);
    }

    private void checkReadOnlyValues(GuaranteeType modifiedGT) {
        if (!modifiedGT.isTransient()) {
            GuaranteeType savedGT = this.guaranteeTypeService.load(modifiedGT.getId(), new Relationship[0]);
            PermissionHelper.checkEquals(savedGT.getCurrency(), modifiedGT.getCurrency());
            PermissionHelper.checkEquals(savedGT.getModel(), modifiedGT.getModel());
        }
    }

    private void checkTransferTypes(GuaranteeType guaranteeType) {
        List<TransferType> allowedTTs;
        TransferTypeQuery ttQuery = new TransferTypeQuery();
        ttQuery.setCurrency(guaranteeType.getCurrency());
        if (guaranteeType.getCreditFeeTransferType() != null) {
            ttQuery.setContext(TransactionContext.ANY);
            ttQuery.setFromNature(AccountType.Nature.MEMBER);
            ttQuery.setToNature(AccountType.Nature.SYSTEM);
            allowedTTs = this.transferTypeService.search(ttQuery);
            PermissionHelper.checkContains(allowedTTs, guaranteeType.getCreditFeeTransferType());
        }
        if (guaranteeType.getIssueFeeTransferType() != null) {
            ttQuery.setContext(TransactionContext.ANY);
            ttQuery.setFromNature(AccountType.Nature.MEMBER);
            ttQuery.setToNature(AccountType.Nature.MEMBER);
            allowedTTs = this.transferTypeService.search(ttQuery);
            PermissionHelper.checkContains(allowedTTs, guaranteeType.getIssueFeeTransferType());
        }
        if (guaranteeType.getForwardTransferType() != null) {
            ttQuery.setContext(TransactionContext.ANY);
            ttQuery.setFromNature(AccountType.Nature.MEMBER);
            ttQuery.setToNature(AccountType.Nature.MEMBER);
            allowedTTs = this.transferTypeService.search(ttQuery);
            PermissionHelper.checkContains(allowedTTs, guaranteeType.getForwardTransferType());
        }
        if (guaranteeType.getLoanTransferType() != null) {
            ttQuery.setContext(TransactionContext.AUTOMATIC_LOAN);
            ttQuery.setFromNature(AccountType.Nature.SYSTEM);
            ttQuery.setToNature(AccountType.Nature.MEMBER);
            allowedTTs = this.transferTypeService.search(ttQuery);
            PermissionHelper.checkContains(allowedTTs, guaranteeType.getLoanTransferType());
        }
    }
}

