/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.dao.accounts.guarantees.PaymentObligationDAO;
import nl.strohalm.cyclos.dao.accounts.guarantees.PaymentObligationLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.guarantees.Certification;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationLog;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.accounts.guarantees.CertificationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.exceptions.PaymentObligationStatusChangeException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class PaymentObligationServiceImpl
implements PaymentObligationServiceLocal,
InitializingService {
    private PaymentObligationDAO paymentObligationDao;
    private PaymentObligationLogDAO paymentObligationLogDao;
    private GuaranteeServiceLocal guaranteeService;
    private CertificationServiceLocal certificationService;
    private MemberNotificationHandler memberNotificationHandler;
    private FetchServiceLocal fetchService;

    @Override
    public boolean canChangeStatus(PaymentObligation paymentObligation, PaymentObligation.Status newStatus) {
        switch (newStatus) {
            case PUBLISHED: {
                Calendar today = DateHelper.truncate(Calendar.getInstance());
                Calendar maxPublishDate = paymentObligation.getMaxPublishDate();
                boolean isBuyer = this.guaranteeService.isBuyer() && paymentObligation.getBuyer().equals(LoggedUser.accountOwner());
                boolean validDates = maxPublishDate.equals(today) || maxPublishDate.after(today);
                return isBuyer && validDates && this.isInSomeStatus(paymentObligation, PaymentObligation.Status.REGISTERED);
            }
            case REGISTERED: {
                boolean isBuyer = this.guaranteeService.isBuyer() && paymentObligation.getBuyer().equals(LoggedUser.accountOwner());
                return isBuyer && this.isInSomeStatus(paymentObligation, PaymentObligation.Status.PUBLISHED);
            }
            case ACCEPTED: 
            case REJECTED: {
                boolean isSeller = this.guaranteeService.isSeller() && paymentObligation.getSeller().equals(LoggedUser.accountOwner());
                return isSeller && this.isInSomeStatus(paymentObligation, PaymentObligation.Status.PUBLISHED);
            }
        }
        throw new PaymentObligationStatusChangeException(newStatus, "Can't change payment obligation's status, unsupported target status: " + newStatus);
    }

    @Override
    public boolean canDelete(PaymentObligation paymentObligation) {
        return this.isInSomeStatus(paymentObligation, PaymentObligation.Status.REGISTERED) && this.guaranteeService.isBuyer() && paymentObligation.getBuyer().equals(LoggedUser.accountOwner());
    }

    @Override
    public PaymentObligation changeStatus(Long paymentObligationId, PaymentObligation.Status newStatus) {
        PaymentObligation paymentObligation = this.load(paymentObligationId, new Relationship[0]);
        boolean changeAllowed = this.canChangeStatus(paymentObligation, newStatus);
        if (!changeAllowed) {
            throw new PaymentObligationStatusChangeException(newStatus);
        }
        PaymentObligationLog log = paymentObligation.changeStatus(newStatus, ((User)LoggedUser.user()).getElement());
        this.saveLog(log);
        this.save(paymentObligation, false);
        switch (newStatus) {
            case PUBLISHED: {
                this.memberNotificationHandler.paymentObligationPublishedNotification(paymentObligation);
                break;
            }
            case REJECTED: {
                this.memberNotificationHandler.paymentObligationRejectedNotification(paymentObligation);
            }
        }
        return paymentObligation;
    }

    @Override
    public Long[] checkPaymentObligationPeriod(PaymentObligationPackDTO dto) {
        if (dto.getPaymentObligations() == null || dto.getPaymentObligations().length == 0) {
            return new Long[0];
        }
        Long[] paymentObligationIds = dto.getPaymentObligations();
        List<PaymentObligation> paymentObligations = this.paymentObligationDao.loadOrderedByExpiration(paymentObligationIds);
        PaymentObligation firstPaymentObligation = paymentObligations.get(0);
        Certification certification = this.certificationService.getActiveCertification(firstPaymentObligation.getCurrency(), firstPaymentObligation.getBuyer(), dto.getIssuer());
        TimePeriod paymentObligationPeriod = certification.getGuaranteeType().getPaymentObligationPeriod();
        Calendar limit = Calendar.getInstance();
        limit.setTimeInMillis(firstPaymentObligation.getExpirationDate().getTimeInMillis());
        limit.add(paymentObligationPeriod.getField().getCalendarValue(), paymentObligationPeriod.getNumber());
        ArrayList<Long> exceeded = new ArrayList<Long>();
        for (PaymentObligation po : paymentObligations) {
            if (!po.getExpirationDate().after(limit)) continue;
            exceeded.add(po.getId());
        }
        return exceeded.toArray(new Long[exceeded.size()]);
    }

    @Override
    public PaymentObligation.Status[] getSellerStatusToFilter() {
        PaymentObligation.Status[] status = new PaymentObligation.Status[]{PaymentObligation.Status.PUBLISHED, PaymentObligation.Status.ACCEPTED, PaymentObligation.Status.REJECTED, PaymentObligation.Status.EXPIRED};
        return status;
    }

    @Override
    public PaymentObligation.Status[] getStatusToFilter() {
        boolean isSeller = this.guaranteeService.isSeller();
        boolean isBuyer = this.guaranteeService.isBuyer();
        if (isSeller && !isBuyer) {
            return this.getSellerStatusToFilter();
        }
        return PaymentObligation.Status.values();
    }

    @Override
    public void initializeService() {
        this.processPaymentObligations(Calendar.getInstance());
    }

    @Override
    public PaymentObligation load(Long id, Relationship ... fetch) {
        return (PaymentObligation)this.paymentObligationDao.load(id, fetch);
    }

    @Override
    public List<PaymentObligation> loadOrderedByExpiration(Long ... ids) {
        return this.paymentObligationDao.loadOrderedByExpiration(ids);
    }

    @Override
    public void processPaymentObligations(Calendar taskTime) {
        Calendar time = DateHelper.truncate(taskTime);
        PaymentObligationQuery query = new PaymentObligationQuery();
        time.add(5, -1);
        query.setExpiration(Period.endingAt(time));
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setApplyExpirationToMaxPublishDate(true);
        HashSet<Relationship> fetch = new HashSet<Relationship>();
        fetch.add(PaymentObligation.Relationships.LOGS);
        query.setFetch(fetch);
        query.setStatusList(Arrays.asList(PaymentObligation.Status.PUBLISHED));
        List<PaymentObligation> paymentObligations = this.paymentObligationDao.search(query);
        for (PaymentObligation paymentObligation : paymentObligations) {
            Calendar expirationDate = DateHelper.truncate(paymentObligation.getExpirationDate());
            PaymentObligation.Status newStatus = expirationDate.before(taskTime) ? PaymentObligation.Status.EXPIRED : PaymentObligation.Status.REGISTERED;
            paymentObligation.setStatus(newStatus);
            PaymentObligationLog log = paymentObligation.changeStatus(newStatus, null);
            this.saveLog(log);
            this.save(paymentObligation, false);
        }
    }

    @Override
    public int remove(Long paymentObligationId) {
        return this.paymentObligationDao.delete(paymentObligationId);
    }

    @Override
    public PaymentObligation save(PaymentObligation paymentObligation, boolean validate) {
        if (validate) {
            this.validate(paymentObligation);
        }
        if (paymentObligation.isTransient()) {
            this.initialize(paymentObligation);
            paymentObligation = this.paymentObligationDao.insert(paymentObligation);
            PaymentObligationLog paymentObligationLog = paymentObligation.getNewLog(paymentObligation.getStatus(), ((User)LoggedUser.user()).getElement());
            this.saveLog(paymentObligationLog);
            return paymentObligation;
        }
        return this.paymentObligationDao.update(paymentObligation);
    }

    @Override
    public PaymentObligationLog saveLog(PaymentObligationLog paymentObligationLog) {
        if (paymentObligationLog.isTransient()) {
            return this.paymentObligationLogDao.insert(paymentObligationLog);
        }
        return this.paymentObligationLogDao.update(paymentObligationLog);
    }

    @Override
    public List<PaymentObligation> search(PaymentObligationQuery queryParameters) {
        return this.paymentObligationDao.search(queryParameters);
    }

    public void setCertificationServiceLocal(CertificationServiceLocal certificationService) {
        this.certificationService = certificationService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setPaymentObligationDao(PaymentObligationDAO paymentObligationDao) {
        this.paymentObligationDao = paymentObligationDao;
    }

    public void setPaymentObligationLogDao(PaymentObligationLogDAO paymentObligationLogDao) {
        this.paymentObligationLogDao = paymentObligationLogDao;
    }

    @Override
    public void validate(PaymentObligation paymentObligation) {
        ExistingActiveCertificationValidation val = new ExistingActiveCertificationValidation();
        ValidationError error = val.validate(paymentObligation);
        if (error != null) {
            ValidationException vex = new ValidationException();
            vex.addGeneralError(error);
            vex.throwIfHasErrors();
        } else {
            this.getValidator().validate(paymentObligation);
        }
    }

    private Validator getValidator() {
        Validator validator = new Validator("paymentObligation");
        validator.property("buyer").required().key("paymentObligation.buyerUsername");
        validator.property("seller").required().key("paymentObligation.sellerUsername");
        validator.property("expirationDate").required().futureOrToday();
        validator.property("maxPublishDate").required().futureOrToday();
        validator.property("amount").required().positiveNonZero();
        validator.property("currency").required();
        validator.property("description").required();
        validator.general(new MaxPublicationDateBeforeExpirationDateValidation());
        return validator;
    }

    private void initialize(PaymentObligation paymentObligation) {
        paymentObligation.setStatus(PaymentObligation.Status.REGISTERED);
        paymentObligation.setRegistrationDate(Calendar.getInstance());
    }

    private boolean isInSomeStatus(PaymentObligation paymentObligation, PaymentObligation.Status ... status) {
        for (PaymentObligation.Status s : status) {
            if (paymentObligation.getStatus() != s) continue;
            return true;
        }
        return false;
    }

    private class MaxPublicationDateBeforeExpirationDateValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 1L;

        private MaxPublicationDateBeforeExpirationDateValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            PaymentObligation paymentObligation = (PaymentObligation)object;
            Calendar maxPublishDate = paymentObligation.getMaxPublishDate();
            Calendar expirationDate = paymentObligation.getExpirationDate();
            if (maxPublishDate != null && expirationDate != null && maxPublishDate.after(expirationDate)) {
                return new ValidationError("paymentObligation.error.maxPublicationDateAfterExpirationDate", new Object[0]);
            }
            return null;
        }
    }

    private class ExistingActiveCertificationValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -5784222476641557090L;

        private ExistingActiveCertificationValidation() {
        }

        @Override
        public ValidationError validate(Object object) {
            PaymentObligation paymentObligation = (PaymentObligation)object;
            Member buyer = paymentObligation.getBuyer();
            Currency currency = PaymentObligationServiceImpl.this.fetchService.fetch(paymentObligation.getCurrency(), new Relationship[0]);
            if (buyer == null || currency == null) {
                return null;
            }
            if (PaymentObligationServiceImpl.this.certificationService.getCertificationIssuers(paymentObligation).isEmpty()) {
                return new ValidationError("paymentObligation.error.certificationActiveNotExists", currency.getName());
            }
            return null;
        }
    }
}

