/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.guarantees;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligation;
import nl.strohalm.cyclos.entities.accounts.guarantees.PaymentObligationQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.guarantees.GuaranteeServiceLocal;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationPackDTO;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationService;
import nl.strohalm.cyclos.services.accounts.guarantees.PaymentObligationServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import org.apache.commons.collections.CollectionUtils;

public class PaymentObligationServiceSecurity
extends BaseServiceSecurity
implements PaymentObligationService {
    private PaymentObligationServiceLocal paymentObligationService;
    private GuaranteeServiceLocal guaranteeService;

    @Override
    public boolean canChangeStatus(PaymentObligation paymentObligation, PaymentObligation.Status newStatus) {
        this.checkHasUser();
        return this.paymentObligationService.canChangeStatus(paymentObligation, newStatus);
    }

    @Override
    public boolean canDelete(PaymentObligation paymentObligation) {
        this.checkHasUser();
        return this.paymentObligationService.canDelete(paymentObligation);
    }

    @Override
    public PaymentObligation changeStatus(Long paymentObligationId, PaymentObligation.Status newStatus) {
        PaymentObligation paymentObligation = this.paymentObligationService.load(paymentObligationId, PaymentObligation.Relationships.BUYER);
        switch (newStatus) {
            case REJECTED: {
                this.permissionService.permission(paymentObligation.getSeller()).member(MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).check();
                break;
            }
            default: {
                this.permissionService.permission(paymentObligation.getBuyer()).member(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS).check();
            }
        }
        return this.paymentObligationService.changeStatus(paymentObligationId, newStatus);
    }

    @Override
    public Long[] checkPaymentObligationPeriod(PaymentObligationPackDTO dto) {
        if (!this.guaranteeService.isSeller()) {
            throw new PermissionDeniedException();
        }
        List<PaymentObligation> paymentObligations = this.paymentObligationService.loadOrderedByExpiration(dto.getPaymentObligations());
        if (CollectionUtils.isNotEmpty(paymentObligations)) {
            for (PaymentObligation po : paymentObligations) {
                if (((Entity)LoggedUser.element()).equals(po.getSeller())) continue;
                throw new PermissionDeniedException();
            }
        }
        return this.paymentObligationService.checkPaymentObligationPeriod(dto);
    }

    @Override
    public PaymentObligation.Status[] getStatusToFilter() {
        if (!(this.guaranteeService.isBuyer() || this.guaranteeService.isSeller() || this.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS))) {
            throw new PermissionDeniedException();
        }
        return this.paymentObligationService.getStatusToFilter();
    }

    @Override
    public PaymentObligation load(Long id, Relationship ... fetch) {
        boolean manages;
        PaymentObligation po = this.paymentObligationService.load(id, fetch);
        po = this.fetchService.fetch(po, RelationshipHelper.nested(PaymentObligation.Relationships.BUYER, Element.Relationships.GROUP), RelationshipHelper.nested(PaymentObligation.Relationships.SELLER, Element.Relationships.GROUP));
        boolean hasPermission = this.permissionService.permission().memberFor(MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, po.getBuyer().getMemberGroup()).operatorFor(OperatorPermission.GUARANTEES_ISSUE_CERTIFICATIONS, MemberPermission.GUARANTEES_ISSUE_CERTIFICATIONS, po.getBuyer().getMemberGroup()).hasPermission();
        if (hasPermission) {
            return po;
        }
        boolean bl = manages = this.permissionService.manages(po.getSeller()) || this.permissionService.manages(po.getBuyer());
        if (!manages) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission().admin(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS).member(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, MemberPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).operator(OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, OperatorPermission.GUARANTEES_SELL_WITH_PAYMENT_OBLIGATIONS).check();
        return po;
    }

    @Override
    public int remove(Long paymentObligationId) {
        PaymentObligation paymentObligation = this.paymentObligationService.load(paymentObligationId, new Relationship[0]);
        if (this.canDelete(paymentObligation)) {
            return this.paymentObligationService.remove(paymentObligationId);
        }
        throw new PermissionDeniedException();
    }

    @Override
    public PaymentObligation save(PaymentObligation paymentObligation, boolean validateBeforeSave) {
        Member seller = this.fetchService.fetch(paymentObligation.getSeller(), Element.Relationships.GROUP);
        this.permissionService.permission(paymentObligation.getBuyer()).memberFor(MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, seller.getGroup()).operatorFor(OperatorPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, MemberPermission.GUARANTEES_BUY_WITH_PAYMENT_OBLIGATIONS, paymentObligation.getSeller().getGroup()).check();
        if (!paymentObligation.isTransient()) {
            PaymentObligation savedPO = this.paymentObligationService.load(paymentObligation.getId(), new Relationship[0]);
            PermissionHelper.checkEquals(PaymentObligation.Status.REGISTERED, savedPO.getStatus());
            PermissionHelper.checkEquals(PaymentObligation.Status.REGISTERED, paymentObligation.getStatus());
        }
        return this.paymentObligationService.save(paymentObligation, true);
    }

    @Override
    public List<PaymentObligation> search(PaymentObligationQuery queryParameters) {
        boolean isSeller = this.guaranteeService.isSeller();
        boolean isBuyer = this.guaranteeService.isBuyer();
        boolean adminCanView = this.hasPermission(AdminMemberPermission.GUARANTEES_VIEW_PAYMENT_OBLIGATIONS);
        if (!(isBuyer || isSeller || adminCanView)) {
            throw new PermissionDeniedException();
        }
        if (isBuyer && isSeller) {
            queryParameters.setLoggedMember((Member)LoggedUser.accountOwner());
        } else if (isBuyer) {
            queryParameters.setBuyer((Member)LoggedUser.accountOwner());
        } else if (isSeller) {
            queryParameters.setSeller((Member)LoggedUser.accountOwner());
            List<PaymentObligation.Status> sellerStatusToFilter = Arrays.asList(this.paymentObligationService.getSellerStatusToFilter());
            if (sellerStatusToFilter.isEmpty()) {
                return Collections.emptyList();
            }
            if (CollectionUtils.isEmpty(queryParameters.getStatusList())) {
                queryParameters = (PaymentObligationQuery)queryParameters.clone();
                queryParameters.setStatusList(sellerStatusToFilter);
            } else {
                for (PaymentObligation.Status st : queryParameters.getStatusList()) {
                    if (sellerStatusToFilter.contains(st)) continue;
                    throw new IllegalArgumentException("Payment Obligation status not allowed to filter by: " + st);
                }
            }
        } else {
            queryParameters.setManagedMemberGroups(this.permissionService.getManagedMemberGroups());
        }
        return this.paymentObligationService.search(queryParameters);
    }

    public void setGuaranteeServiceLocal(GuaranteeServiceLocal guaranteeService) {
        this.guaranteeService = guaranteeService;
    }

    public void setPaymentObligationServiceLocal(PaymentObligationServiceLocal paymentObligationService) {
        this.paymentObligationService = paymentObligationService;
    }

    @Override
    public void validate(PaymentObligation paymentObligation) {
        this.paymentObligationService.validate(paymentObligation);
    }
}

