/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.pos;

import com.mysql.jdbc.StringUtils;
import nl.strohalm.cyclos.dao.access.WrongCredentialAttemptsDAO;
import nl.strohalm.cyclos.dao.accounts.pos.MemberPosDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.Channel;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.access.exceptions.BlockedCredentialsException;
import nl.strohalm.cyclos.services.access.exceptions.InvalidCredentialsException;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosServiceLocal;
import nl.strohalm.cyclos.services.accounts.pos.PosServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;

public class MemberPosServiceImpl
implements MemberPosServiceLocal {
    private FetchServiceLocal fetchService;
    private MemberPosDAO memberPosDao;
    private PosServiceLocal posService;
    private WrongCredentialAttemptsDAO wrongCredentialAttemptsDao;
    private MemberNotificationHandler memberNotificationHandler;
    private AccessServiceLocal accessService;

    @Override
    public MemberPos blockMemberPos(MemberPos memberPos) {
        memberPos.setStatus(MemberPos.Status.BLOCKED);
        this.memberPosDao.update(memberPos);
        this.posService.generateLog(memberPos.getPos());
        return memberPos;
    }

    @Override
    public MemberPos changePin(MemberPos memberPos, String pin) {
        boolean generateLog = false;
        if (memberPos.getPosPin() == null || StringUtils.isEmptyOrWhitespaceOnly((String)memberPos.getPosPin())) {
            memberPos.setStatus(MemberPos.Status.ACTIVE);
            generateLog = true;
        }
        memberPos.setPosPin(pin);
        this.memberPosDao.update(memberPos);
        if (generateLog) {
            this.posService.generateLog(memberPos.getPos());
        }
        return memberPos;
    }

    @Override
    public void checkPin(MemberPos memberPos, String pin) throws InvalidCredentialsException, BlockedCredentialsException {
        if ((memberPos = this.fetchService.fetch(memberPos, MemberPos.Relationships.POS)).getStatus() == MemberPos.Status.PIN_BLOCKED) {
            memberPos = this.fetchService.fetch(memberPos, RelationshipHelper.nested(MemberPos.Relationships.MEMBER, Element.Relationships.USER));
            throw new BlockedCredentialsException(Channel.Credentials.PIN, memberPos.getMember().getUser());
        }
        String posPin = memberPos.getPosPin();
        if (posPin == null || !posPin.equalsIgnoreCase(pin)) {
            Member member = this.fetchService.fetch(memberPos.getMember(), Element.Relationships.GROUP, Element.Relationships.USER);
            MemberGroupSettings memberSettings = member.getMemberGroup().getMemberSettings();
            int maxTries = memberSettings.getMaxPinWrongTries();
            this.wrongCredentialAttemptsDao.record(memberPos);
            int wrongAttempts = this.wrongCredentialAttemptsDao.count(this.accessService.wrongAttemptsLimit(), memberPos);
            if (wrongAttempts == maxTries) {
                memberPos.setStatus(MemberPos.Status.PIN_BLOCKED);
                this.memberPosDao.update(memberPos);
                this.posService.generateLog(memberPos.getPos());
                this.memberNotificationHandler.posPinBlockedNotification(memberPos);
                throw new BlockedCredentialsException(Channel.Credentials.PIN, member.getUser());
            }
            throw new InvalidCredentialsException(Channel.Credentials.PIN, member.getUser());
        }
        this.wrongCredentialAttemptsDao.clear(memberPos);
    }

    public MemberPosDAO getMemberPosDao() {
        return this.memberPosDao;
    }

    @Override
    public MemberPos load(Long id, Relationship ... fetch) {
        return (MemberPos)this.memberPosDao.load(id, fetch);
    }

    @Override
    public void save(MemberPos memberPos) {
        this.memberPosDao.update(memberPos, true);
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMemberPosDao(MemberPosDAO memberPosDao) {
        this.memberPosDao = memberPosDao;
    }

    public void setPosServiceLocal(PosServiceLocal posService) {
        this.posService = posService;
    }

    public void setWrongCredentialAttemptsDao(WrongCredentialAttemptsDAO wrongCredentialAttemptsDao) {
        this.wrongCredentialAttemptsDao = wrongCredentialAttemptsDao;
    }

    @Override
    public MemberPos unblockMemberPos(MemberPos memberPos) {
        memberPos.setStatus(MemberPos.Status.ACTIVE);
        this.memberPosDao.update(memberPos);
        this.posService.generateLog(memberPos.getPos());
        return memberPos;
    }

    @Override
    public MemberPos unblockPosPin(MemberPos memberPos) {
        this.wrongCredentialAttemptsDao.clear(memberPos);
        this.unblockMemberPos(memberPos);
        return memberPos;
    }
}

