/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.pos;

import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosService;
import nl.strohalm.cyclos.services.accounts.pos.MemberPosServiceLocal;

public class MemberPosServiceSecurity
extends BaseServiceSecurity
implements MemberPosService {
    private MemberPosServiceLocal memberPosService;

    @Override
    public MemberPos blockMemberPos(MemberPos memberPos) {
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_BLOCK).broker(BrokerPermission.POS_BLOCK).member(new MemberPermission[0]).check();
        return this.memberPosService.blockMemberPos(memberPos);
    }

    @Override
    public MemberPos changePin(MemberPos memberPos, String pin) {
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_CHANGE_PIN).broker(BrokerPermission.POS_CHANGE_PIN).member(new MemberPermission[0]).check();
        return this.memberPosService.changePin(memberPos, pin);
    }

    @Override
    public MemberPos load(Long id, Relationship ... fetch) {
        MemberPos memberPos = this.memberPosService.load(id, fetch);
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_VIEW).broker(BrokerPermission.POS_VIEW).member(new MemberPermission[0]).check();
        return memberPos;
    }

    @Override
    public void save(MemberPos memberPos) {
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_MANAGE).broker(BrokerPermission.POS_MANAGE).member(new MemberPermission[0]).check();
        this.memberPosService.save(memberPos);
    }

    public void setMemberPosServiceLocal(MemberPosServiceLocal memberPosService) {
        this.memberPosService = memberPosService;
    }

    @Override
    public MemberPos unblockMemberPos(MemberPos memberPos) {
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_BLOCK).broker(BrokerPermission.POS_BLOCK).member(new MemberPermission[0]).check();
        return this.memberPosService.unblockMemberPos(memberPos);
    }

    @Override
    public MemberPos unblockPosPin(MemberPos memberPos) {
        this.permissionService.permission(memberPos.getMember()).admin(AdminMemberPermission.POS_UNBLOCK_PIN).broker(BrokerPermission.POS_UNBLOCK_PIN).member(new MemberPermission[0]).check();
        return this.memberPosService.unblockPosPin(memberPos);
    }
}

