/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.pos;

import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.dao.accounts.pos.MemberPosDAO;
import nl.strohalm.cyclos.dao.accounts.pos.PosDAO;
import nl.strohalm.cyclos.dao.accounts.pos.PosLogDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.pos.PosLog;
import nl.strohalm.cyclos.entities.accounts.pos.PosQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.accounts.AccountServiceLocal;
import nl.strohalm.cyclos.services.accounts.pos.PosServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class PosServiceImpl
implements PosServiceLocal {
    private PosDAO posDao;
    private PosLogDAO posLogDao;
    private MemberPosDAO memberPosDao;
    private PermissionServiceLocal permissionService;
    private AlertServiceLocal alertService;
    private AccountServiceLocal accountService;

    @Override
    public Pos assignPos(Member member, Long posId) {
        if (!this.accountService.hasAccounts(member)) {
            throw new ValidationException("memberPos.assign.memberWithoutAccount", new Object[0]);
        }
        MemberPos memberPos = new MemberPos();
        Pos pos = this.load(posId, RelationshipHelper.nested(Pos.Relationships.MEMBER_POS, MemberPos.Relationships.MEMBER));
        memberPos.setMember(member);
        memberPos.setStatus(MemberPos.Status.PENDING);
        memberPos.setDate(Calendar.getInstance());
        MemberGroupSettings mgs = new MemberGroupSettings();
        memberPos.setAllowMakePayment(mgs.isAllowMakePayment());
        memberPos.setMaxSchedulingPayments(mgs.getMaxSchedulingPayments());
        memberPos.setNumberOfCopies(mgs.getNumberOfCopies());
        memberPos.setResultPageSize(mgs.getResultPageSize());
        memberPos.setPos(pos);
        this.memberPosDao.insert(memberPos);
        pos.setMemberPos(memberPos);
        pos.setStatus(Pos.Status.ASSIGNED);
        this.posDao.update(pos);
        this.generateLog(pos);
        return pos;
    }

    @Override
    public void deletePos(Long ... ids) {
        this.posDao.delete(ids);
    }

    @Override
    public Pos discardPos(Long posId) {
        Pos pos = this.load(posId, Pos.Relationships.MEMBER_POS);
        pos.setStatus(Pos.Status.DISCARDED);
        long memberPosId = 0L;
        if (pos.getMemberPos() != null && pos.getMemberPos().getId() != null) {
            memberPosId = pos.getMemberPos().getId();
        }
        pos.setMemberPos(null);
        this.posDao.update(pos);
        if (memberPosId > 0L) {
            this.memberPosDao.delete(memberPosId);
        }
        this.generateLog(pos);
        return pos;
    }

    @Override
    public void generateLog(Pos pos) {
        PosLog posLog = new PosLog();
        if (LoggedUser.hasUser()) {
            posLog.setBy((Element)LoggedUser.element());
        }
        posLog.setPos(pos);
        posLog.setDate(Calendar.getInstance());
        posLog.setPosStatus(pos.getStatus());
        if (pos.getMemberPos() != null) {
            posLog.setAssignedTo(pos.getMemberPos().getMember());
            posLog.setMemberPosStatus(pos.getMemberPos().getStatus());
        }
        this.posLogDao.insert(posLog);
    }

    @Override
    public Pos load(Long id, Relationship ... fetch) {
        return (Pos)this.posDao.load(id, fetch);
    }

    @Override
    public Pos loadByPosId(String posId, Relationship ... fetch) {
        return this.posDao.loadByPosId(posId, fetch);
    }

    @Override
    public void notifyBlockedPosUsed(Pos pos, String remoteAddress) {
        this.alertService.create(pos.getMemberPos().getMember(), MemberAlert.Alerts.BLOCKED_POS_USED, pos.getPosId(), remoteAddress);
    }

    @Override
    public Pos save(Pos pos) {
        this.validate(pos);
        if (pos.isTransient()) {
            pos.setStatus(Pos.Status.UNASSIGNED);
            pos = this.posDao.insert(pos, true);
        } else {
            pos = this.posDao.update(pos, true);
        }
        return pos;
    }

    @Override
    public List<Pos> search(PosQuery query) {
        return this.posDao.search(query);
    }

    public void setAccountServiceLocal(AccountServiceLocal accountService) {
        this.accountService = accountService;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setMemberPosDao(MemberPosDAO memberPosDao) {
        this.memberPosDao = memberPosDao;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPosDao(PosDAO posDao) {
        this.posDao = posDao;
    }

    public void setPosLogDao(PosLogDAO posLogDao) {
        this.posLogDao = posLogDao;
    }

    @Override
    public void unassignAllMemberPos(Member member) {
        List<Pos> userPos = this.posDao.getAllMemberPos(member);
        for (Pos pos : userPos) {
            this.unassignPos(pos.getId());
        }
    }

    @Override
    public Pos unassignPos(Long posId) {
        Pos pos = this.load(posId, Pos.Relationships.MEMBER_POS);
        pos.setStatus(Pos.Status.UNASSIGNED);
        long memberPosId = pos.getMemberPos().getId();
        pos.setMemberPos(null);
        this.posDao.update(pos);
        this.memberPosDao.delete(memberPosId);
        this.generateLog(pos);
        return pos;
    }

    @Override
    public void validate(Pos pos) {
        this.getValidator(pos).validate(pos);
    }

    private Validator getValidator(Pos pos) {
        Validator validator = new Validator("pos");
        Validator.Property posId = validator.property("posId");
        posId.required().maxLength(64);
        if (pos.isTransient() && pos.getPosId() != null) {
            try {
                this.posDao.loadByPosId(pos.getPosId(), new Relationship[0]);
                throw new ValidationException("pos.error.posIdExists", "");
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        if (pos.getMemberPos() != null && pos.getMemberPos().getId() != null && (LoggedUser.isBroker() && this.permissionService.hasPermission(BrokerPermission.POS_CHANGE_PARAMETERS) || LoggedUser.isAdministrator() && this.permissionService.hasPermission(AdminMemberPermission.POS_CHANGE_PARAMETERS) || !LoggedUser.isBroker() && LoggedUser.isMember())) {
            validator.property("memberPos.allowMakePayment").key("memberPos.allowMakePayment").required();
            validator.property("memberPos.maxSchedulingPayments").key("memberPos.maxSchedulingPayments").required();
            validator.property("memberPos.numberOfCopies").key("memberPos.numberOfCopies").required();
            validator.property("memberPos.resultPageSize").key("memberPos.resultPageSize").required();
        }
        return validator;
    }
}

