/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.pos;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.pos.MemberPos;
import nl.strohalm.cyclos.entities.accounts.pos.Pos;
import nl.strohalm.cyclos.entities.accounts.pos.PosQuery;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.pos.PosService;
import nl.strohalm.cyclos.services.accounts.pos.PosServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;

public class PosServiceSecurity
extends BaseServiceSecurity
implements PosService {
    private PosServiceLocal posService;

    @Override
    public Pos assignPos(Member member, Long posId) {
        if (this.posService.load(posId, new Relationship[0]).getStatus() == Pos.Status.DISCARDED) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission(member).admin(AdminMemberPermission.POS_ASSIGN).broker(BrokerPermission.POS_ASSIGN).check();
        this.checkManage(posId);
        return this.posService.assignPos(member, posId);
    }

    @Override
    public void deletePos(Long ... ids) {
        this.permissionService.permission().admin(AdminMemberPermission.POS_MANAGE).broker(BrokerPermission.POS_MANAGE).check();
        for (Long posId : ids) {
            this.checkManage(posId);
        }
        this.posService.deletePos(ids);
    }

    @Override
    public Pos discardPos(Long posId) {
        this.permissionService.permission().admin(AdminMemberPermission.POS_DISCARD).broker(BrokerPermission.POS_DISCARD).member(new MemberPermission[0]).check();
        this.checkManage(true, posId);
        return this.posService.discardPos(posId);
    }

    @Override
    public Pos load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminMemberPermission.POS_VIEW).broker(BrokerPermission.POS_VIEW).member(new MemberPermission[0]).check();
        this.checkManage(true, id);
        return this.posService.load(id, fetch);
    }

    @Override
    public Pos loadByPosId(String posId, Relationship ... fetch) {
        Pos pos = this.posService.loadByPosId(posId, fetch);
        this.permissionService.permission().admin(AdminMemberPermission.POS_VIEW).broker(BrokerPermission.POS_VIEW).member(new MemberPermission[0]).check();
        this.checkManage(true, pos.getId());
        return pos;
    }

    @Override
    public Pos save(Pos pos) {
        this.permissionService.permission().admin(AdminMemberPermission.POS_MANAGE).broker(BrokerPermission.POS_MANAGE).member(new MemberPermission[0]).check();
        if (!pos.isTransient()) {
            this.checkManage(true, pos.getId());
        }
        return this.posService.save(pos);
    }

    @Override
    public List<Pos> search(PosQuery query) {
        if (!this.permissionService.hasPermission(AdminMemberPermission.POS_VIEW, BrokerPermission.POS_VIEW)) {
            return Collections.emptyList();
        }
        if (LoggedUser.isAdministrator()) {
            query.setManagedBy((AdminGroup)LoggedUser.group());
        } else if (LoggedUser.isBroker()) {
            query.setBroker((Member)LoggedUser.element());
        }
        return this.posService.search(query);
    }

    public void setPosServiceLocal(PosServiceLocal posService) {
        this.posService = posService;
    }

    @Override
    public Pos unassignPos(Long posId) {
        this.permissionService.permission().admin(AdminMemberPermission.POS_ASSIGN).broker(BrokerPermission.POS_ASSIGN).check();
        this.checkManage(posId);
        return this.posService.unassignPos(posId);
    }

    @Override
    public void validate(Pos pos) {
        this.posService.validate(pos);
    }

    private void checkManage(boolean isMemberRequired, Long posId) {
        Pos pos = this.posService.load(posId, RelationshipHelper.nested(Pos.Relationships.MEMBER_POS, MemberPos.Relationships.MEMBER));
        if (pos.getMemberPos() != null) {
            Member currentMember = pos.getMemberPos().getMember();
            this.permissionService.checkManages(currentMember);
        } else if (isMemberRequired && LoggedUser.isMember() && !LoggedUser.isBroker()) {
            throw new PermissionDeniedException();
        }
    }

    private void checkManage(Long posId) {
        this.checkManage(false, posId);
    }
}

