/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.rates;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.utils.DataObject;

public class RatesDTO
extends DataObject
implements Rated {
    private static final long serialVersionUID = 1286727551181755315L;
    private Calendar emissionDate;
    private Calendar expirationDate;
    private BigDecimal iRate;
    private Calendar generalRawRate;
    private BigDecimal generalRate;
    private Calendar date;
    private Account account;
    private BigDecimal amount;
    private BigDecimal rateBalanceCorrection;
    private Currency currency;

    public static RatesDTO createSetOfUnitsForMerge(BigDecimal amount, BigDecimal rate, Currency currency) {
        RatesDTO instance = new RatesDTO();
        instance.setAmount(amount);
        instance.setGeneralRate(rate);
        instance.setCurrency(currency);
        return instance;
    }

    public static RatesDTO createSetOfUnitsForMerge(BigDecimal amount, Calendar rawRate, Currency currency) {
        RatesDTO instance = new RatesDTO();
        instance.setAmount(amount);
        instance.setGeneralRawRate(rawRate);
        instance.setCurrency(currency);
        return instance;
    }

    public Account getAccount() {
        return this.account;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Calendar getDate() {
        return this.date;
    }

    @Override
    public Calendar getEmissionDate() {
        return this.emissionDate;
    }

    @Override
    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public BigDecimal getGeneralRate() {
        return this.generalRate;
    }

    public Calendar getGeneralRawRate() {
        return this.generalRawRate;
    }

    @Override
    public BigDecimal getiRate() {
        return this.iRate;
    }

    public BigDecimal getRateBalanceCorrection() {
        return this.rateBalanceCorrection;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setEmissionDate(Calendar emissionDate) {
        this.emissionDate = emissionDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setGeneralRate(BigDecimal generalRate) {
        this.generalRate = generalRate;
    }

    public void setGeneralRawRate(Calendar generalRawRate) {
        this.generalRawRate = generalRawRate;
    }

    public void setiRate(BigDecimal iRate) {
        this.iRate = iRate;
    }

    public void setRateBalanceCorrection(BigDecimal rateBalanceCorrection) {
        this.rateBalanceCorrection = rateBalanceCorrection;
    }
}

