/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.accounts.rates;

import java.math.BigDecimal;
import java.util.Calendar;
import nl.strohalm.cyclos.entities.accounts.AccountRates;
import nl.strohalm.cyclos.entities.accounts.Rated;
import nl.strohalm.cyclos.services.accounts.rates.RatesDTO;
import nl.strohalm.cyclos.utils.DataObject;

public class RatesResultDTO
extends DataObject
implements Rated {
    private static final long serialVersionUID = 204246198199725208L;
    private BigDecimal aRate;
    private BigDecimal dRate;
    private BigDecimal iRate;
    private Calendar emissionDate;
    private Calendar expirationDate;
    private BigDecimal virtualRatedBalance;
    private BigDecimal rateBalanceCorrection;
    private Calendar date;

    public RatesResultDTO() {
    }

    public RatesResultDTO(AccountRates accountRates) {
        if (accountRates != null) {
            this.emissionDate = accountRates.getEmissionDate();
            this.expirationDate = accountRates.getExpirationDate();
            this.iRate = accountRates.getiRate();
            this.rateBalanceCorrection = accountRates.getRateBalanceCorrection();
            if (accountRates.getLastTransfer() != null) {
                this.date = accountRates.getLastTransfer().getProcessDate();
            }
        }
    }

    public RatesResultDTO(RatesDTO ratesDTO) {
        if (ratesDTO != null) {
            this.emissionDate = ratesDTO.getEmissionDate();
            this.expirationDate = ratesDTO.getExpirationDate();
            this.iRate = ratesDTO.getiRate();
            this.rateBalanceCorrection = ratesDTO.getRateBalanceCorrection();
            this.date = ratesDTO.getDate();
        }
    }

    public BigDecimal getaRate() {
        return this.aRate;
    }

    public Calendar getDate() {
        return this.date;
    }

    public BigDecimal getdRate() {
        return this.dRate;
    }

    @Override
    public Calendar getEmissionDate() {
        return this.emissionDate;
    }

    @Override
    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    public BigDecimal getiRate() {
        return this.iRate;
    }

    public BigDecimal getRateBalanceCorrection() {
        return this.rateBalanceCorrection;
    }

    public BigDecimal getVirtualRatedBalance() {
        return this.virtualRatedBalance;
    }

    public void setaRate(BigDecimal aRate) {
        this.aRate = aRate;
    }

    public void setDate(Calendar date) {
        this.date = date;
    }

    public void setdRate(BigDecimal dRate) {
        this.dRate = dRate;
    }

    public void setEmissionDate(Calendar emissionDate) {
        this.emissionDate = emissionDate;
    }

    public void setExpirationDate(Calendar expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setiRate(BigDecimal iRate) {
        this.iRate = iRate;
    }

    public void setRateBalanceCorrection(BigDecimal rateBalanceCorrection) {
        this.rateBalanceCorrection = rateBalanceCorrection;
    }

    public void setRates(Rated rated) {
        this.emissionDate = rated.getEmissionDate();
        this.expirationDate = rated.getExpirationDate();
        this.iRate = rated.getiRate();
    }

    public void setVirtualRatedBalance(BigDecimal virtualRatedBalance) {
        this.virtualRatedBalance = virtualRatedBalance;
    }
}

