/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.dao.ads.AdCategoryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryQuery;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.ads.AdCategoryServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.XmlHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.AdCategoryHierarchicalVO;
import nl.strohalm.cyclos.webservices.utils.AdHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataIntegrityViolationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AdCategoryServiceImpl
implements AdCategoryServiceLocal {
    private final String ROOT_ELEMENT = "ad-categories";
    private final String CATEGORY_ELEMENT = "ad-category";
    private final String NAME_ATTRIBUTE = "name";
    private final String LEAF_CACHE_KEY = "_LEAF_";
    private final String ROOT_CACHE_KEY = "_ROOT_";
    private AdServiceLocal adService;
    private SettingsServiceLocal settingsService;
    private AdCategoryDAO adCategoryDao;
    private FetchServiceLocal fetchService;
    private CacheManager cacheManager;
    private AdHelper adHelper;

    @Override
    public String exportToXml() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        StringBuilder xml = new StringBuilder();
        xml.append("<?xml version=\"1.0\" encoding=\"").append(localSettings.getCharset()).append("\"?>\n");
        xml.append('<').append("ad-categories").append(">\n");
        List<AdCategory> categories = this.listRoot();
        for (AdCategory adCategory : categories) {
            this.appendXml(xml, adCategory);
        }
        xml.append("</").append("ad-categories").append(">\n");
        return xml.toString();
    }

    @Override
    public List<Long> getActiveCategoriesId() {
        return this.adCategoryDao.getActiveCategoriesId();
    }

    @Override
    public AdCategoryHierarchicalVO getHierarchicalVO(AdCategory category) {
        return this.adHelper.toHierarchicalVO(category);
    }

    @Override
    public void importFromXml(String xml) {
        Document doc = XmlHelper.readDocument(xml);
        Element root = doc.getDocumentElement();
        int rootOrder = 0;
        List<AdCategory> rootCategories = this.listRoot();
        for (AdCategory adCategory : rootCategories) {
            Integer order = adCategory.getOrder();
            if (order == null || order <= rootOrder) continue;
            rootOrder = order;
        }
        List<Element> childen = XmlHelper.getChilden(root, "ad-category");
        for (Element elem : childen) {
            this.importCategory(null, ++rootOrder, elem);
        }
        this.invalidateCache();
    }

    @Override
    public List<AdCategory> listLeaf() {
        return (List)this.getCache().get((Serializable)((Object)"_LEAF_"), new CacheCallback(){

            @Override
            public Object retrieve() {
                AdCategoryQuery query = new AdCategoryQuery();
                ArrayList<AdCategory> categories = new ArrayList<AdCategory>();
                for (AdCategory category : AdCategoryServiceImpl.this.adCategoryDao.searchLeafAdCategories(query)) {
                    categories.add(AdCategoryServiceImpl.this.fetch(category));
                }
                return categories;
            }
        });
    }

    @Override
    public List<AdCategory> listRoot() {
        return (List)this.getCache().get((Serializable)((Object)"_ROOT_"), new CacheCallback(){

            @Override
            public Object retrieve() {
                AdCategoryQuery query = new AdCategoryQuery();
                List<AdCategory> raw = AdCategoryServiceImpl.this.adCategoryDao.search(query);
                ArrayList<AdCategory> list = new ArrayList<AdCategory>(raw.size());
                for (AdCategory category : raw) {
                    if ((category = AdCategoryServiceImpl.this.fetch(category)) == null) continue;
                    list.add(category);
                }
                return list;
            }
        });
    }

    @Override
    public AdCategory load(Long id, Relationship ... fetch) {
        return (AdCategory)this.adCategoryDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        AdQuery adQuery = new AdQuery();
        adQuery.setPageForCount();
        for (Long id : ids) {
            adQuery.setCategory(EntityHelper.reference(AdCategory.class, id));
            if (PageHelper.getTotalCount(this.adService.search(adQuery)) <= 0) continue;
            throw new DaoException(new DataIntegrityViolationException("category"));
        }
        this.invalidateCache();
        return this.adCategoryDao.delete(ids);
    }

    @Override
    public AdCategory save(AdCategory category) {
        this.validate(category);
        AdCategory current = null;
        if (category.isTransient()) {
            Integer order = category.getOrder();
            if (order == null || order <= 0) {
                AdCategoryQuery query = new AdCategoryQuery();
                query.setParent(category.getParent());
                int maxOrder = 0;
                for (AdCategory cat : this.adCategoryDao.search(query)) {
                    if (cat.getOrder() <= maxOrder) continue;
                    maxOrder = cat.getOrder();
                }
                category.setOrder(maxOrder + 1);
            }
            current = this.adCategoryDao.insert(category);
            if (category.getParent() != null) {
                category.getParent().getChildren().add(current);
            }
        } else {
            boolean deactivated;
            current = (AdCategory)this.adCategoryDao.load(category.getId(), AdCategory.Relationships.CHILDREN);
            current.setName(category.getName());
            boolean bl = deactivated = current.isActive() && !category.isActive();
            if (deactivated) {
                this.deactivateRecursively(current);
            } else {
                boolean changedActive;
                boolean bl2 = changedActive = current.isActive() != category.isActive();
                if (changedActive) {
                    current.setActive(category.isActive());
                }
                current = this.adCategoryDao.update(current);
            }
        }
        this.invalidateCache();
        return current;
    }

    @Override
    public List<AdCategory> search(AdCategoryQuery query) {
        return this.adCategoryDao.search(query);
    }

    @Override
    public List<AdCategory> searchLeafAdCategories(AdCategoryQuery query) {
        return this.adCategoryDao.searchLeafAdCategories(query);
    }

    public void setAdCategoryDao(AdCategoryDAO adCategoryDao) {
        this.adCategoryDao = adCategoryDao;
    }

    public void setAdHelper(AdHelper adHelper) {
        this.adHelper = adHelper;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    @Override
    public void setOrder(Long[] ids) {
        int index = 0;
        for (Long id : ids) {
            AdCategory adCategory = this.load(id, new Relationship[0]);
            adCategory.setOrder(++index);
            this.adCategoryDao.update(adCategory);
        }
        this.invalidateCache();
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(AdCategory category) throws ValidationException {
        this.getValidator().validate(category);
    }

    private void appendXml(StringBuilder xml, AdCategory adCategory) {
        String indent = StringUtils.repeat((String)"    ", (int)adCategory.getLevel());
        xml.append(String.format("%s<%s %s=\"%s\"", indent, "ad-category", "name", StringEscapeUtils.escapeXml((String)adCategory.getName())));
        Collection<AdCategory> children = adCategory.getChildren();
        if (CollectionUtils.isEmpty(children)) {
            xml.append(" />\n");
        } else {
            xml.append(">\n");
            for (AdCategory child : children) {
                this.appendXml(xml, child);
            }
            xml.append(indent).append("</").append("ad-category").append(">\n");
        }
    }

    private void deactivateRecursively(AdCategory adCategory) {
        adCategory.setActive(false);
        this.adCategoryDao.update(adCategory);
        for (AdCategory child : adCategory.getChildren()) {
            this.deactivateRecursively(child);
        }
    }

    private AdCategory fetch(AdCategory category) {
        if (!(category = this.fetchService.fetch(category, RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT), AdCategory.Relationships.CHILDREN)).isActive()) {
            return null;
        }
        ArrayList<AdCategory> children = new ArrayList<AdCategory>();
        for (AdCategory child : category.getChildren()) {
            if ((child = this.fetch(child)) == null) continue;
            children.add(child);
        }
        category.setChildren(children);
        return category;
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.AdCategories");
    }

    private Validator getValidator() {
        Validator validator = new Validator("adCategory");
        validator.property("name").required().maxLength(100);
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = -8975710041548036332L;

            @Override
            public ValidationError validate(Object object) {
                AdCategory category = (AdCategory)object;
                if (category.isActive()) {
                    for (AdCategory current = AdCategoryServiceImpl.this.fetchService.fetch(category.getParent(), RelationshipHelper.nested(3, (Relationship)AdCategory.Relationships.PARENT)); current != null; current = current.getParent()) {
                        if (current.isActive()) continue;
                        return new ValidationError("adCategory.error.cantActivateCategoryWithInactiveParent", new Object[0]);
                    }
                }
                return null;
            }
        });
        return validator;
    }

    private AdCategory importCategory(AdCategory parent, int order, Element elem) {
        Collection<AdCategory> toCheck = null;
        if (parent == null) {
            toCheck = this.listRoot();
        } else {
            AdCategory cat = this.load(parent.getId(), AdCategory.Relationships.CHILDREN);
            toCheck = cat.getChildren();
        }
        AdCategory matchedChild = null;
        if (toCheck != null) {
            for (AdCategory cat : toCheck) {
                if (!cat.getName().equals(StringUtils.trimToNull((String)elem.getAttribute("name"))) || !cat.isActive()) continue;
                matchedChild = cat;
            }
        }
        AdCategory category = null;
        if (matchedChild != null) {
            category = matchedChild;
        } else {
            category = new AdCategory();
            category.setName(StringUtils.trimToNull((String)elem.getAttribute("name")));
            category.setParent(parent);
            category.setOrder(order);
            category.setActive(true);
            category = this.adCategoryDao.insert(category);
        }
        int childOrder = 0;
        ArrayList<AdCategory> children = new ArrayList<AdCategory>();
        List<Element> childCategories = XmlHelper.getChilden(elem, "ad-category");
        for (Element child : childCategories) {
            AdCategory cat;
            if ((cat = this.importCategory(category, ++childOrder, child)) == null) continue;
            children.add(cat);
        }
        category.setChildren(children);
        return category;
    }

    private void invalidateCache() {
        this.getCache().clear();
        this.adService.invalidateCountersCache();
    }
}

