/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.ads.AdCategoryService;
import nl.strohalm.cyclos.services.ads.AdCategoryServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.AdCategoryHierarchicalVO;

public class AdCategoryServiceSecurity
extends BaseServiceSecurity
implements AdCategoryService {
    private AdCategoryServiceLocal adCategoryService;

    @Override
    public String exportToXml() {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_FILE).check();
        return this.adCategoryService.exportToXml();
    }

    @Override
    public AdCategoryHierarchicalVO getHierarchicalVO(AdCategory category) {
        this.checkViewPermissions();
        AdCategoryHierarchicalVO hierarchicalVO = this.adCategoryService.getHierarchicalVO(category);
        this.filterViewables(hierarchicalVO);
        return hierarchicalVO;
    }

    @Override
    public void importFromXml(String xml) {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_FILE).check();
        this.adCategoryService.importFromXml(xml);
    }

    @Override
    public List<AdCategory> listLeaf() {
        this.checkViewPermissions();
        return this.filterViewables(this.adCategoryService.listLeaf());
    }

    @Override
    public List<AdCategory> listRoot() {
        this.checkViewPermissions();
        return this.filterViewables(this.adCategoryService.listRoot());
    }

    @Override
    public AdCategory load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        this.checkViewPermissions();
        AdCategory result = this.adCategoryService.load(id, fetch);
        if (!this.isViewable(result)) {
            throw new PermissionDeniedException();
        }
        return result;
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_MANAGE).check();
        return this.adCategoryService.remove(ids);
    }

    @Override
    public AdCategory save(AdCategory category) {
        this.checkManagePermissions();
        return this.adCategoryService.save(category);
    }

    @Override
    public List<AdCategory> search(AdCategoryQuery query) {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_VIEW).check();
        return this.adCategoryService.search(query);
    }

    public void setAdCategoryServiceLocal(AdCategoryServiceLocal adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    @Override
    public void setOrder(Long[] fieldIds) {
        this.checkManagePermissions();
        this.adCategoryService.setOrder(fieldIds);
    }

    @Override
    public void validate(AdCategory category) throws ValidationException {
        this.adCategoryService.validate(category);
    }

    private void checkManagePermissions() {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_MANAGE).check();
    }

    private void checkViewPermissions() {
        this.permissionService.permission().admin(AdminSystemPermission.AD_CATEGORIES_VIEW, AdminMemberPermission.ADS_VIEW).broker(BrokerPermission.ADS_VIEW).member(MemberPermission.ADS_VIEW).operator(MemberPermission.ADS_VIEW).check();
    }

    private void filterViewables(AdCategoryHierarchicalVO hierarchicalVO) {
        if (hierarchicalVO != null && hierarchicalVO.getChildren() != null) {
            Iterator<AdCategoryHierarchicalVO> iterator = hierarchicalVO.getChildren().iterator();
            while (iterator.hasNext()) {
                AdCategoryHierarchicalVO cat = iterator.next();
                if (!this.isViewable(cat)) {
                    iterator.remove();
                    continue;
                }
                this.filterViewables(cat);
            }
        }
    }

    private List<AdCategory> filterViewables(List<AdCategory> list) {
        Iterator<AdCategory> iterator = list.iterator();
        while (iterator.hasNext()) {
            AdCategory cat = iterator.next();
            if (this.isViewable(cat)) continue;
            iterator.remove();
        }
        return list;
    }

    private boolean isViewable(AdCategory adCat) {
        if (this.permissionService.hasPermission(AdminSystemPermission.AD_CATEGORIES_VIEW)) {
            return true;
        }
        return adCat.isEnabled();
    }

    private boolean isViewable(AdCategoryHierarchicalVO cat) {
        if (this.permissionService.hasPermission(AdminSystemPermission.AD_CATEGORIES_VIEW)) {
            return true;
        }
        AdCategory adCat = this.load(cat.getId(), new Relationship[0]);
        return adCat.isEnabled();
    }
}

