/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.dao.ads.imports.AdImportDAO;
import nl.strohalm.cyclos.dao.ads.imports.ImportedAdCategoryDAO;
import nl.strohalm.cyclos.dao.ads.imports.ImportedAdDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.MemberUser;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.accounts.Currency;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.entities.ads.imports.AdImportResult;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAd;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdCategory;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdCustomFieldValue;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Administrator;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.ads.AdCategoryServiceLocal;
import nl.strohalm.cyclos.services.ads.AdImportServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.csv.CSVReader;
import nl.strohalm.cyclos.utils.csv.UnknownColumnException;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class AdImportServiceImpl
implements AdImportServiceLocal {
    private FetchServiceLocal fetchService;
    private ElementServiceLocal elementService;
    private AdServiceLocal adService;
    private AdCategoryServiceLocal adCategoryService;
    private SettingsServiceLocal settingsService;
    private AdCustomFieldServiceLocal adCustomFieldService;
    private AdImportDAO adImportDao;
    private ImportedAdDAO importedAdDao;
    private ImportedAdCategoryDAO importedAdCategoryDao;

    @Override
    public List<ImportedAdCategory> getNewCategories(AdImport adImport) {
        return this.importedAdCategoryDao.getLeafCategories(adImport);
    }

    @Override
    public AdImportResult getSummary(AdImport adIimport) {
        AdImportResult result = new AdImportResult();
        ImportedAdQuery query = new ImportedAdQuery();
        query.setAdImport(adIimport);
        query.setPageForCount();
        query.setStatus(ImportedAdQuery.Status.ALL);
        result.setTotal(PageHelper.getTotalCount(this.importedAdDao.search(query)));
        query.setStatus(ImportedAdQuery.Status.ERROR);
        result.setErrors(PageHelper.getTotalCount(this.importedAdDao.search(query)));
        result.setNewCategories(this.importedAdCategoryDao.getLeafCategories(adIimport).size());
        return result;
    }

    @Override
    public AdImport importAds(AdImport adImport, InputStream data) {
        List<String> headers;
        this.getValidator().validate(adImport);
        Currency currency = this.fetchService.fetch(adImport.getCurrency(), new Relationship[0]);
        adImport.setCurrency(currency);
        adImport.setBy((Administrator)LoggedUser.element());
        adImport.setDate(Calendar.getInstance());
        adImport = this.adImportDao.insert(adImport);
        List customFields = this.adCustomFieldService.list();
        HashMap<String, CustomField> customFieldMap = new HashMap<String, CustomField>(customFields.size());
        for (AdCustomField customField : customFields) {
            customFieldMap.put(customField.getInternalName().toLowerCase(), this.fetchService.fetch(customField, CustomField.Relationships.POSSIBLE_VALUES));
        }
        LinkedHashMap<String, AdCategory> existingAdCategoryMap = new LinkedHashMap<String, AdCategory>();
        List<AdCategory> rootCategories = this.adCategoryService.listRoot();
        for (AdCategory adCategory : rootCategories) {
            this.appendCategory(adCategory, existingAdCategoryMap);
        }
        LinkedHashMap<String, ImportedAdCategory> importedAdCategoryMap = new LinkedHashMap<String, ImportedAdCategory>();
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        char stringQuote = CoercionHelper.coerce(Character.TYPE, localSettings.getCsvStringQuote().getValue()).charValue();
        char valueSeparator = CoercionHelper.coerce(Character.TYPE, localSettings.getCsvValueSeparator().getValue()).charValue();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader(data, localSettings.getCharset()));
            headers = CSVReader.readLine(in, stringQuote, valueSeparator);
        }
        catch (Exception e) {
            throw new ValidationException("adImport.invalidFormat", new Object[0]);
        }
        try {
            List<String> values;
            CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
            int lineNumber = 2;
            while ((values = CSVReader.readLine(in, stringQuote, valueSeparator)) != null) {
                if (values.isEmpty()) continue;
                this.importAd(adImport, lineNumber, existingAdCategoryMap, importedAdCategoryMap, customFieldMap, localSettings, headers, values);
                ++lineNumber;
                cacheCleaner.clearCache();
            }
        }
        catch (IOException e) {
            throw new ValidationException("adImport.errorReading", new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((Reader)in);
        }
        return adImport;
    }

    @Override
    public AdImport load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        return (AdImport)this.adImportDao.load(id, fetch);
    }

    @Override
    public void processImport(AdImport adImport) {
        adImport = this.fetchService.fetch(adImport, AdImport.Relationships.CURRENCY);
        HashMap<ImportedAdCategory, AdCategory> importedCategories = new HashMap<ImportedAdCategory, AdCategory>();
        ImportedAdQuery adQuery = new ImportedAdQuery();
        adQuery.fetch(ImportedAd.Relationships.EXISTING_CATEGORY, ImportedAd.Relationships.IMPORTED_CATEGORY, ImportedAd.Relationships.CUSTOM_VALUES);
        adQuery.setAdImport(adImport);
        adQuery.setStatus(ImportedAdQuery.Status.SUCCESS);
        int count = 0;
        List<ImportedAd> importedAds = this.importedAdDao.search(adQuery);
        for (ImportedAd importedAd : importedAds) {
            this.processAd(adImport, importedAd, importedCategories);
            if (count % 20 == 0) {
                this.fetchService.clearCache();
            }
            ++count;
        }
        this.adImportDao.delete(adImport.getId());
    }

    @Override
    public void purgeOld(Calendar time) {
        time = new TimePeriod(1, TimePeriod.Field.DAYS).remove(time);
        for (AdImport adImport : this.adImportDao.listBefore(time)) {
            this.adImportDao.delete(adImport.getId());
        }
    }

    @Override
    public List<ImportedAd> searchImportedAds(ImportedAdQuery params) {
        return this.importedAdDao.search(params);
    }

    public void setAdCategoryServiceLocal(AdCategoryServiceLocal adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    public void setAdImportDao(AdImportDAO adImportDao) {
        this.adImportDao = adImportDao;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setImportedAdCategoryDao(ImportedAdCategoryDAO importedAdCategoryDao) {
        this.importedAdCategoryDao = importedAdCategoryDao;
    }

    public void setImportedAdDao(ImportedAdDAO importedAdDao) {
        this.importedAdDao = importedAdDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(AdImport AdImport2) throws ValidationException {
        this.getValidator().validate(AdImport2);
    }

    private void appendCategory(AdCategory adCategory, Map<String, AdCategory> existingAdCategoryMap) {
        if (existingAdCategoryMap.values().contains(adCategory)) {
            return;
        }
        existingAdCategoryMap.put(adCategory.getFullName(), adCategory);
        for (AdCategory child : adCategory.getChildren()) {
            this.appendCategory(child, existingAdCategoryMap);
        }
    }

    private Validator getValidator() {
        Validator validator = new Validator();
        validator.property("currency").required();
        return validator;
    }

    private Object handleCategory(ImportedAd ad, String value, Map<String, AdCategory> existingAdCategoryMap, Map<String, ImportedAdCategory> importedAdCategoryMap) {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        String[] parts = StringUtils.split((String)value, (char)':');
        Entity category = null;
        String fullPath = null;
        if (parts.length > 3) {
            ad.setStatus(ImportedAd.Status.TOO_MANY_CATEGORY_LEVELS);
            return null;
        }
        for (String part : parts) {
            if ((part = StringUtils.trimToNull((String)part)) == null) {
                ad.setStatus(ImportedAd.Status.INVALID_CATEGORY);
                return null;
            }
            AdCategory existingCategory = existingAdCategoryMap.get(fullPath = fullPath == null ? part : fullPath + ": " + part);
            if (existingCategory != null) {
                category = existingCategory;
                continue;
            }
            ImportedAdCategory importedCategory = importedAdCategoryMap.get(fullPath);
            if (importedCategory == null) {
                importedCategory = new ImportedAdCategory();
                importedCategory.setAdImport(ad.getImport());
                importedCategory.setName(part);
                if (category instanceof AdCategory) {
                    importedCategory.setExistingParent((AdCategory)category);
                } else if (category instanceof ImportedAdCategory) {
                    importedCategory.setImportedParent((ImportedAdCategory)category);
                }
                importedCategory = this.importedAdCategoryDao.insert(importedCategory);
                importedAdCategoryMap.put(fullPath, importedCategory);
            }
            category = importedCategory;
        }
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importAd(AdImport adImport, int lineNumber, Map<String, AdCategory> existingAdCategoryMap, Map<String, ImportedAdCategory> importedAdCategoryMap, Map<String, CustomField> customFieldMap, LocalSettings localSettings, List<String> headers, List<String> values) {
        HashMap<String, String> customFieldValues = new HashMap<String, String>();
        CalendarConverter dateConverter = localSettings.getRawDateConverter();
        NumberConverter<BigDecimal> numberConverter = localSettings.getNumberConverter();
        ImportedAd ad = new ImportedAd();
        ad.setLineNumber(lineNumber);
        ad.setImport(adImport);
        ad.setStatus(ImportedAd.Status.SUCCESS);
        ad = this.importedAdDao.insert(ad);
        ad.setPublicationPeriod(new Period());
        ad.setExternalPublication(true);
        try {
            Calendar end;
            ad.setCustomValues((Collection<ImportedAdCustomFieldValue>)new ArrayList<ImportedAdCustomFieldValue>());
            for (int i = 0; i < headers.size() && i < values.size(); ++i) {
                boolean valueIsTrue;
                String field = StringUtils.trimToEmpty((String)headers.get(i)).toLowerCase();
                String value = StringUtils.trimToNull((String)values.get(i));
                boolean bl = valueIsTrue = "true".equalsIgnoreCase(value) || "1".equals(value);
                if ("owner".equals(field)) {
                    if (value == null) continue;
                    try {
                        MemberUser user = (MemberUser)this.elementService.loadUser(value, RelationshipHelper.nested(User.Relationships.ELEMENT, Element.Relationships.GROUP));
                        ad.setOwner(user.getMember());
                    }
                    catch (Exception e) {
                        ad.setStatus(ImportedAd.Status.INVALID_OWNER);
                        ad.setErrorArgument1(value);
                    }
                    continue;
                }
                if ("title".equals(field)) {
                    ad.setTitle(value);
                    continue;
                }
                if ("description".equals(field)) {
                    ad.setDescription(value);
                    continue;
                }
                if ("html".equals(field)) {
                    ad.setHtml(valueIsTrue);
                    continue;
                }
                if ("publicationstart".equals(field)) {
                    try {
                        ad.getPublicationPeriod().setBegin(dateConverter.valueOf(value));
                        continue;
                    }
                    catch (Exception e) {
                        ad.setStatus(ImportedAd.Status.INVALID_PUBLICATION_START);
                        ad.setErrorArgument1(value);
                        break;
                    }
                }
                if ("publicationend".equals(field)) {
                    try {
                        ad.getPublicationPeriod().setEnd(dateConverter.valueOf(value));
                        continue;
                    }
                    catch (Exception e) {
                        ad.setStatus(ImportedAd.Status.INVALID_PUBLICATION_END);
                        ad.setErrorArgument1(value);
                        break;
                    }
                }
                if ("tradetype".equals(field)) {
                    if (!"search".equalsIgnoreCase(value)) continue;
                    ad.setTradeType(Ad.TradeType.SEARCH);
                    continue;
                }
                if ("external".equals(field)) {
                    ad.setExternalPublication(valueIsTrue);
                    continue;
                }
                if ("price".equals(field)) {
                    try {
                        ad.setPrice((BigDecimal)numberConverter.valueOf(value));
                        if (!BigDecimal.ZERO.equals(ad.getPrice())) continue;
                        ad.setPrice(null);
                        continue;
                    }
                    catch (Exception e) {
                        ad.setStatus(ImportedAd.Status.INVALID_PRICE);
                        ad.setErrorArgument1(value);
                        break;
                    }
                }
                if ("category".equals(field)) {
                    Object category = this.handleCategory(ad, value, existingAdCategoryMap, importedAdCategoryMap);
                    if (category instanceof AdCategory) {
                        ad.setExistingCategory((AdCategory)category);
                        continue;
                    }
                    if (category instanceof ImportedAdCategory) {
                        ad.setImportedCategory((ImportedAdCategory)category);
                        continue;
                    }
                    if (ad.getStatus() == null) continue;
                    ad.setErrorArgument1(value);
                    break;
                }
                if (customFieldMap.containsKey(field)) {
                    ImportedAdCustomFieldValue fieldValue = new ImportedAdCustomFieldValue();
                    fieldValue.setField(customFieldMap.get(field));
                    fieldValue.setValue(value);
                    ad.getCustomValues().add(fieldValue);
                    customFieldValues.put(field, value);
                    continue;
                }
                throw new UnknownColumnException(field);
            }
            if (ad.getStatus() != ImportedAd.Status.SUCCESS) {
                return;
            }
            if (ad.getOwner() == null) {
                ad.setStatus(ImportedAd.Status.MISSING_OWNER);
                return;
            }
            if (ad.getExistingCategory() == null && ad.getImportedCategory() == null) {
                ad.setStatus(ImportedAd.Status.MISSING_CATEGORY);
                return;
            }
            if (ad.getTitle() == null) {
                ad.setStatus(ImportedAd.Status.MISSING_TITLE);
                return;
            }
            if (ad.getDescription() == null) {
                ad.setStatus(ImportedAd.Status.MISSING_DESCRIPTION);
                return;
            }
            MemberGroupSettings groupSettings = ad.getOwner().getMemberGroup().getMemberSettings();
            Calendar begin = ad.getPublicationPeriod().getBegin();
            if (begin == null) {
                begin = Calendar.getInstance();
                ad.getPublicationPeriod().setBegin(begin);
            }
            if ((end = ad.getPublicationPeriod().getEnd()) == null) {
                if (!groupSettings.isEnablePermanentAds()) {
                    ad.setStatus(ImportedAd.Status.MISSING_PUBLICATION_PERIOD);
                    return;
                }
                ad.setPermanent(true);
            } else {
                if (begin.after(end)) {
                    ad.setStatus(ImportedAd.Status.PUBLICATION_BEGIN_AFTER_END);
                    return;
                }
                TimePeriod maxAdPublicationTime = groupSettings.getMaxAdPublicationTime();
                if (!end.before(maxAdPublicationTime.add(begin))) {
                    ad.setStatus(ImportedAd.Status.MAX_PUBLICATION_EXCEEDED);
                    return;
                }
            }
            if (ad.getTradeType() == null) {
                ad.setTradeType(Ad.TradeType.OFFER);
            }
            switch (groupSettings.getExternalAdPublication()) {
                case DISABLED: {
                    ad.setExternalPublication(false);
                    break;
                }
                case ENABLED: {
                    ad.setExternalPublication(true);
                }
            }
            try {
                this.adCustomFieldService.saveValues(ad);
            }
            catch (Exception e) {
                ValidationException vex;
                Map<String, Collection<ValidationError>> errorsByProperty;
                ad.setStatus(ImportedAd.Status.INVALID_CUSTOM_FIELD);
                if (e instanceof ValidationException && MapUtils.isNotEmpty(errorsByProperty = (vex = (ValidationException)e).getErrorsByProperty())) {
                    String fieldName = errorsByProperty.keySet().iterator().next();
                    ad.setErrorArgument1(fieldName);
                    String fieldValue = StringUtils.trimToNull((String)((String)customFieldValues.get(fieldName)));
                    if (fieldValue == null) {
                        ad.setStatus(ImportedAd.Status.MISSING_CUSTOM_FIELD);
                    } else {
                        ad.setErrorArgument2(fieldValue);
                    }
                }
                this.importedAdDao.update(ad);
                return;
            }
        }
        catch (UnknownColumnException e) {
            throw e;
        }
        catch (Exception e) {
            ad.setStatus(ImportedAd.Status.UNKNOWN_ERROR);
            ad.setErrorArgument1(e.toString());
        }
        finally {
            this.importedAdDao.update(ad);
        }
    }

    private void processAd(AdImport adImport, ImportedAd importedAd, Map<ImportedAdCategory, AdCategory> importedCategories) {
        AdCategory category = importedAd.getExistingCategory();
        ImportedAdCategory importedCategory = importedAd.getImportedCategory();
        if (category == null && importedCategory != null) {
            category = this.processCategory(importedCategory, importedCategories);
        }
        Ad ad = new Ad();
        ad.setCategory(category);
        Member owner = this.fetchService.fetch(importedAd.getOwner(), Member.Relationships.IMAGES, Member.Relationships.CUSTOM_VALUES);
        if (owner != null) {
            owner.setCustomValues(this.fetchService.fetch(owner.getCustomValues(), new Relationship[]{CustomFieldValue.Relationships.FIELD, CustomFieldValue.Relationships.POSSIBLE_VALUE}));
            ad.setOwner(owner);
        }
        ad.setTradeType(importedAd.getTradeType());
        ad.setTitle(importedAd.getTitle());
        ad.setDescription(importedAd.getDescription());
        ad.setHtml(importedAd.isHtml());
        ad.setPermanent(importedAd.isPermanent());
        ad.setPublicationPeriod(importedAd.getPublicationPeriod());
        ad.setExternalPublication(importedAd.isExternalPublication());
        ad.setPrice(importedAd.getPrice());
        if (ad.getPrice() != null) {
            ad.setCurrency(adImport.getCurrency());
        }
        ad.setCustomValues((Collection<AdCustomFieldValue>)new ArrayList<AdCustomFieldValue>());
        Collection<ImportedAdCustomFieldValue> importedCustomValues = importedAd.getCustomValues();
        if (importedCustomValues != null) {
            for (ImportedAdCustomFieldValue importedValue : importedCustomValues) {
                CustomField field = importedValue.getField();
                AdCustomFieldValue fieldValue = new AdCustomFieldValue();
                fieldValue.setAd(ad);
                fieldValue.setField(field);
                if (field.getType() == CustomField.Type.ENUMERATED) {
                    fieldValue.setPossibleValue(importedValue.getPossibleValue());
                } else if (field.getType() == CustomField.Type.MEMBER) {
                    fieldValue.setMemberValue(importedValue.getMemberValue());
                } else {
                    fieldValue.setStringValue(importedValue.getStringValue());
                }
                ad.getCustomValues().add(fieldValue);
            }
        }
        ad = this.adService.save(ad);
    }

    private AdCategory processCategory(ImportedAdCategory importedCategory, Map<ImportedAdCategory, AdCategory> importedCategories) {
        AdCategory category = importedCategories.get(importedCategory = this.fetchService.fetch(importedCategory, ImportedAdCategory.Relationships.EXISTING_PARENT, ImportedAdCategory.Relationships.IMPORTED_PARENT));
        if (category == null) {
            AdCategory existingParent = importedCategory.getExistingParent();
            ImportedAdCategory importedParent = importedCategory.getImportedParent();
            if (existingParent == null && importedParent != null) {
                existingParent = this.processCategory(importedParent, importedCategories);
            }
            category = new AdCategory();
            category.setParent(existingParent);
            category.setActive(true);
            category.setName(importedCategory.getName());
            category = this.fetchService.fetch(this.adCategoryService.save(category), new Relationship[0]);
            importedCategories.put(importedCategory, category);
        }
        return category;
    }
}

