/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.io.InputStream;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.imports.AdImport;
import nl.strohalm.cyclos.entities.ads.imports.AdImportResult;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAd;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdCategory;
import nl.strohalm.cyclos.entities.ads.imports.ImportedAdQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.ads.AdImportService;
import nl.strohalm.cyclos.services.ads.AdImportServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class AdImportServiceSecurity
extends BaseServiceSecurity
implements AdImportService {
    private AdImportServiceLocal adImportService;

    @Override
    public List<ImportedAdCategory> getNewCategories(AdImport adImport) {
        this.check();
        return this.adImportService.getNewCategories(adImport);
    }

    @Override
    public AdImportResult getSummary(AdImport adIimport) {
        this.check();
        return this.adImportService.getSummary(adIimport);
    }

    @Override
    public AdImport importAds(AdImport adImport, InputStream data) {
        this.check();
        return this.adImportService.importAds(adImport, data);
    }

    @Override
    public AdImport load(Long id, Relationship ... fetch) throws EntityNotFoundException {
        this.check();
        return this.adImportService.load(id, fetch);
    }

    @Override
    public void processImport(AdImport adImport) {
        this.check();
        this.adImportService.processImport(adImport);
    }

    @Override
    public List<ImportedAd> searchImportedAds(ImportedAdQuery params) {
        this.check();
        return this.adImportService.searchImportedAds(params);
    }

    public void setAdImportServiceLocal(AdImportServiceLocal adImportService) {
        this.adImportService = adImportService;
    }

    @Override
    public void validate(AdImport AdImport2) throws ValidationException {
        this.adImportService.validate(AdImport2);
    }

    private void check() {
        this.permissionService.permission().admin(AdminMemberPermission.ADS_IMPORT).check();
    }
}

