/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.dao.ads.AdDAO;
import nl.strohalm.cyclos.entities.IndexOperation;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AbstractAdQuery;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategory;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterQuery;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterVO;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroupSettings;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.ads.AdCategoryServiceLocal;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.conversion.Transformer;
import nl.strohalm.cyclos.utils.lucene.IndexOperationListener;
import nl.strohalm.cyclos.utils.lucene.IndexOperationRunner;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.DelegatingValidator;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.ads.AdResultPage;
import nl.strohalm.cyclos.webservices.ads.FullTextAdSearchParameters;
import nl.strohalm.cyclos.webservices.model.AdVO;
import nl.strohalm.cyclos.webservices.model.GeneralAdVO;
import nl.strohalm.cyclos.webservices.model.MyAdVO;
import nl.strohalm.cyclos.webservices.utils.AdHelper;
import nl.strohalm.cyclos.webservices.utils.QueryHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AdServiceImpl
implements AdServiceLocal {
    private AdDAO adDao;
    private AdCustomFieldServiceLocal adCustomFieldService;
    private FetchServiceLocal fetchService;
    private AdCategoryServiceLocal adCategoryService;
    private MemberNotificationHandler memberNotificationHandler;
    private PermissionServiceLocal permissionService;
    private SettingsServiceLocal settingsService;
    private CacheManager cacheManager;
    private AdHelper adHelper;
    private MemberCustomFieldServiceLocal memberCustomFieldServiceLocal;
    private QueryHelper queryHelper;
    private MemberServiceLocal memberServiceLocal;
    private CustomFieldHelper customFieldHelper;

    @Override
    public int countExternalAds(Long adCategoryId, Ad.TradeType type) {
        AdQuery query = new AdQuery();
        query.setStatus(Ad.Status.ACTIVE);
        query.setTradeType(type);
        query.setCategory(EntityHelper.reference(AdCategory.class, adCategoryId));
        query.setExternalPublication(true);
        query.setPageForCount();
        return PageHelper.getTotalCount(this.search(query));
    }

    @Override
    public Integer countMembersWithAds(Collection<MemberGroup> memberGroups, Calendar timePoint) {
        return this.adDao.getNumberOfMembersWithAds(timePoint, memberGroups);
    }

    @Override
    public List<Ad> fullTextSearch(FullTextAdQuery query) throws DaoException {
        if (query.getCategory() != null && !this.adCategoryService.getActiveCategoriesId().contains(query.getCategory().getId())) {
            return Collections.emptyList();
        }
        if (query.getCategory() == null) {
            query.setCategoriesIds(this.adCategoryService.getActiveCategoriesId());
        } else {
            query.setCategoriesIds(new LinkedList<Long>());
            query.getCategoriesIds().add(query.getCategory().getId());
        }
        this.setupGroupFilters(query);
        if (!this.applyLoggedUserFilters(query)) {
            return Collections.emptyList();
        }
        query.setAnalyzer(this.settingsService.getLocalSettings().getLanguage().getAnalyzer());
        return this.adDao.fullTextSearch(query);
    }

    @Override
    public AdResultPage getAdResultPage(final FullTextAdSearchParameters params, String memberPrincipal) {
        FullTextAdQuery query = this.adHelper.toFullTextQuery(params);
        if (query.getOwner() == null && StringUtils.isNotEmpty((String)memberPrincipal)) {
            query.setOwner(this.memberServiceLocal.loadByIdOrPrincipal(null, null, memberPrincipal));
        }
        List<Ad> ads = this.fullTextSearch(query);
        return this.queryHelper.toResultPage(AdResultPage.class, ads, new Transformer<Ad, AdVO>(){

            @Override
            public AdVO transform(Ad ad) {
                return AdServiceImpl.this.getAdVO(GeneralAdVO.class, ad, params.getShowAdFields(), params.getShowMemberFields(), true);
            }
        });
    }

    @Override
    public <VO extends AdVO> VO getAdVO(Class<VO> voType, Ad ad, boolean useAdFields, boolean useMemberFields, boolean onlyForAdSearchMemberFields) {
        List<AdCustomField> allAdFields = useAdFields ? this.adCustomFieldService.list() : null;
        List<MemberCustomField> memberFields = null;
        if (useMemberFields) {
            if (onlyForAdSearchMemberFields) {
                memberFields = this.customFieldHelper.onlyForAdSearch(this.memberCustomFieldServiceLocal.list());
            } else {
                memberFields = this.memberCustomFieldServiceLocal.list();
                if (!LoggedUser.isUnrestrictedClient()) {
                    MemberGroup group = LoggedUser.member().getMemberGroup();
                    memberFields = this.customFieldHelper.onlyVisibleFields(memberFields, group);
                }
            }
        }
        return this.adHelper.toVO(voType, ad, allAdFields, memberFields);
    }

    @Override
    public List<AdCategoryWithCounterVO> getCategoriesWithCounters(final AdCategoryWithCounterQuery query) {
        return (List)this.getCountersCache().get(query, new CacheCallback(){

            @Override
            public Object retrieve() {
                List<AdCategory> categories = AdServiceImpl.this.adCategoryService.listRoot();
                return AdServiceImpl.this.adDao.getCategoriesWithCounters(categories, query);
            }
        });
    }

    @Override
    public MyAdVO getMyVO(Ad ad) {
        return this.adHelper.toMyVO(ad);
    }

    @Override
    public Ad getNextAdToNotify() {
        AdQuery query = new AdQuery();
        query.setUniqueResult();
        query.setStatus(Ad.Status.ACTIVE);
        query.setMembersNotified(false);
        query.setSkipOrder(true);
        List<Ad> list = this.search(query);
        Iterator<Ad> iterator = list.iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    @Override
    public Map<Ad.Status, Integer> getNumberOfAds(Calendar date, Member member) {
        EnumMap<Ad.Status, Integer> numberOfAds = new EnumMap<Ad.Status, Integer>(Ad.Status.class);
        AdQuery query = new AdQuery();
        query.setOwner(member);
        query.setPageForCount();
        if (date != null) {
            query.setHistoryDate(date);
            query.setIncludeDeleted(true);
        }
        for (Ad.Status status : Ad.Status.values()) {
            query.setStatus(status);
            int totalCount = PageHelper.getTotalCount(this.search(query));
            numberOfAds.put(status, totalCount);
        }
        return numberOfAds;
    }

    @Override
    public int getNumberOfAds(Collection<MemberGroup> memberGroups, Ad.Status status, Calendar timePoint) {
        return this.adDao.getNumberOfAds(timePoint, memberGroups, status);
    }

    @Override
    public void invalidateCountersCache() {
        if (this.settingsService.getLocalSettings().isShowCountersInAdCategories()) {
            this.getCountersCache().clear();
        }
    }

    @Override
    public boolean isEditable(Ad ad) {
        return this.permissionService.permission(ad.getOwner()).admin(AdminMemberPermission.ADS_MANAGE).broker(BrokerPermission.ADS_MANAGE).member(MemberPermission.ADS_PUBLISH).operator(OperatorPermission.ADS_PUBLISH).hasPermission();
    }

    @Override
    public Ad load(Long id, Relationship ... fetch) {
        return (Ad)this.adDao.load(id, fetch);
    }

    @Override
    public void markMembersNotified(Ad ad) {
        ad = this.load(ad.getId(), new Relationship[0]);
        ad.setMembersNotified(true);
        this.adDao.update(ad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyExpiredAds(Calendar time) {
        AdQuery searchParams = new AdQuery();
        searchParams.setResultType(QueryParameters.ResultType.ITERATOR);
        searchParams.setEndDate(time);
        CacheCleaner cleaner = new CacheCleaner(this.fetchService);
        List<Ad> ads = this.search(searchParams);
        try {
            for (Ad ad : ads) {
                this.memberNotificationHandler.expiredAdNotification(ad);
                cleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(ads);
        }
    }

    @Override
    public void remove(Long id) {
        this.doRemove(id);
    }

    @Override
    public int remove(Long[] ids) {
        return this.doRemove(ids);
    }

    @Override
    public Ad save(Ad ad) {
        MemberGroupSettings.ExternalAdPublication externalAdPublication;
        if (ad.getPrice() == null) {
            ad.setCurrency(null);
        }
        this.validate(ad);
        Collection<AdCustomFieldValue> customValues = ad.getCustomValues();
        ad.setCustomValues((Collection<AdCustomFieldValue>)null);
        Member owner = this.fetchService.fetch(ad.getOwner(), Element.Relationships.GROUP);
        MemberGroup group = owner.getMemberGroup();
        MemberGroupSettings memberSettings = group.getMemberSettings();
        if (!memberSettings.isEnablePermanentAds()) {
            ad.setPermanent(false);
        }
        if ((externalAdPublication = memberSettings.getExternalAdPublication()) == MemberGroupSettings.ExternalAdPublication.DISABLED) {
            ad.setExternalPublication(false);
        } else if (externalAdPublication == MemberGroupSettings.ExternalAdPublication.ENABLED) {
            ad.setExternalPublication(true);
        }
        boolean isInsert = ad.isTransient();
        if (isInsert) {
            int maxAds = owner.getMemberGroup().getMemberSettings().getMaxAdsPerMember();
            AdQuery adQuery = new AdQuery();
            adQuery.setPageForCount();
            adQuery.setOwner(ad.getOwner());
            int currentAds = PageHelper.getTotalCount(this.adDao.search(adQuery));
            if (currentAds >= maxAds) {
                throw new ValidationException("ad.error.maxAds", ad.getOwner().getUsername());
            }
            Calendar now = Calendar.getInstance();
            if (ad.isPermanent()) {
                Period p = new Period(now, null);
                ad.setPublicationPeriod(p);
            }
            ad.setCreationDate(now);
            ad = this.adDao.insert(ad);
        } else {
            Ad old = this.load(ad.getId(), new Relationship[0]);
            ad.setMembersNotified(old.isMembersNotified());
            ad.setCreationDate(old.getCreationDate());
            if (ad.isPermanent()) {
                Period p = new Period(ad.getCreationDate(), null);
                ad.setPublicationPeriod(p);
            }
            ad = this.adDao.update(ad);
        }
        ad.setCustomValues(customValues);
        this.adCustomFieldService.saveValues(ad);
        this.adDao.addToIndex(ad);
        return ad;
    }

    @Override
    public List<Ad> search(AdQuery query) {
        if (!this.applyLoggedUserFilters(query)) {
            return Collections.emptyList();
        }
        this.setupGroupFilters(query);
        return this.adDao.search(query);
    }

    public void setAdCategoryServiceLocal(AdCategoryServiceLocal adCategoryService) {
        this.adCategoryService = adCategoryService;
    }

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    public void setAdDao(AdDAO adDao) {
        this.adDao = adDao;
    }

    public void setAdHelper(AdHelper adHelper) {
        this.adHelper = adHelper;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setIndexOperationRunner(IndexOperationRunner indexOperationRunner) {
        indexOperationRunner.addIndexOperationListener(new IndexOperationListener(){

            @Override
            public void onComplete(IndexOperation operation) {
                IndexOperation.EntityType entityType = operation.getEntityType();
                if (entityType == null || entityType == IndexOperation.EntityType.ADVERTISEMENT) {
                    AdServiceImpl.this.invalidateCountersCache();
                }
            }
        });
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldServiceLocal) {
        this.memberCustomFieldServiceLocal = memberCustomFieldServiceLocal;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberServiceLocal) {
        this.memberServiceLocal = memberServiceLocal;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setQueryHelper(QueryHelper queryHelper) {
        this.queryHelper = queryHelper;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    @Override
    public void validate(Ad ad) throws ValidationException {
        this.getValidator().validate(ad);
    }

    @Override
    public Collection<MemberGroup> visibleGroupsForAds() {
        Collection<MemberGroup> visibleGroups;
        if (LoggedUser.isMember() || LoggedUser.isOperator()) {
            MemberGroup memberGroup = ((Member)LoggedUser.accountOwner()).getMemberGroup();
            visibleGroups = this.fetchService.fetch(memberGroup, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS).getCanViewAdsOfGroups();
        } else {
            visibleGroups = this.permissionService.getVisibleMemberGroups();
        }
        return visibleGroups;
    }

    private boolean applyLoggedUserFilters(AbstractAdQuery query) {
        block13: {
            if (!LoggedUser.hasUser()) break block13;
            if (LoggedUser.isAdministrator()) {
                AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
                Collection<MemberGroup> managesGroups = (adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS)).getManagesGroups();
                if (CollectionUtils.isEmpty(managesGroups)) {
                    return false;
                }
                if (CollectionUtils.isEmpty(query.getGroups())) {
                    query.setGroups(managesGroups);
                } else {
                    Iterator<MemberGroup> iter = query.getGroups().iterator();
                    while (iter.hasNext()) {
                        Group group = iter.next();
                        if (managesGroups.contains(group)) continue;
                        iter.remove();
                    }
                }
            } else {
                MemberGroup group;
                if (query.isMyAds()) {
                    query.setOwner((Member)LoggedUser.accountOwner());
                    return true;
                }
                if (LoggedUser.isOperator()) {
                    Operator operator = (Operator)LoggedUser.element();
                    group = operator.getMember().getMemberGroup();
                } else {
                    group = (MemberGroup)LoggedUser.group();
                }
                group = this.fetchService.fetch(group, MemberGroup.Relationships.CAN_VIEW_ADS_OF_GROUPS);
                Collection<MemberGroup> canViewAdsOfGroups = group.getCanViewAdsOfGroups();
                if (CollectionUtils.isEmpty(canViewAdsOfGroups)) {
                    return false;
                }
                if (CollectionUtils.isEmpty(query.getGroups())) {
                    query.setGroups(canViewAdsOfGroups);
                } else {
                    Iterator<MemberGroup> iter = query.getGroups().iterator();
                    while (iter.hasNext()) {
                        Group currentGroup = iter.next();
                        if (canViewAdsOfGroups.contains(currentGroup)) continue;
                        iter.remove();
                    }
                }
            }
        }
        return true;
    }

    private int doRemove(Long ... ids) {
        int count = this.adDao.delete(ids);
        this.adDao.removeFromIndex(Ad.class, ids);
        return count;
    }

    private Cache getCountersCache() {
        return this.cacheManager.getCache("cyclos.AdCategoriesWithCounters");
    }

    private Validator getValidator() {
        Validator validator = new Validator("ad");
        validator.general(new MaxPublicationTimeValidation());
        validator.property("title").required().maxLength(100);
        validator.property("description").required().add(new MaxAdDescriptionSizeValidation());
        validator.property("price").positiveNonZero();
        validator.property("category").required();
        validator.property("tradeType").required();
        validator.property("owner").required();
        validator.property("publicationPeriod.begin").add(new PublicationPeriodValidation());
        validator.property("publicationPeriod.end").add(new PublicationPeriodValidation());
        validator.chained(new DelegatingValidator(new DelegatingValidator.DelegateSource(){

            @Override
            public Validator getValidator() {
                return AdServiceImpl.this.adCustomFieldService.getValueValidator();
            }
        }));
        return validator;
    }

    private void setupGroupFilters(AbstractAdQuery query) {
        Collection<GroupFilter> groupFilters = query.getGroupFilters();
        if (CollectionUtils.isNotEmpty(groupFilters)) {
            groupFilters = this.fetchService.fetch(groupFilters, new Relationship[]{GroupFilter.Relationships.GROUPS});
            HashSet<MemberGroup> groups = new HashSet<MemberGroup>();
            HashSet<MemberGroup> xGroups = new HashSet<MemberGroup>();
            if (query.getGroups() != null) {
                groups.addAll(query.getGroups());
            }
            for (GroupFilter groupFilter : groupFilters) {
                xGroups.addAll(groupFilter.getGroups());
            }
            if (groups.isEmpty()) {
                groups = xGroups;
            } else {
                groups.retainAll(xGroups);
            }
            query.setGroupFilters(null);
            query.setGroups(groups);
        }
    }

    public class PublicationPeriodValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -6352683891570105522L;

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            Ad ad = (Ad)object;
            if (!ad.isPermanent()) {
                ValidationError required = RequiredValidation.instance().validate(object, name, value);
                if (required != null) {
                    return required;
                }
                if (name.toString().endsWith(".end") && ad.getPublicationPeriod() != null) {
                    Calendar beginDate = ad.getPublicationPeriod().getBegin();
                    Calendar endDate = (Calendar)value;
                    if (beginDate != null && endDate != null && !endDate.after(beginDate)) {
                        return new InvalidError();
                    }
                }
            }
            return null;
        }
    }

    public class MaxPublicationTimeValidation
    implements GeneralValidation {
        private static final long serialVersionUID = 1616929350799341483L;

        @Override
        public ValidationError validate(Object object) {
            TimePeriod maxAdPublicationTime;
            Calendar maxEnd;
            Ad ad = (Ad)object;
            Element element = AdServiceImpl.this.fetchService.fetch(ad.getOwner(), Element.Relationships.GROUP);
            if (element == null) {
                if (!LoggedUser.hasUser()) {
                    return null;
                }
                element = LoggedUser.element();
            }
            Group group = AdServiceImpl.this.fetchService.fetch(element.getGroup(), new Relationship[0]);
            Calendar begin = null;
            Calendar end = null;
            try {
                begin = ad.getPublicationPeriod().getBegin();
                end = ad.getPublicationPeriod().getEnd();
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (begin != null && end != null && !ad.isPermanent() && group instanceof MemberGroup && end.after(maxEnd = (maxAdPublicationTime = ((MemberGroup)group).getMemberSettings().getMaxAdPublicationTime()).add(begin))) {
                return new ValidationError("ad.error.maxPublicationTimeExceeded", new Object[0]);
            }
            return null;
        }
    }

    public class MaxAdDescriptionSizeValidation
    implements PropertyValidation {
        private static final long serialVersionUID = -5580051445666373995L;

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            Group group;
            Ad ad = (Ad)object;
            Element element = AdServiceImpl.this.fetchService.fetch(ad.getOwner(), Element.Relationships.GROUP);
            if (element == null) {
                if (!LoggedUser.hasUser()) {
                    return null;
                }
                element = LoggedUser.element();
            }
            if ((group = element.getGroup()) instanceof MemberGroup) {
                String description;
                MemberGroup memberGroup = AdServiceImpl.this.fetchService.fetch((MemberGroup)group, new Relationship[0]);
                int maxAdDescriptionSize = memberGroup.getMemberSettings().getMaxAdDescriptionSize();
                String string = description = value == null ? null : value.toString();
                if (ad.isHtml()) {
                    description = StringHelper.removeMarkupTagsAndUnescapeEntities(description);
                }
                return new LengthValidation(RangeConstraint.to(maxAdDescriptionSize)).validate(object, name, description);
            }
            return null;
        }
    }
}

