/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.ads;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.AbstractAdQuery;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterQuery;
import nl.strohalm.cyclos.entities.ads.AdCategoryWithCounterVO;
import nl.strohalm.cyclos.entities.ads.AdQuery;
import nl.strohalm.cyclos.entities.ads.FullTextAdQuery;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.ads.AdService;
import nl.strohalm.cyclos.services.ads.AdServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.ads.AdResultPage;
import nl.strohalm.cyclos.webservices.ads.FullTextAdSearchParameters;
import nl.strohalm.cyclos.webservices.model.AdVO;
import nl.strohalm.cyclos.webservices.model.MyAdVO;
import nl.strohalm.cyclos.webservices.utils.AdHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class AdServiceSecurity
extends BaseServiceSecurity
implements AdService {
    private AdServiceLocal adService;
    private AdHelper adHelper;
    private MemberServiceLocal memberServiceLocal;

    @Override
    public List<Ad> fullTextSearch(FullTextAdQuery query) throws DaoException {
        if (!this.applyQueryRestrictions(query = (FullTextAdQuery)query.clone())) {
            return Collections.emptyList();
        }
        return this.adService.fullTextSearch(query);
    }

    @Override
    public AdResultPage getAdResultPage(FullTextAdSearchParameters params, String memberPrincipal) {
        FullTextAdQuery query = this.adHelper.toFullTextQuery(params);
        if (query.getOwner() == null && StringUtils.isNotEmpty((String)memberPrincipal)) {
            query.setOwner(this.memberServiceLocal.loadByIdOrPrincipal(null, null, memberPrincipal));
        }
        if (!this.applyQueryRestrictions(query)) {
            throw new PermissionDeniedException();
        }
        return this.adService.getAdResultPage(params, memberPrincipal);
    }

    @Override
    public <VO extends AdVO> VO getAdVO(Class<VO> voType, Ad ad, boolean useAdFields, boolean useMemberFields, boolean onlyForAdSearchMemberFields) {
        this.checkView(ad);
        return this.adService.getAdVO(voType, ad, useAdFields, useMemberFields, onlyForAdSearchMemberFields);
    }

    @Override
    public List<AdCategoryWithCounterVO> getCategoriesWithCounters(AdCategoryWithCounterQuery query) {
        Collection<MemberGroup> visibleGroups = this.adService.visibleGroupsForAds();
        if (CollectionUtils.isEmpty(visibleGroups)) {
            return Collections.emptyList();
        }
        query.setGroupIds(EntityHelper.toIds(visibleGroups));
        return this.adService.getCategoriesWithCounters(query);
    }

    @Override
    public MyAdVO getMyVO(Ad ad) {
        if (ad == null) {
            return null;
        }
        this.checkView(ad);
        return this.adService.getMyVO(ad);
    }

    @Override
    public Map<Ad.Status, Integer> getNumberOfAds(Calendar date, Member member) {
        this.checkCanViewAdsOf(member);
        return this.adService.getNumberOfAds(null, member);
    }

    @Override
    public boolean isEditable(Ad ad) {
        return this.adService.isEditable(ad);
    }

    @Override
    public Ad load(Long id, Relationship ... fetch) {
        Ad ad = this.adService.load(id, fetch);
        this.checkView(ad);
        return ad;
    }

    @Override
    public void remove(Long id) {
        Ad ad = this.adService.load(id, new Relationship[0]);
        this.checkManagemenent(ad);
        this.adService.remove(id);
    }

    @Override
    public Ad save(Ad ad) {
        this.checkManagemenent(ad);
        return this.adService.save(ad);
    }

    @Override
    public List<Ad> search(AdQuery query) {
        if (!this.applyQueryRestrictions(query = (AdQuery)query.clone())) {
            return Collections.emptyList();
        }
        return this.adService.search(query);
    }

    public void setAdHelper(AdHelper adHelper) {
        this.adHelper = adHelper;
    }

    public void setAdServiceLocal(AdServiceLocal adService) {
        this.adService = adService;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberServiceLocal) {
        this.memberServiceLocal = memberServiceLocal;
    }

    @Override
    public void validate(Ad ad) throws ValidationException {
        this.adService.validate(ad);
    }

    private boolean applyQueryRestrictions(AbstractAdQuery query) {
        Collection<MemberGroup> visibleGroups = this.adService.visibleGroupsForAds();
        if (CollectionUtils.isEmpty(visibleGroups)) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(query.getGroupFilters())) {
            HashSet<MemberGroup> groups = new HashSet<MemberGroup>();
            Collection<GroupFilter> groupFilters = this.fetchService.fetch(query.getGroupFilters(), new Relationship[]{GroupFilter.Relationships.GROUPS});
            for (GroupFilter groupFilter : groupFilters) {
                groups.addAll(groupFilter.getGroups());
            }
            groups.retainAll(visibleGroups);
            query.setGroupFilters(null);
            if (CollectionUtils.isEmpty(query.getGroups())) {
                query.setGroups(groups);
            } else {
                query.getGroups().retainAll(groups);
            }
        }
        query.setGroups(PermissionHelper.checkSelection(visibleGroups, query.getGroups()));
        Member owner = this.fetchService.fetch(query.getOwner(), Element.Relationships.GROUP);
        if (owner != null && !visibleGroups.contains(owner.getGroup())) {
            return false;
        }
        if (owner != null && !this.permissionService.manages(owner)) {
            query.setStatus(Ad.Status.ACTIVE);
        }
        return true;
    }

    private void checkCanViewAdsOf(Member member) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        if (((Entity)LoggedUser.element()).equals(member)) {
            return;
        }
        if (!this.adService.visibleGroupsForAds().contains(member.getGroup())) {
            throw new PermissionDeniedException();
        }
    }

    private void checkManagemenent(Ad ad) {
        if (!this.adService.isEditable(ad)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(Ad ad) {
        this.checkCanViewAdsOf(ad.getOwner());
        if (!this.permissionService.manages(ad.getOwner()) && !ad.getStatus().isActive()) {
            throw new PermissionDeniedException();
        }
    }
}

