/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.alerts;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.dao.alerts.AlertDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.alerts.AlertType;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionEndListener;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class AlertServiceImpl
implements AlertServiceLocal {
    private FetchServiceLocal fetchService;
    private SettingsServiceLocal settingsService;
    private AlertDAO alertDao;
    private AdminNotificationHandler adminNotificationHandler;
    private TransactionHelper transactionHelper;

    @Override
    public void create(Member member, MemberAlert.Alerts alertType, Object ... arguments) {
        MemberAlert alert = new MemberAlert();
        this.populate(alert, alertType.getValue(), arguments);
        alert.setMember(member);
        this.save(alert, alertType);
    }

    @Override
    public void create(SystemAlert.Alerts alertType, Object ... arguments) {
        SystemAlert alert = new SystemAlert();
        this.populate(alert, alertType.getValue(), arguments);
        this.save(alert, alertType);
    }

    @Override
    public int getAlertCount(Alert.Type type) {
        if (Alert.Type.MEMBER.equals((Object)type)) {
            if (LoggedUser.hasUser()) {
                AdminGroup adminGroup = (AdminGroup)LoggedUser.group();
                adminGroup = this.fetchService.fetch(adminGroup, AdminGroup.Relationships.MANAGES_GROUPS);
                AlertQuery alertQuery = new AlertQuery();
                alertQuery.setType(type);
                alertQuery.setGroups(adminGroup.getManagesGroups());
                alertQuery.setPageForCount();
                return PageHelper.getTotalCount(this.alertDao.search(alertQuery));
            }
            return this.alertDao.getCount(type);
        }
        return this.alertDao.getCount(type);
    }

    @Override
    public Alert load(Long id, Relationship ... fetch) {
        return (Alert)this.alertDao.load(id, fetch);
    }

    @Override
    public int removeAlerts(Long ... ids) {
        return this.alertDao.delete(ids);
    }

    public List<Alert> search(AlertQuery queryParameters) {
        return this.alertDao.search(queryParameters);
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setAlertDao(AlertDAO alertDao) {
        this.alertDao = alertDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    private Alert doSave(Alert alert) {
        Alert saved = this.alertDao.insert(alert);
        this.adminNotificationHandler.notifyAlert(alert);
        return saved;
    }

    private void populate(Alert alert, String key, Object ... arguments) {
        String[] args = null;
        if (arguments != null) {
            args = new String[arguments.length];
            LocalSettings localSettings = this.settingsService.getLocalSettings();
            for (int i = 0; i < args.length; ++i) {
                Calendar trunc;
                Calendar cal;
                Object argument = arguments[i];
                String arg = argument == null ? "" : (argument instanceof BigDecimal ? localSettings.getNumberConverter().toString((BigDecimal)argument) : (argument instanceof Calendar ? ((cal = (Calendar)argument).equals(trunc = DateHelper.truncate(cal)) ? localSettings.getDateConverter().toString(cal) : localSettings.getDateTimeConverter().toString(cal)) : StringUtils.trimToEmpty((String)argument.toString())));
                args[i] = arg;
            }
        }
        alert.setDate(Calendar.getInstance());
        alert.setDescription(key, args);
    }

    private void save(final Alert alert, AlertType type) {
        if (alert.getDate() == null) {
            alert.setDate(Calendar.getInstance());
        }
        if (SystemAlert.Alerts.APPLICATION_SHUTDOWN.equals(type)) {
            this.doSave(alert);
        } else {
            CurrentTransactionData.addTransactionCommitListener(new TransactionEndListener(){

                @Override
                protected void onTransactionEnd(boolean commit) {
                    AlertServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            AlertServiceImpl.this.doSave(alert);
                        }
                    });
                }
            });
        }
    }
}

