/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.alerts;

import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.AlertQuery;
import nl.strohalm.cyclos.entities.alerts.MemberAlert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.alerts.AlertService;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public class AlertServiceSecurity
extends BaseServiceSecurity
implements AlertService {
    private AlertServiceLocal alertService;

    @Override
    public int removeAlerts(Long ... ids) {
        boolean system = false;
        boolean member = false;
        for (Long id : ids) {
            Alert alert = this.alertService.load(id, new Relationship[0]);
            if (alert instanceof MemberAlert) {
                this.permissionService.checkManages(((MemberAlert)alert).getMember());
                member = true;
            }
            if (!(alert instanceof SystemAlert)) continue;
            system = true;
        }
        if (member) {
            this.permissionService.permission().admin(AdminSystemPermission.ALERTS_MANAGE_MEMBER_ALERTS).check();
        }
        if (system) {
            this.permissionService.permission().admin(AdminSystemPermission.ALERTS_MANAGE_SYSTEM_ALERTS).check();
        }
        return this.alertService.removeAlerts(ids);
    }

    @Override
    public List<? extends Alert> search(AlertQuery queryParameters) {
        if (queryParameters.getType() == Alert.Type.MEMBER) {
            this.permissionService.permission().admin(AdminSystemPermission.ALERTS_VIEW_MEMBER_ALERTS).check();
        } else if (queryParameters.getType() == Alert.Type.SYSTEM) {
            this.permissionService.permission().admin(AdminSystemPermission.ALERTS_VIEW_SYSTEM_ALERTS).check();
        } else {
            throw new PermissionDeniedException();
        }
        if (queryParameters.getMember() != null) {
            this.permissionService.checkManages(queryParameters.getMember());
        }
        queryParameters.setGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), queryParameters.getGroups()));
        return this.alertService.search(queryParameters);
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }
}

