/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.alerts;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import nl.strohalm.cyclos.dao.alerts.ErrorLogEntryDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.access.User;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntry;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntryQuery;
import nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal;
import nl.strohalm.cyclos.utils.FormatObject;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.conversion.CoercionHelper;
import nl.strohalm.cyclos.utils.notifications.AdminNotificationHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;

public class ErrorLogServiceImpl
implements ErrorLogServiceLocal {
    private ErrorLogEntryDAO errorLogEntryDao;
    private AdminNotificationHandler adminNotificationHandler;
    private TransactionHelper transactionHelper;

    @Override
    public int getCount() {
        ErrorLogEntryQuery query = new ErrorLogEntryQuery();
        query.setShowRemoved(false);
        query.setPageForCount();
        return PageHelper.getTotalCount(this.errorLogEntryDao.search(query));
    }

    @Override
    public Future<ErrorLogEntry> insert(final Throwable t, final String path, final Map<String, ?> parameters) {
        if (t == null) {
            throw new ValidationException("exception", new RequiredError(new Object[0]));
        }
        if (StringUtils.isEmpty((String)path)) {
            throw new ValidationException("path", new RequiredError(new Object[0]));
        }
        return this.transactionHelper.runAsync(new TransactionCallback<ErrorLogEntry>(){

            public ErrorLogEntry doInTransaction(TransactionStatus status) {
                return ErrorLogServiceImpl.this.doInsert(t, path, parameters);
            }
        });
    }

    @Override
    public ErrorLogEntry load(Long id, Relationship ... fetch) {
        return (ErrorLogEntry)this.errorLogEntryDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.errorLogEntryDao.delete(ids);
    }

    @Override
    public List<ErrorLogEntry> search(ErrorLogEntryQuery query) {
        return this.errorLogEntryDao.search(query);
    }

    public void setAdminNotificationHandler(AdminNotificationHandler adminNotificationHandler) {
        this.adminNotificationHandler = adminNotificationHandler;
    }

    public void setErrorLogEntryDao(ErrorLogEntryDAO errorLogEntryDao) {
        this.errorLogEntryDao = errorLogEntryDao;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    private ErrorLogEntry doInsert(Throwable t, String path, Map<String, ?> parameters) {
        ErrorLogEntry entry = new ErrorLogEntry();
        entry.setDate(Calendar.getInstance());
        entry.setPath(path);
        if (LoggedUser.hasUser()) {
            entry.setLoggedUser((User)LoggedUser.user());
        }
        StringWriter stackTrace = new StringWriter();
        t.printStackTrace(new PrintWriter(stackTrace));
        entry.setStackTrace(stackTrace.toString());
        if (MapUtils.isEmpty(parameters)) {
            entry.setParameters(new HashMap<String, String>());
        } else {
            HashMap<String, String> params = new HashMap<String, String>();
            for (Map.Entry<String, ?> e : parameters.entrySet()) {
                String name = e.getKey();
                if (StringUtils.isEmpty((String)name)) continue;
                String value = CoercionHelper.coerce(String.class, e.getValue());
                params.put(name, FormatObject.maskIfNeeded(name, value));
            }
            entry.setParameters(params);
        }
        entry = this.errorLogEntryDao.insert(entry);
        this.adminNotificationHandler.notifyApplicationErrors(entry);
        return entry;
    }
}

