/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.alerts;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntry;
import nl.strohalm.cyclos.entities.alerts.ErrorLogEntryQuery;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.alerts.ErrorLogService;
import nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal;

public class ErrorLogServiceSecurity
extends BaseServiceSecurity
implements ErrorLogService {
    private ErrorLogServiceLocal errorLogService;

    @Override
    public Future<ErrorLogEntry> insert(Throwable t, String path, Map<String, ?> parameters) {
        return this.errorLogService.insert(t, path, parameters);
    }

    @Override
    public ErrorLogEntry load(Long id, Relationship ... fetch) {
        this.permissionService.permission().admin(AdminSystemPermission.ERROR_LOG_VIEW).check();
        return this.errorLogService.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        this.permissionService.permission().admin(AdminSystemPermission.ERROR_LOG_MANAGE).check();
        return this.errorLogService.remove(ids);
    }

    @Override
    public List<ErrorLogEntry> search(ErrorLogEntryQuery query) {
        if (!this.permissionService.permission().admin(AdminSystemPermission.ERROR_LOG_VIEW).hasPermission()) {
            return Collections.emptyList();
        }
        return this.errorLogService.search(query);
    }

    public void setErrorLogServiceLocal(ErrorLogServiceLocal errorLogService) {
        this.errorLogService = errorLogService;
    }
}

