/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import nl.strohalm.cyclos.dao.ApplicationDAO;
import nl.strohalm.cyclos.dao.IndexOperationDAO;
import nl.strohalm.cyclos.entities.Application;
import nl.strohalm.cyclos.entities.IndexOperation;
import nl.strohalm.cyclos.entities.IndexStatus;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.entities.access.SessionQuery;
import nl.strohalm.cyclos.entities.accounts.LockedAccountsOnPayments;
import nl.strohalm.cyclos.entities.accounts.SystemAccountOwner;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.InvoiceQuery;
import nl.strohalm.cyclos.entities.alerts.Alert;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.messages.MessageBox;
import nl.strohalm.cyclos.entities.members.messages.MessageQuery;
import nl.strohalm.cyclos.initializations.LocalInitialization;
import nl.strohalm.cyclos.scheduling.PollingTasksHandler;
import nl.strohalm.cyclos.scheduling.SchedulingHandler;
import nl.strohalm.cyclos.scheduling.polling.PollingTask;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.access.AccessServiceLocal;
import nl.strohalm.cyclos.services.accounts.rates.RateServiceLocal;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.alerts.ErrorLogServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationStatusVO;
import nl.strohalm.cyclos.services.elements.MessageServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.utils.MessageResolver;
import nl.strohalm.cyclos.utils.MessageResourcesLoadedListener;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.instance.InstanceHandler;
import nl.strohalm.cyclos.utils.lucene.IndexHandler;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.tasks.TaskRunner;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class ApplicationServiceImpl
implements ApplicationServiceLocal,
ApplicationContextAware,
InitializingBean,
MessageResourcesLoadedListener {
    private static final Log LOG = LogFactory.getLog(ApplicationServiceImpl.class);
    private static final String APPLICATION_CACHE_KEY = "application";
    private static final String MINOR_VERSION_TAG = "_minor_";
    private static final String minorVersion = ApplicationServiceImpl.extract("$Name: not supported by cvs2svn $");
    private MessageResolver messageResolver;
    private boolean initialized;
    private boolean initializing;
    private boolean runScheduling;
    private ApplicationContext applicationContext;
    private AccessServiceLocal accessService;
    private AlertServiceLocal alertService;
    private MessageServiceLocal messageService;
    private InvoiceServiceLocal invoiceService;
    private ErrorLogServiceLocal errorLogService;
    private RateServiceLocal rateService;
    private ApplicationDAO applicationDao;
    private IndexOperationDAO indexOperationDao;
    private SchedulingHandler schedulingHandler;
    private PollingTasksHandler pollingTasksHandler;
    private InstanceHandler instanceHandler;
    private IndexHandler indexHandler;
    private CacheManager cacheManager;
    private TaskRunner taskRunner;
    private long startupTime;
    private Properties cyclosProperties;
    private TransactionHelper transactionHelper;
    private LockedAccountsOnPayments lockedAccountsOnPayments;
    private final HashMap<SystemAlert.Alerts, String> deferredEvents = new HashMap();
    private PermissionServiceLocal permissionService;

    private static String extract(String cvsTagName) {
        if (cvsTagName == null) {
            return "";
        }
        String result = cvsTagName;
        result = result.replaceAll("\\$Name:", "");
        result = result.replaceAll("\\$", "");
        if (StringUtils.isBlank((String)(result = result.replaceAll(" ", ""))) || !result.contains(MINOR_VERSION_TAG)) {
            return "";
        }
        String[] tmp = StringUtils.splitByWholeSeparator((String)result, (String)MINOR_VERSION_TAG);
        return tmp[tmp.length - 1];
    }

    public void afterPropertiesSet() throws Exception {
        try {
            this.lockedAccountsOnPayments = LockedAccountsOnPayments.valueOf(this.cyclosProperties.getProperty("cyclos.lockedAccountsOnPayments", LockedAccountsOnPayments.ORIGIN.name()).toUpperCase());
        }
        catch (Exception e) {
            StringBuilder message = new StringBuilder();
            message.append("Invalid value for cyclos.lockedAccountsOnPayments: ").append(this.cyclosProperties.getProperty("cyclos.lockedAccountsOnPayments")).append(". Valid values are ");
            boolean first = true;
            for (LockedAccountsOnPayments item : LockedAccountsOnPayments.values()) {
                if (first) {
                    first = false;
                } else {
                    message.append(", ");
                }
                message.append(item.name().toLowerCase());
            }
            throw new IllegalArgumentException(message.toString());
        }
    }

    @Override
    public void awakePollingTask(Class<? extends PollingTask> type) {
        PollingTask pollingTask;
        if (this.pollingTasksHandler != null && (pollingTask = this.pollingTasksHandler.get(type)) != null) {
            pollingTask.awake();
        }
    }

    @Override
    public void awakePollingTaskOnTransactionCommit(final Class<? extends PollingTask> type) {
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                ApplicationServiceImpl.this.awakePollingTask(type);
            }
        });
    }

    @Override
    public Calendar getAccountStatusEnabledSince() {
        return this.getApplication().getAccountStatusEnabledSince();
    }

    @Override
    public ApplicationStatusVO getApplicationStatus() {
        ApplicationStatusVO vo = new ApplicationStatusVO();
        long diff = System.currentTimeMillis() - this.startupTime;
        int days = (int)(diff / 86400000L);
        int hours = (int)(diff % 86400000L / 3600000L);
        vo.setUptimeDays(days);
        vo.setUptimeHours(hours);
        SessionQuery sessions = new SessionQuery();
        sessions.setGroups(this.permissionService.getAllVisibleGroups());
        sessions.setPageForCount();
        sessions.setNatures(Collections.singleton(Group.Nature.ADMIN));
        vo.setConnectedAdmins(PageHelper.getTotalCount(this.accessService.searchSessions(sessions)));
        sessions.setNatures(Collections.singleton(Group.Nature.MEMBER));
        vo.setConnectedMembers(PageHelper.getTotalCount(this.accessService.searchSessions(sessions)));
        sessions.setNatures(Collections.singleton(Group.Nature.BROKER));
        vo.setConnectedBrokers(PageHelper.getTotalCount(this.accessService.searchSessions(sessions)));
        sessions.setNatures(Collections.singleton(Group.Nature.OPERATOR));
        vo.setConnectedOperators(PageHelper.getTotalCount(this.accessService.searchSessions(sessions)));
        vo.setCyclosVersion(this.getCyclosVersion());
        vo.setMemberAlerts(this.alertService.getAlertCount(Alert.Type.MEMBER));
        vo.setSystemAlerts(this.alertService.getAlertCount(Alert.Type.SYSTEM));
        vo.setErrors(this.errorLogService.getCount());
        vo.setUnreadMessages(this.countUnreadMessages());
        vo.setOpenInvoices(this.countOpenInvoices());
        return vo;
    }

    @Override
    public String getCyclosVersion() {
        String suffix = "";
        if (StringUtils.isNotBlank((String)minorVersion)) {
            suffix = " (" + minorVersion + ")";
        }
        return this.getApplication().getVersion() + suffix;
    }

    @Override
    public Map<Class<? extends Indexable>, IndexStatus> getFullTextIndexesStatus() {
        LinkedHashMap<Class<? extends Indexable>, IndexStatus> stats = new LinkedHashMap<Class<? extends Indexable>, IndexStatus>();
        for (IndexOperation.EntityType type : IndexOperation.EntityType.values()) {
            Class<? extends Indexable> entityClass = type.getEntityClass();
            stats.put(entityClass, this.indexHandler.getIndexStatus(entityClass));
        }
        return stats;
    }

    @Override
    public LockedAccountsOnPayments getLockedAccountsOnPayments() {
        return this.lockedAccountsOnPayments;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    @Override
    public Application.PasswordHash getPasswordHash() {
        return this.getApplication().getPasswordHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize() {
        if (this.initialized || this.initializing) {
            return;
        }
        this.initializing = true;
        try {
            this.startupTime = System.currentTimeMillis();
            this.setHeadlessMode();
            boolean bl = this.runScheduling = Boolean.valueOf(this.cyclosProperties.getProperty("cyclos.disableScheduling", "false")) == false;
            if (this.runScheduling) {
                Set<String> beanNames = this.applicationContext.getBeansOfType(InitializingService.class).keySet();
                this.taskRunner.runInitializations(beanNames);
                this.schedulingHandler.start();
                this.pollingTasksHandler.start();
            }
            Collection<LocalInitialization> initializations = this.applicationContext.getBeansOfType(LocalInitialization.class).values();
            this.runAll(initializations);
            if (this.runScheduling) {
                this.transactionHelper.runAsync(new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        ApplicationServiceImpl.this.deferEvent(SystemAlert.Alerts.APPLICATION_RESTARTED, ApplicationServiceImpl.this.instanceHandler.getId());
                    }
                });
            }
            this.initialized = true;
            this.messageResolver.addMessageResourcesLoadedListener(this);
        }
        finally {
            this.initializing = false;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized && !this.initializing;
    }

    @Override
    public boolean isOnline() {
        Application app = this.getApplication();
        return app != null && app.isOnline();
    }

    @Override
    public boolean isRunScheduling() {
        return this.runScheduling;
    }

    @Override
    public void onApplicationResourcesLoaded() {
        for (SystemAlert.Alerts key : this.deferredEvents.keySet()) {
            String val = this.deferredEvents.get(key);
            this.alertService.create(key, val);
        }
    }

    @Override
    public void purgeIndexOperations(Calendar time) {
        Calendar limit = (Calendar)time.clone();
        limit.add(11, -24);
        this.indexOperationDao.deleteBefore(limit);
    }

    @Override
    public void rebuildIndexes(Class<? extends Indexable> entityType) {
        for (Class<? extends Indexable> entityClass : this.resolveIndexedClasses(entityType)) {
            this.indexHandler.rebuild(entityClass);
        }
    }

    public void setAccessServiceLocal(AccessServiceLocal accessService) {
        this.accessService = accessService;
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setApplicationDao(ApplicationDAO applicationDao) {
        this.applicationDao = applicationDao;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setCyclosProperties(Properties cyclosProperties) {
        this.cyclosProperties = cyclosProperties;
    }

    public void setErrorLogServiceLocal(ErrorLogServiceLocal errorLogService) {
        this.errorLogService = errorLogService;
    }

    public void setIndexHandler(IndexHandler indexHandler) {
        this.indexHandler = indexHandler;
    }

    public void setIndexOperationDao(IndexOperationDAO indexOperationDao) {
        this.indexOperationDao = indexOperationDao;
    }

    public void setInstanceHandler(InstanceHandler instanceHandler) {
        this.instanceHandler = instanceHandler;
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    public void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    public void setMessageServiceLocal(MessageServiceLocal messageService) {
        this.messageService = messageService;
    }

    @Override
    public void setOnline(boolean online) {
        boolean changed;
        Application application = this.getApplication();
        boolean bl = changed = application.isOnline() != online;
        if (changed) {
            if (online && this.rateService.checkPendingRateInitializations(null) != null) {
                throw new ValidationException("rates.error.notOnlineWhileRateInitsPending", new Object[0]);
            }
            application.setOnline(online);
            this.applicationDao.update(application);
            this.getCache().remove((Serializable)((Object)APPLICATION_CACHE_KEY));
            if (!online) {
                this.accessService.disconnectAllButLogged();
            }
        }
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setPollingTasksHandler(PollingTasksHandler pollingTasksHandler) {
        this.pollingTasksHandler = pollingTasksHandler;
    }

    public void setRateServiceLocal(RateServiceLocal rateService) {
        this.rateService = rateService;
    }

    public void setSchedulingHandler(SchedulingHandler schedulingHandler) {
        this.schedulingHandler = schedulingHandler;
    }

    public void setTaskRunner(TaskRunner taskRunner) {
        this.taskRunner = taskRunner;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    @Override
    public void shutdown() {
        this.initialized = false;
        this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ApplicationServiceImpl.this.alertService.create(SystemAlert.Alerts.APPLICATION_SHUTDOWN, ApplicationServiceImpl.this.instanceHandler.getId());
            }
        });
        this.applicationDao.shutdownDBIfNeeded();
    }

    private int countOpenInvoices() {
        InvoiceQuery query = new InvoiceQuery();
        query.setOwner(SystemAccountOwner.instance());
        query.setDirection(InvoiceQuery.Direction.INCOMING);
        query.setStatus(Invoice.Status.OPEN);
        query.setPageForCount();
        return PageHelper.getTotalCount(this.invoiceService.search(query));
    }

    private int countUnreadMessages() {
        MessageQuery query = new MessageQuery();
        query.setGetter((Element)LoggedUser.element());
        query.setMessageBox(MessageBox.INBOX);
        query.setRead(false);
        query.setPageForCount();
        return PageHelper.getTotalCount(this.messageService.search(query));
    }

    private void deferEvent(SystemAlert.Alerts applicationRestarted, String id) {
        this.deferredEvents.put(applicationRestarted, id);
    }

    private Application getApplication() {
        return (Application)this.getCache().get((Serializable)((Object)APPLICATION_CACHE_KEY), new CacheCallback(){

            @Override
            public Object retrieve() {
                return ApplicationServiceImpl.this.applicationDao.read();
            }
        });
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.Application");
    }

    private Collection<Class<? extends Indexable>> resolveIndexedClasses(Class<? extends Indexable> entityType) {
        if (entityType == null) {
            ArrayList<Class<? extends Indexable>> entityClasses = new ArrayList<Class<? extends Indexable>>();
            for (IndexOperation.EntityType type : IndexOperation.EntityType.values()) {
                entityClasses.add(type.getEntityClass());
            }
            return entityClasses;
        }
        return Collections.singleton(entityType);
    }

    private void runAll(Collection<LocalInitialization> initializations) {
        for (final LocalInitialization initialization : initializations) {
            LOG.debug((Object)String.format("Running initialization (%s)...", initialization.getName()));
            this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    initialization.initialize();
                }
            });
        }
    }

    private void setHeadlessMode() {
        System.setProperty("java.awt.headless", "true");
    }
}

