/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.application;

import java.util.Map;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.IndexStatus;
import nl.strohalm.cyclos.entities.Indexable;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.application.ApplicationService;
import nl.strohalm.cyclos.services.application.ApplicationServiceLocal;
import nl.strohalm.cyclos.services.application.ApplicationStatusVO;

public class ApplicationServiceSecurity
extends BaseServiceSecurity
implements ApplicationService {
    private ApplicationServiceLocal applicationService;

    @Override
    public ApplicationStatusVO getApplicationStatus() {
        if (this.permissionService.hasPermission(AdminSystemPermission.STATUS_VIEW)) {
            return this.applicationService.getApplicationStatus();
        }
        return null;
    }

    @Override
    public String getCyclosVersion() {
        return this.applicationService.getCyclosVersion();
    }

    @Override
    public Map<Class<? extends Indexable>, IndexStatus> getFullTextIndexesStatus() {
        this.checkManageIndexes();
        return this.applicationService.getFullTextIndexesStatus();
    }

    @Override
    public void initialize() {
        this.checkIsSystem();
        this.applicationService.initialize();
    }

    @Override
    public boolean isOnline() {
        return this.applicationService.isOnline();
    }

    @Override
    public void rebuildIndexes(Class<? extends Indexable> entityType) {
        this.checkManageIndexes();
        this.applicationService.rebuildIndexes(entityType);
    }

    public void setApplicationServiceLocal(ApplicationServiceLocal applicationService) {
        this.applicationService = applicationService;
    }

    @Override
    public void setOnline(boolean online) {
        this.checkOnlineState();
        this.applicationService.setOnline(online);
    }

    @Override
    public void shutdown() {
        this.checkIsSystem();
        this.applicationService.shutdown();
    }

    private void checkManageIndexes() {
        this.permissionService.permission().admin(AdminSystemPermission.TASKS_MANAGE_INDEXES).check();
    }

    private void checkOnlineState() {
        this.permissionService.permission().admin(AdminSystemPermission.TASKS_ONLINE_STATE).check();
    }
}

