/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.customization.fields.AdCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.AdCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class AdCustomFieldServiceSecurity
extends BaseServiceSecurity
implements AdCustomFieldService {
    private AdCustomFieldServiceLocal adCustomFieldService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        FieldVO fieldVO = this.adCustomFieldService.getFieldVO(customFieldId);
        this.checkView();
        return fieldVO;
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        this.checkView();
        List<FieldVO> fieldVOs = this.adCustomFieldService.getFieldVOs(customFieldIds);
        return fieldVOs;
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView();
        return this.adCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<AdCustomField> list() {
        this.checkView();
        return this.adCustomFieldService.list();
    }

    @Override
    public List<AdCustomField> listPossibleParentFields(AdCustomField field) {
        this.checkView();
        return this.adCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<AdCustomField> load(Collection<Long> ids) {
        this.checkView();
        return this.adCustomFieldService.load(ids);
    }

    @Override
    public AdCustomField load(Long id) {
        this.checkView();
        return (AdCustomField)this.adCustomFieldService.load(id);
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        this.checkView();
        return this.adCustomFieldService.loadPossibleValue(id);
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        this.checkView();
        return this.adCustomFieldService.loadPossibleValues(ids);
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.adCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.adCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.adCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public AdCustomField save(AdCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.adCustomFieldService.save(field);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.adCustomFieldService.save(possibleValue);
    }

    public void setAdCustomFieldServiceLocal(AdCustomFieldServiceLocal adCustomFieldService) {
        this.adCustomFieldService = adCustomFieldService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.adCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(AdCustomField field) throws ValidationException {
        this.adCustomFieldService.validate(field);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.adCustomFieldService.validate(possibleValue);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_MANAGE).check();
    }

    private void checkView() {
        this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_VIEW, AdminMemberPermission.ADS_VIEW).member(MemberPermission.ADS_VIEW).operator(MemberPermission.ADS_VIEW).check();
    }
}

