/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.customization.fields.AdminCustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldService;
import nl.strohalm.cyclos.services.customization.AdminCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class AdminCustomFieldServiceSecurity
extends BaseServiceSecurity
implements AdminCustomFieldService {
    private AdminCustomFieldServiceLocal adminCustomFieldService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView();
        return this.adminCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        this.checkView();
        return this.adminCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView();
        return this.adminCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<AdminCustomField> list() {
        this.checkView();
        return this.adminCustomFieldService.list();
    }

    @Override
    public List<AdminCustomField> listPossibleParentFields(AdminCustomField field) {
        this.checkView();
        return this.adminCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<AdminCustomField> load(Collection<Long> ids) {
        this.checkView();
        return this.adminCustomFieldService.load(ids);
    }

    @Override
    public AdminCustomField load(Long id) {
        this.checkView();
        return (AdminCustomField)this.adminCustomFieldService.load(id);
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        this.checkView();
        return this.adminCustomFieldService.loadPossibleValue(id);
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        this.checkView();
        return this.adminCustomFieldService.loadPossibleValues(ids);
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.adminCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.adminCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.adminCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public AdminCustomField save(AdminCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.adminCustomFieldService.save(field);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.adminCustomFieldService.save(possibleValue);
    }

    public void setAdminCustomFieldServiceLocal(AdminCustomFieldServiceLocal adminCustomFieldService) {
        this.adminCustomFieldService = adminCustomFieldService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.adminCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(AdminCustomField field) throws ValidationException {
        this.adminCustomFieldService.validate(field);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.adminCustomFieldService.validate(possibleValue);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_MANAGE).check();
    }

    private void checkView() {
        this.permissionService.permission().admin(new AdminPermission[0]).check();
    }
}

