/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import nl.strohalm.cyclos.dao.customizations.CustomFieldDAO;
import nl.strohalm.cyclos.dao.customizations.CustomFieldPossibleValueDAO;
import nl.strohalm.cyclos.dao.customizations.CustomFieldValueDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.transactions.Transfer;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.Validation;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.services.ServiceClient;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CustomFieldHelper;
import nl.strohalm.cyclos.utils.CustomFieldsContainer;
import nl.strohalm.cyclos.utils.CustomObjectHandler;
import nl.strohalm.cyclos.utils.ElementVO;
import nl.strohalm.cyclos.utils.Pair;
import nl.strohalm.cyclos.utils.PropertyHelper;
import nl.strohalm.cyclos.utils.RangeConstraint;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.StringHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.conversion.CalendarConverter;
import nl.strohalm.cyclos.utils.conversion.ConversionException;
import nl.strohalm.cyclos.utils.conversion.IdConverter;
import nl.strohalm.cyclos.utils.conversion.NumberConverter;
import nl.strohalm.cyclos.utils.lock.UniqueObjectHandler;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.LengthValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.UniqueError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import nl.strohalm.cyclos.webservices.utils.FieldHelper;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.support.PropertyComparator;

public abstract class BaseCustomFieldServiceImpl<CF extends CustomField>
implements BaseCustomFieldServiceLocal<CF> {
    private Validator possibleValueNavigator;
    protected static final String ALL_KEY = "_ALL_";
    protected static final List<String> EXCLUDED_PROPERTIES_FOR_DEPENDENT_FIELDS;
    protected final Class<CF> customFieldType;
    protected FetchServiceLocal fetchService;
    protected PermissionServiceLocal permissionService;
    protected ElementServiceLocal elementService;
    protected SettingsServiceLocal settingsService;
    protected CustomFieldDAO customFieldDao;
    protected CustomFieldValueDAO customFieldValueDao;
    protected CustomFieldPossibleValueDAO customFieldPossibleValueDao;
    private CacheManager cacheManager;
    protected final Relationship[] fetch;
    private Validator validator;
    protected CustomObjectHandler customObjectHandler;
    protected FieldHelper fieldHelper;
    protected CustomFieldHelper customFieldHelper;
    private UniqueObjectHandler uniqueObjectHandler;

    protected BaseCustomFieldServiceImpl(Class<CF> customFieldType) {
        this.customFieldType = customFieldType;
        ArrayList<Relationship> fetch = new ArrayList<Relationship>();
        fetch.addAll(Arrays.asList(CustomField.Relationships.POSSIBLE_VALUES, CustomField.Relationships.CHILDREN, RelationshipHelper.nested(CustomField.Relationships.PARENT, CustomField.Relationships.POSSIBLE_VALUES)));
        fetch.addAll(this.resolveAdditionalFetch());
        this.fetch = fetch.toArray(new Relationship[fetch.size()]);
    }

    @Override
    public void clearCache() {
        this.getCache().clear();
    }

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        CF cf = this.load(customFieldId);
        return this.fieldHelper.toVO((CustomField)cf);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        ArrayList<CF> customFields = new ArrayList<CF>(customFieldIds.size());
        for (Long id : customFieldIds) {
            if (id == null) continue;
            CF cf = this.load(id);
            customFields.add(cf);
        }
        return this.fieldHelper.toFieldVOs(customFields);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        CF cf = this.load(customFieldId);
        if (((CustomField)cf).getType() != CustomField.Type.ENUMERATED) {
            return null;
        }
        FieldVO fieldVO = this.fieldHelper.toVO((CustomField)cf);
        List<PossibleValueVO> possibleValues = fieldVO.getPossibleValues();
        if (possibleValues != null) {
            if (possibleValueParentId != null) {
                for (PossibleValueVO pvo : possibleValues) {
                    if (pvo.getParentId().equals(possibleValueParentId)) continue;
                    possibleValues.remove(pvo);
                }
            }
            return possibleValues;
        }
        return Collections.emptyList();
    }

    @Override
    public List<CF> listPossibleParentFields(CF field) {
        if (field == null || ((Entity)field).isPersistent() && ((CustomField)field).getType() != CustomField.Type.ENUMERATED) {
            return new ArrayList();
        }
        ArrayList<CF> fields = new ArrayList<CF>(this.list(field));
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            CustomField current = (CustomField)iterator.next();
            if (!((Entity)field).equals(current) && current.getType() == CustomField.Type.ENUMERATED && current.getControl() == CustomField.Control.SELECT && current.getParent() == null) continue;
            iterator.remove();
        }
        return fields;
    }

    @Override
    public List<CF> load(Collection<Long> ids) {
        ArrayList<CF> result = new ArrayList<CF>(ids.size());
        for (Long id : ids) {
            result.add(this.load(id));
        }
        return result;
    }

    @Override
    public CF load(final Long id) {
        return (CF)((CustomField)this.getCache().get(id, new CacheCallback(){

            @Override
            public Object retrieve() {
                return BaseCustomFieldServiceImpl.this.loadChecked(id);
            }
        }));
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(final Long id) {
        return (CustomFieldPossibleValue)this.getCache().get((Serializable)((Object)("_POSSIBLE_VALUE_" + id)), new CacheCallback(){

            @Override
            public Object retrieve() {
                return BaseCustomFieldServiceImpl.this.loadCheckedPossibleValue(id);
            }
        });
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        ArrayList<CustomFieldPossibleValue> result = new ArrayList<CustomFieldPossibleValue>(ids.size());
        for (Long id : ids) {
            result.add(this.loadPossibleValue(id));
        }
        Collections.sort(result, new BeanComparator("value"));
        return result;
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            CustomField field = (CustomField)this.customFieldDao.load(id, new Relationship[0]);
            if (this.customFieldType.isInstance(field)) continue;
            throw new EntityNotFoundException();
        }
        this.getCache().clear();
        return this.customFieldDao.delete(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        for (Long id : ids) {
            this.loadCheckedPossibleValue(id);
        }
        this.getCache().clear();
        return this.customFieldPossibleValueDao.delete(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        oldValue = this.fetchService.fetch(oldValue, new Relationship[0]);
        newValue = this.fetchService.fetch(newValue, new Relationship[0]);
        if (!oldValue.getField().equals(newValue.getField())) {
            throw new ValidationException();
        }
        return this.customFieldValueDao.moveValues(oldValue, newValue);
    }

    @Override
    public CF save(CF field) {
        CustomField parent = null;
        if (((CustomField)field).getParent() != null) {
            parent = this.fetchService.fetch(((CustomField)field).getParent(), new Relationship[0]);
            this.copyParentProperties(parent, (CustomField)field);
        }
        this.validate(field);
        if (((Entity)field).isTransient()) {
            ((CustomField)field).setChildren(new ArrayList<CustomField>());
            if (parent == null) {
                int maxOrder = 0;
                for (CustomField cf : this.list(field)) {
                    if (cf.getOrder() <= maxOrder) continue;
                    maxOrder = cf.getOrder();
                }
                ((CustomField)field).setOrder(maxOrder + 1);
            } else {
                parent.getChildren().add((CustomField)field);
            }
            field = (CustomField)this.customFieldDao.insert(field);
            if (parent != null) {
                ArrayList<Long> order = new ArrayList<Long>();
                List<Object> allFields = this.list(field);
                for (int i = 0; i < allFields.size(); ++i) {
                    CustomField cf = (CustomField)allFields.get(i);
                    if (cf.getParent() != null) continue;
                    order.add(cf.getId());
                }
                this.setOrder(order);
            }
        } else {
            CustomField oldversion = (CustomField)this.customFieldDao.load(((Entity)field).getId(), new Relationship[0]);
            if (oldversion instanceof MemberCustomField) {
                MemberCustomField oldversionMemberField = (MemberCustomField)oldversion;
                MemberCustomField newversion = (MemberCustomField)field;
                if (oldversionMemberField.isMemberCanHide() && !newversion.isMemberCanHide()) {
                    this.customFieldValueDao.unHideValues(newversion);
                }
            }
            ((CustomField)field).setOrder(oldversion.getOrder());
            field = (CustomField)this.customFieldDao.update(field);
            if (((CustomField)field).getType() == CustomField.Type.ENUMERATED) {
                field = (CustomField)this.fetchService.reload(field, CustomField.Relationships.CHILDREN);
                for (CustomField child : ((CustomField)field).getChildren()) {
                    this.copyParentProperties((CustomField)field, child);
                }
            }
        }
        this.getCache().clear();
        return (CF)field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.validate(possibleValue);
        try {
            possibleValue = possibleValue.isTransient() ? this.customFieldPossibleValueDao.insert(possibleValue) : this.customFieldPossibleValueDao.update(possibleValue);
            this.customFieldPossibleValueDao.ensureDefault(possibleValue);
        }
        finally {
            this.getCache().clear();
        }
        return possibleValue;
    }

    public final void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public final void setCustomFieldDao(CustomFieldDAO customFieldDao) {
        this.customFieldDao = customFieldDao;
    }

    public void setCustomFieldHelper(CustomFieldHelper customFieldHelper) {
        this.customFieldHelper = customFieldHelper;
    }

    public final void setCustomFieldPossibleValueDao(CustomFieldPossibleValueDAO customFieldPossibleValueDao) {
        this.customFieldPossibleValueDao = customFieldPossibleValueDao;
    }

    public final void setCustomFieldValueDao(CustomFieldValueDAO customFieldValueDao) {
        this.customFieldValueDao = customFieldValueDao;
    }

    public final void setCustomObjectHandler(CustomObjectHandler customObjectHandler) {
        this.customObjectHandler = customObjectHandler;
    }

    public final void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public final void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public final void setFieldHelper(FieldHelper fieldHelper) {
        this.fieldHelper = fieldHelper;
    }

    @Override
    public void setOrder(List<Long> ids) {
        int order = 0;
        for (Long id : ids) {
            CF field = this.loadChecked(id);
            ((CustomField)field).setOrder(++order);
            ArrayList<CustomField> children = new ArrayList<CustomField>(((CustomField)field).getChildren());
            if (!CollectionUtils.isNotEmpty(children)) continue;
            Collections.sort(children, new PropertyComparator("name", true, true));
            for (CustomField child : children) {
                child.setOrder(++order);
            }
        }
        this.getCache().clear();
    }

    public final void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public final void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setUniqueObjectHandler(UniqueObjectHandler uniqueObjectHandler) {
        this.uniqueObjectHandler = uniqueObjectHandler;
    }

    @Override
    public void validate(CF field) {
        this.getValidator().validate(field);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.getPossibleValueValidator().validate(possibleValue);
    }

    protected void appendValidations(Validator validator) {
    }

    protected void doSaveValues(CustomFieldsContainer<?, ?> owner) {
        Collection<?> customValues = owner.getCustomValues();
        if (customValues == null || customValues.isEmpty()) {
            return;
        }
        for (CustomFieldValue value : customValues) {
            CustomField field = this.fetchService.fetch(value.getField(), new Relationship[0]);
            this.lockUniqueFieldValue(field, value);
            value.setField(field);
            CustomFieldPossibleValue possibleValue = null;
            Member memberValue = null;
            String stringValue = null;
            switch (field.getType()) {
                case ENUMERATED: {
                    Long possibleValueId = null;
                    possibleValueId = value.getPossibleValue() != null ? value.getPossibleValue().getId() : IdConverter.instance().valueOf(value.getValue());
                    boolean tryByValue = possibleValueId == null;
                    boolean invalidPossibleValue = false;
                    if (possibleValueId != null) {
                        try {
                            possibleValue = (CustomFieldPossibleValue)this.customFieldPossibleValueDao.load(possibleValueId, new Relationship[0]);
                            invalidPossibleValue = !possibleValue.isEnabled();
                        }
                        catch (EntityNotFoundException e) {
                            tryByValue = true;
                        }
                    }
                    if (tryByValue && StringUtils.isNotEmpty((String)value.getValue())) {
                        try {
                            possibleValue = this.customFieldPossibleValueDao.load(field.getId(), value.getValue());
                            invalidPossibleValue = !possibleValue.isEnabled();
                        }
                        catch (EntityNotFoundException e) {
                            invalidPossibleValue = true;
                        }
                    }
                    if (!invalidPossibleValue) break;
                    throw this.createValidationException(field);
                }
                case MEMBER: {
                    Long memberId = null;
                    memberId = value.getMemberValue() != null ? value.getMemberValue().getId() : IdConverter.instance().valueOf(value.getValue());
                    if (memberId == null) break;
                    boolean invalidMember = false;
                    try {
                        final Long mid = memberId;
                        memberValue = LoggedUser.runAsSystem(new Callable<Member>(){

                            @Override
                            public Member call() throws Exception {
                                Object element = BaseCustomFieldServiceImpl.this.elementService.load(mid, new Relationship[0]);
                                if (!(element instanceof Member)) {
                                    throw new EntityNotFoundException();
                                }
                                return (Member)element;
                            }
                        });
                    }
                    catch (EntityNotFoundException e) {
                        invalidMember = true;
                    }
                    if (!invalidMember) break;
                    throw this.createValidationException(field);
                }
                default: {
                    stringValue = field.getType() != CustomField.Type.STRING || field.getControl() != CustomField.Control.RICH_EDITOR ? StringHelper.removeMarkupTags(value.getValue()) : value.getValue();
                    stringValue = StringUtils.trimToNull((String)stringValue);
                    if (!StringUtils.isNotEmpty((String)field.getPattern())) break;
                    stringValue = StringHelper.removeMask(field.getPattern(), stringValue);
                }
            }
            try {
                CustomFieldValue existing = this.customFieldValueDao.load(field, owner, new Relationship[0]);
                existing.setStringValue(stringValue);
                existing.setPossibleValue(possibleValue);
                existing.setMemberValue(memberValue);
                if (value instanceof MemberCustomFieldValue) {
                    ((MemberCustomFieldValue)existing).setHidden(((MemberCustomFieldValue)value).isHidden());
                }
                this.customFieldValueDao.update(existing);
            }
            catch (EntityNotFoundException e) {
                value.setOwner(owner);
                value.setStringValue(stringValue);
                value.setPossibleValue(possibleValue);
                value.setMemberValue(memberValue);
                if (value.isTransient()) {
                    this.customFieldValueDao.insert(value);
                    continue;
                }
                this.customFieldValueDao.update(value);
            }
        }
    }

    protected Cache getCache() {
        return this.cacheManager.getCache("cyclos.cache.CustomFields." + this.customFieldType.getSimpleName());
    }

    protected Validator getValueValidator(Collection<? extends CustomField> fields) {
        Validator validator = new Validator();
        for (CustomField customField : fields) {
            RangeConstraint lengthConstraint;
            Validation validation;
            CustomField customField2 = this.fetchService.fetch(customField, new Relationship[0]);
            Validator.Property property = validator.property(customField2.getInternalName(), new CustomFieldRetrievingStrategy(customField2));
            property.displayName(customField2.getName());
            switch (customField2.getType()) {
                case BOOLEAN: {
                    property.anyOf("true", "false");
                    break;
                }
                case INTEGER: {
                    property.add(new IntegerValidator());
                    break;
                }
                case DATE: {
                    property.add(new DateValidator());
                    break;
                }
                case ENUMERATED: {
                    property.add(new EnumeratedValidator());
                    break;
                }
                case MEMBER: {
                    property.add(new MemberValidator());
                    break;
                }
                case DECIMAL: {
                    property.add(new BigDecimalValidator());
                    break;
                }
                case URL: {
                    property.url(true);
                }
            }
            if ((validation = customField2.getValidation()) == null) continue;
            boolean ignoreRequired = false;
            if (customField2 instanceof MemberCustomField) {
                ServiceClient client = LoggedUser.serviceClient();
                boolean bl = ignoreRequired = client != null && client.isIgnoreRegistrationValidations();
            }
            if (validation.isRequired() && !ignoreRequired) {
                property.required();
            }
            if ((lengthConstraint = validation.getLengthConstraint()) != null) {
                property.add(new LengthValidation(lengthConstraint));
            }
            if (validation.isUnique()) {
                property.add(new UniqueFieldValueValidation());
            }
            if (StringUtils.isNotEmpty((String)validation.getValidatorClass())) {
                PropertyValidation validatorClass = (PropertyValidation)this.customObjectHandler.get(validation.getValidatorClass());
                property.add(validatorClass);
            }
            if (customField2.getType() != CustomField.Type.ENUMERATED || customField2.getParent() == null) continue;
            property.add(new ParentValueValidation());
        }
        return validator;
    }

    protected abstract List<CF> list(CF var1);

    protected void lockUniqueFieldValue(CustomField field, CustomFieldValue value) {
        Pair<Object, Object> pair;
        if (field.getValidation().isUnique() && !this.uniqueObjectHandler.tryAcquire(pair = Pair.of(field, value.getValue()))) {
            throw new ValidationException(new UniqueError(field.getName()));
        }
    }

    protected Collection<? extends Relationship> resolveAdditionalFetch() {
        return Collections.emptySet();
    }

    private void copyParentProperties(CustomField parent, CustomField child) {
        PropertyDescriptor[] propertyDescriptors;
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)parent)) {
            boolean isReadable;
            String name = propertyDescriptor.getName();
            boolean isWritable = propertyDescriptor.getWriteMethod() != null;
            boolean bl = isReadable = propertyDescriptor.getReadMethod() != null;
            if (!isReadable || !isWritable || EXCLUDED_PROPERTIES_FOR_DEPENDENT_FIELDS.contains(name)) continue;
            Object value = PropertyHelper.get(parent, name);
            if (value instanceof Collection) {
                value = new ArrayList((Collection)value);
            }
            PropertyHelper.set(child, name, value);
        }
    }

    private ValidationException createValidationException(CustomField field) {
        ValidationException vex = new ValidationException(field.getInternalName(), new InvalidError());
        vex.setDisplayNameByProperty(Collections.singletonMap(field.getInternalName(), field.getName()));
        return vex;
    }

    private Validator getPossibleValueValidator() {
        if (this.possibleValueNavigator == null) {
            Validator validator = new Validator("customField.possibleValue");
            validator.property("field").required();
            validator.property("value").required().maxLength(255);
            this.possibleValueNavigator = validator;
        }
        return this.possibleValueNavigator;
    }

    private Validator getValidator() {
        if (this.validator == null) {
            Validator val = new Validator("customField");
            val.property("internalName").required().maxLength(50).add(new JavaIdentifierValidation()).add(new UniqueCustomFieldInternalNameValidation());
            val.property("name").required().maxLength(100);
            val.property("type").required();
            val.property("control").required();
            val.property("size").required();
            val.property("parent").add(new ParentValidator());
            val.property("validation.validatorClass").instanceOf(PropertyValidation.class);
            this.appendValidations(val);
            this.validator = val;
        }
        return this.validator;
    }

    private CF loadChecked(Long id) {
        CustomField field = (CustomField)this.customFieldDao.load(id, this.fetch);
        if (!this.customFieldType.isInstance(field)) {
            throw new EntityNotFoundException();
        }
        return (CF)field;
    }

    private CustomFieldPossibleValue loadCheckedPossibleValue(Long id) {
        CustomFieldPossibleValue possibleValue = (CustomFieldPossibleValue)this.customFieldPossibleValueDao.load(id, CustomFieldPossibleValue.Relationships.PARENT, CustomFieldPossibleValue.Relationships.FIELD);
        if (!this.customFieldType.isInstance(possibleValue.getField())) {
            throw new EntityNotFoundException();
        }
        return possibleValue;
    }

    private CustomFieldPossibleValue loadPossibleValue(CustomFieldValue v) {
        if (v.getPossibleValue() != null) {
            return v.getPossibleValue();
        }
        if (StringUtils.isEmpty((String)v.getValue())) {
            return null;
        }
        return this.loadPossibleValue(v.getValue(), v.getField());
    }

    private CustomFieldPossibleValue loadPossibleValue(String str, CustomField field) {
        CustomFieldPossibleValue possibleValue = null;
        boolean byValue = true;
        try {
            if (StringUtils.isNumeric((String)str)) {
                try {
                    possibleValue = (CustomFieldPossibleValue)this.customFieldPossibleValueDao.load(new Long(str), new Relationship[0]);
                    if (field.equals(possibleValue.getField())) {
                        byValue = false;
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
            }
            if (byValue) {
                possibleValue = this.customFieldPossibleValueDao.load(field.getId(), str);
            }
        }
        catch (EntityNotFoundException e) {
            possibleValue = null;
        }
        return possibleValue;
    }

    static {
        ArrayList<String> excluded = new ArrayList<String>();
        excluded.add("class");
        excluded.add("id");
        excluded.add("name");
        excluded.add("internalName");
        excluded.add("parent");
        excluded.add("description");
        excluded.add("allSelectedLabel");
        excluded.add("type");
        excluded.add("control");
        excluded.add("size");
        excluded.add("description");
        excluded.add("possibleValues");
        excluded.add("children");
        EXCLUDED_PROPERTIES_FOR_DEPENDENT_FIELDS = Collections.unmodifiableList(excluded);
    }

    public class UniqueFieldValueValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 6222393116036296454L;

        @Override
        public ValidationError validate(Object object, Object data, Object value) {
            if (!(object instanceof CustomFieldsContainer)) {
                return null;
            }
            if (object instanceof Transfer && ((Transfer)object).getScheduledPayment() != null) {
                return null;
            }
            CustomField field = (CustomField)data;
            String string = (String)value;
            if (StringUtils.isNotEmpty((String)string)) {
                CustomFieldValue fieldValue;
                try {
                    fieldValue = field.getNature().getValueType().newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                fieldValue.setField(field);
                fieldValue.setOwner(object);
                fieldValue.setStringValue(string);
                if (BaseCustomFieldServiceImpl.this.customFieldValueDao.valueExists(fieldValue)) {
                    return new UniqueError(fieldValue.getStringValue());
                }
            }
            return null;
        }
    }

    public class UniqueCustomFieldInternalNameValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 1L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            CustomField field = (CustomField)object;
            if (field.getInternalName() == null || field.getInternalName().equals("")) {
                return null;
            }
            return BaseCustomFieldServiceImpl.this.customFieldDao.isInternalNameUsed(field) ? new UniqueError(field.getInternalName()) : null;
        }
    }

    public static class PossibleValueKey
    implements Serializable {
        private static final long serialVersionUID = 6220627534414217532L;
        private final long id;

        public PossibleValueKey(long id) {
            this.id = id;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PossibleValueKey)) {
                return false;
            }
            PossibleValueKey key = (PossibleValueKey)obj;
            return this.id == key.id;
        }

        public int hashCode() {
            return (int)this.id;
        }
    }

    public class ParentValueValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 6222393116036296454L;

        @Override
        public ValidationError validate(Object object, Object data, Object value) {
            if (!(object instanceof CustomFieldsContainer)) {
                return null;
            }
            CustomFieldsContainer c = (CustomFieldsContainer)object;
            CustomField field = (CustomField)data;
            CustomFieldValue customFieldValue = null;
            CustomFieldPossibleValue possibleValue = null;
            CustomFieldValue parentCustomFieldValue = null;
            CustomFieldPossibleValue parentPossibleValue = null;
            for (CustomFieldValue cfv : c.getCustomValues()) {
                if (customFieldValue == null && cfv.getField().getId() == field.getId()) {
                    customFieldValue = cfv;
                } else if (parentCustomFieldValue == null && cfv.getField().getId() == field.getParent().getId()) {
                    parentCustomFieldValue = cfv;
                }
                if (customFieldValue == null || parentCustomFieldValue == null) continue;
                break;
            }
            if (customFieldValue == null) {
                return null;
            }
            possibleValue = BaseCustomFieldServiceImpl.this.loadPossibleValue(customFieldValue);
            if (possibleValue == null) {
                return null;
            }
            parentPossibleValue = BaseCustomFieldServiceImpl.this.loadPossibleValue(parentCustomFieldValue);
            if (parentPossibleValue == null || !parentPossibleValue.equals(possibleValue.getParent())) {
                return new ValidationError("expected value " + possibleValue.getParent() + " in parent of field " + field, new Object[0]);
            }
            return null;
        }
    }

    public final class ParentValidator
    implements PropertyValidation {
        private static final long serialVersionUID = -6383825246336857857L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            List<CustomField> possibleParents;
            CustomField field = (CustomField)object;
            CustomField parent = (CustomField)value;
            if (parent != null && !(possibleParents = BaseCustomFieldServiceImpl.this.listPossibleParentFields(field)).contains(parent)) {
                return new InvalidError();
            }
            return null;
        }
    }

    public class MemberValidator
    implements PropertyValidation {
        private static final long serialVersionUID = 5145399976834903999L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String idStr = (String)value;
            if (StringUtils.isEmpty((String)idStr)) {
                return null;
            }
            if (StringUtils.isNotEmpty((String)idStr)) {
                try {
                    Long id = Long.valueOf(idStr);
                    ElementVO elementVO = BaseCustomFieldServiceImpl.this.elementService.getElementVO(id);
                    if (elementVO.getNature() != Element.Nature.MEMBER) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    return new InvalidError();
                }
            }
            return null;
        }
    }

    public class JavaIdentifierValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 259170291118675512L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String string = (String)value;
            if (StringUtils.isNotEmpty((String)string) && !StringHelper.isValidJavaIdentifier(string)) {
                return new InvalidError();
            }
            return null;
        }
    }

    public class IntegerValidator
    implements PropertyValidation {
        private static final long serialVersionUID = 5145399976834903999L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String str = (String)value;
            if (StringUtils.isNotEmpty((String)str) && !StringUtils.isNumeric((String)str)) {
                return new InvalidError();
            }
            return null;
        }
    }

    public class EnumeratedValidator
    implements PropertyValidation {
        private static final long serialVersionUID = 5145399976834903999L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String str = (String)value;
            if (StringUtils.isEmpty((String)str)) {
                return null;
            }
            CustomField field = (CustomField)property;
            CustomFieldPossibleValue possibleValue = null;
            possibleValue = BaseCustomFieldServiceImpl.this.loadPossibleValue(str, field);
            return possibleValue == null ? new InvalidError() : null;
        }
    }

    public class DateValidator
    implements PropertyValidation {
        private static final long serialVersionUID = 5145399976834903999L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String str = (String)value;
            CalendarConverter dateConverter = BaseCustomFieldServiceImpl.this.settingsService.getLocalSettings().getRawDateConverter();
            try {
                int year;
                Calendar date = dateConverter.valueOf(str);
                if (date != null && ((year = date.get(1)) < 1900 || year > 2100)) {
                    return new InvalidError();
                }
                return null;
            }
            catch (ConversionException e) {
                return new InvalidError();
            }
        }
    }

    public class CustomFieldRetrievingStrategy
    implements Validator.PropertyRetrieveStrategy {
        private static final long serialVersionUID = 8667919404137289046L;
        private final CustomField field;

        public CustomFieldRetrievingStrategy(CustomField field) {
            this.field = field;
        }

        @Override
        public Object description(Object object, String name) {
            return this.field;
        }

        @Override
        public Object get(Object object) {
            String value;
            Collection values = (Collection)PropertyHelper.get(object, "customValues");
            Object fieldValue = BaseCustomFieldServiceImpl.this.customFieldHelper.findByField(this.field, values);
            String string = value = fieldValue == null ? null : ((CustomFieldValue)fieldValue).getValue();
            if (StringUtils.isNotEmpty((String)this.field.getPattern())) {
                value = StringHelper.removeMask(this.field.getPattern(), value);
            }
            return value;
        }
    }

    public final class BigDecimalValidator
    implements PropertyValidation {
        private static final long serialVersionUID = -7933981104151866154L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            String str = (String)value;
            NumberConverter<BigDecimal> numberConverter = BaseCustomFieldServiceImpl.this.settingsService.getLocalSettings().getNumberConverter();
            try {
                numberConverter.valueOf(str);
                return null;
            }
            catch (ConversionException e) {
                return new InvalidError();
            }
        }
    }
}

