/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Calendar;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.dao.customizations.CustomizedFileDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.alerts.SystemAlert;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.OperatorGroup;
import nl.strohalm.cyclos.services.alerts.AlertServiceLocal;
import nl.strohalm.cyclos.services.customization.CustomizedFileServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.utils.validation.Validator;

public class CustomizedFileServiceImpl
implements CustomizedFileServiceLocal {
    private FetchServiceLocal fetchService;
    private CustomizedFileDAO customizedFileDao;
    private AlertServiceLocal alertService;
    private PermissionServiceLocal permissionService;

    @Override
    public boolean canManageSystemCustomizedFiles() {
        return this.permissionService.hasPermission(AdminSystemPermission.CUSTOMIZED_FILES_MANAGE);
    }

    @Override
    public boolean canViewOrManageInGroup(Group group) {
        group = this.fetchService.fetch(group, new Relationship[0]);
        switch (group.getNature()) {
            case ADMIN: {
                return this.permissionService.hasPermission(AdminSystemPermission.ADMIN_GROUPS_MANAGE_ADMIN_CUSTOMIZED_FILES);
            }
            case MEMBER: 
            case BROKER: {
                return this.permissionService.hasPermission(AdminMemberPermission.GROUPS_MANAGE_MEMBER_CUSTOMIZED_FILES);
            }
            case OPERATOR: {
                return this.permissionService.permission(((OperatorGroup)group).getMember()).member(MemberPermission.OPERATORS_MANAGE).hasPermission();
            }
        }
        return false;
    }

    @Override
    public boolean canViewOrManageInGroupFilters() {
        return this.permissionService.hasPermission(AdminSystemPermission.GROUP_FILTERS_MANAGE_CUSTOMIZED_FILES);
    }

    @Override
    public boolean canViewSystemCustomizedFiles() {
        return this.permissionService.hasPermission(AdminSystemPermission.CUSTOMIZED_FILES_VIEW);
    }

    @Override
    public CustomizedFile load(Long id, Relationship ... fetch) {
        return (CustomizedFile)this.customizedFileDao.load(id, fetch);
    }

    @Override
    public CustomizedFile load(CustomizedFile.Type type, String name, Relationship ... fetch) {
        return this.customizedFileDao.load(type, name, fetch);
    }

    @Override
    public void notifyNewVersion(SystemAlert.Alerts alertType, CustomizedFile customizedFile) {
        this.alertService.create(alertType, customizedFile.getName());
    }

    @Override
    public CustomizedFile save(CustomizedFile customizedFile) {
        if (customizedFile.getGroup() != null) {
            customizedFile.setGroup(this.fetchService.fetch(customizedFile.getGroup(), new Relationship[0]));
        }
        if (customizedFile.getGroupFilter() != null) {
            customizedFile.setGroupFilter(this.fetchService.fetch(customizedFile.getGroupFilter(), new Relationship[0]));
        }
        return this.doSave(customizedFile);
    }

    @Override
    public CustomizedFile saveForTheme(CustomizedFile customizedFile) {
        return this.doSave(customizedFile);
    }

    @Override
    public List<CustomizedFile> search(CustomizedFileQuery query) {
        return this.customizedFileDao.search(query);
    }

    public void setAlertServiceLocal(AlertServiceLocal alertService) {
        this.alertService = alertService;
    }

    public void setCustomizedFileDao(CustomizedFileDAO customizedFileDAO) {
        this.customizedFileDao = customizedFileDAO;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    @Override
    public void stopCustomizing(CustomizedFile customizedFile) {
        customizedFile = this.fetchService.fetch(customizedFile, CustomizedFile.Relationships.GROUP);
        this.customizedFileDao.delete(customizedFile.getId());
    }

    @Override
    public void validate(CustomizedFile customizedFile) {
        this.getValidator().validate(customizedFile);
    }

    private CustomizedFile doSave(CustomizedFile customizedFile) {
        this.validate(customizedFile);
        if (customizedFile.isTransient() && customizedFile.getGroup() == null && customizedFile.getGroupFilter() == null) {
            try {
                CustomizedFile current = this.load(customizedFile.getType(), customizedFile.getName(), new Relationship[0]);
                current.setLastModified(Calendar.getInstance());
                current.setContents(customizedFile.getContents());
                current.setOriginalContents(customizedFile.getOriginalContents());
                current.setNewContents(customizedFile.getNewContents());
                return this.customizedFileDao.update(current);
            }
            catch (EntityNotFoundException e) {
                // empty catch block
            }
        }
        if (customizedFile.isTransient()) {
            customizedFile.setLastModified(Calendar.getInstance());
            return this.customizedFileDao.insert(customizedFile);
        }
        CustomizedFile current = this.load(customizedFile.getId(), CustomizedFile.Relationships.GROUP);
        current.setLastModified(Calendar.getInstance());
        current.setContents(customizedFile.getContents());
        current.setOriginalContents(customizedFile.getOriginalContents());
        current.setNewContents(customizedFile.getNewContents());
        return this.customizedFileDao.update(current);
    }

    private Validator getValidator() {
        Validator validator = new Validator("customizedFile");
        validator.property("name").required().maxLength(100);
        validator.property("type").required();
        return validator;
    }
}

