/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupFilter;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.CustomizedFileService;
import nl.strohalm.cyclos.services.customization.CustomizedFileServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CustomizedFileServiceSecurity
extends BaseServiceSecurity
implements CustomizedFileService {
    private CustomizedFileServiceLocal customizedFileService;

    @Override
    public boolean canViewOrManageInGroup(Group group) {
        return this.customizedFileService.canViewOrManageInGroup(group);
    }

    @Override
    public boolean canViewOrManageInGroupFilters() {
        return this.customizedFileService.canViewOrManageInGroupFilters();
    }

    @Override
    public CustomizedFile load(Long id, Relationship ... fetch) {
        CustomizedFile customizedFile = this.customizedFileService.load(id, fetch);
        if (!this.canView(customizedFile)) {
            throw new PermissionDeniedException();
        }
        return customizedFile;
    }

    @Override
    public CustomizedFile save(CustomizedFile customizedFile) {
        if (!this.canManage(customizedFile)) {
            throw new PermissionDeniedException();
        }
        return this.customizedFileService.save(customizedFile);
    }

    @Override
    public CustomizedFile saveForTheme(CustomizedFile customizedFile) {
        this.permissionService.permission().admin(AdminSystemPermission.THEMES_SELECT).check();
        return this.customizedFileService.saveForTheme(customizedFile);
    }

    @Override
    public List<CustomizedFile> search(CustomizedFileQuery query) {
        if (!this.applyQueryRestrictions(query)) {
            return Collections.emptyList();
        }
        return this.customizedFileService.search(query);
    }

    public void setCustomizedFileServiceLocal(CustomizedFileServiceLocal customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    @Override
    public void stopCustomizing(CustomizedFile customizedFile) {
        if (!this.canManage(customizedFile)) {
            throw new PermissionDeniedException();
        }
        this.customizedFileService.stopCustomizing(customizedFile);
    }

    @Override
    public void validate(CustomizedFile customizedFile) throws ValidationException {
        this.customizedFileService.validate(customizedFile);
    }

    private boolean applyQueryRestrictions(CustomizedFileQuery query) {
        query.setAll(false);
        if (query.getGroup() != null) {
            return this.canViewOrManageInGroup(query.getGroup());
        }
        if (query.getGroupFilter() != null) {
            return this.canViewOrManageInGroupFilters();
        }
        return this.customizedFileService.canViewSystemCustomizedFiles();
    }

    private boolean can(boolean manage, CustomizedFile customizedFile) {
        Group group = this.fetchService.fetch(customizedFile.getGroup(), new Relationship[0]);
        GroupFilter groupFilter = this.fetchService.fetch(customizedFile.getGroupFilter(), new Relationship[0]);
        if (group != null) {
            return this.canViewOrManageInGroup(group);
        }
        if (groupFilter != null) {
            return this.canViewOrManageInGroupFilters();
        }
        if (manage) {
            return this.customizedFileService.canManageSystemCustomizedFiles();
        }
        return this.customizedFileService.canViewSystemCustomizedFiles();
    }

    private boolean canManage(CustomizedFile customizedFile) {
        return this.can(true, customizedFile);
    }

    private boolean canView(CustomizedFile customizedFile) {
        return this.can(false, customizedFile);
    }
}

