/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.InputStream;
import java.sql.Blob;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.dao.customizations.BinaryFileDAO;
import nl.strohalm.cyclos.dao.customizations.DocumentDAO;
import nl.strohalm.cyclos.dao.customizations.DocumentPageDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.binaryfiles.BinaryFile;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentPage;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.SystemGroup;
import nl.strohalm.cyclos.services.customization.DocumentServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class DocumentServiceImpl
implements DocumentServiceLocal {
    private BinaryFileDAO binaryFileDao;
    private DocumentDAO documentDao;
    private DocumentPageDAO documentPageDao;
    private GroupServiceLocal groupService;

    @Override
    public Document load(Long id, Relationship ... fetch) {
        return (Document)this.documentDao.load(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.documentDao.delete(ids);
    }

    @Override
    public DynamicDocument saveDynamic(DynamicDocument document) {
        this.validate(document, false);
        DocumentPage formPage = document.getFormPage();
        DocumentPage documentPage = document.getDocumentPage();
        boolean isInsert = document.isTransient();
        if (isInsert) {
            document.setFormPage(null);
            document.setDocumentPage(null);
            AdminGroup group = (AdminGroup)this.groupService.load(((Entity)LoggedUser.group()).getId(), SystemGroup.Relationships.DOCUMENTS);
            document.addGroup(group);
            document = this.documentDao.insert(document);
            group.getDocuments().add(document);
            if (!group.getPermissions().contains(AdminMemberPermission.DOCUMENTS_DETAILS)) {
                group.getPermissions().add(AdminMemberPermission.DOCUMENTS_DETAILS);
            }
            group = this.groupService.update(group, false);
        } else {
            Document loadedDocument = (Document)this.documentDao.load(document.getId(), Document.Relationships.GROUPS, Document.Relationships.BROKER_GROUPS);
            Collection<SystemGroup> loadedGroups = loadedDocument.getGroups();
            Collection<BrokerGroup> loadedBrokerGroups = loadedDocument.getBrokerGroups();
            document.setGroups(loadedGroups);
            document.setBrokerGroups(loadedBrokerGroups);
            document = this.documentDao.update(document);
        }
        if (formPage != null) {
            formPage.setDocument(document);
            formPage.setName("Form page of " + document.getName());
            document.setFormPage(this.save(formPage));
        }
        documentPage.setDocument(document);
        documentPage.setName("Document page of " + document.getName());
        document.setDocumentPage(this.save(documentPage));
        if (isInsert) {
            document = this.documentDao.update(document);
        }
        return document;
    }

    @Override
    public StaticDocument saveStatic(StaticDocument document, InputStream stream, int size, String fileName, String contentType) {
        return this.doSaveStatic(document, stream, size, fileName, contentType);
    }

    @Override
    public List<Document> search(DocumentQuery documentQuery) {
        return this.documentDao.search(documentQuery);
    }

    public void setBinaryFileDao(BinaryFileDAO binaryFileDao) {
        this.binaryFileDao = binaryFileDao;
    }

    public void setDocumentDao(DocumentDAO documentDao) {
        this.documentDao = documentDao;
    }

    public void setDocumentPageDao(DocumentPageDAO documentPageDao) {
        this.documentPageDao = documentPageDao;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    @Override
    public void validate(Document document, boolean validateBinaryFile) {
        if (document instanceof DynamicDocument) {
            this.getDynamicValidator().validate(document);
        } else if (document instanceof MemberDocument) {
            this.getMemberValidator(validateBinaryFile).validate(document);
        } else {
            this.getStaticValidator(validateBinaryFile).validate(document);
        }
    }

    private StaticDocument doSaveStatic(StaticDocument document, InputStream stream, int size, String fileName, String contentType) {
        BinaryFile binaryFile = this.retrieveBinaryFile(stream, size, fileName, contentType);
        document.setBinaryFile(binaryFile);
        this.validate(document, true);
        if (document.isTransient()) {
            binaryFile = this.binaryFileDao.insert(binaryFile);
            document.setBinaryFile(binaryFile);
            SystemGroup group = (SystemGroup)this.groupService.load(((Entity)LoggedUser.group()).getId(), SystemGroup.Relationships.DOCUMENTS);
            group.addDocument(document);
            document.addGroup(group);
            document = this.documentDao.insert(document);
            if (LoggedUser.isAdministrator()) {
                group.getPermissions().add(AdminMemberPermission.DOCUMENTS_DETAILS);
            } else if (LoggedUser.isBroker()) {
                group.getPermissions().add(BrokerPermission.DOCUMENTS_VIEW);
            }
            this.groupService.update(group, false);
        } else {
            StaticDocument loadedDocument = (StaticDocument)this.load(document.getId(), Document.Relationships.GROUPS, Document.Relationships.BROKER_GROUPS, StaticDocument.Relationships.BINARY_FILE);
            BinaryFile loadedBinaryFile = loadedDocument.getBinaryFile();
            if (binaryFile != null) {
                loadedBinaryFile.setContentType(binaryFile.getContentType());
                loadedBinaryFile.setName(binaryFile.getName());
                loadedBinaryFile.setSize(binaryFile.getSize());
                loadedBinaryFile.setLastModified(binaryFile.getLastModified());
                loadedBinaryFile.setContents(binaryFile.getContents());
                loadedBinaryFile = this.binaryFileDao.update(loadedBinaryFile);
            }
            document.setBinaryFile(loadedBinaryFile);
            if (!(loadedDocument instanceof MemberDocument)) {
                Collection<SystemGroup> loadedGroups = loadedDocument.getGroups();
                Collection<BrokerGroup> loadedBrokerGroups = loadedDocument.getBrokerGroups();
                document.setGroups(loadedGroups);
                document.setBrokerGroups(loadedBrokerGroups);
            }
            this.documentDao.update(document);
        }
        return document;
    }

    private Validator getBasicValidator() {
        Validator validator = new Validator("document");
        validator.property("name").required().maxLength(100);
        validator.property("description").maxLength(1000);
        return validator;
    }

    private Validator getDynamicValidator() {
        Validator dynamicValidator = this.getBasicValidator();
        dynamicValidator.property("documentPage.contents").key("document.documentPage").required();
        return dynamicValidator;
    }

    private Validator getMemberValidator(boolean validateBinaryFile) {
        Validator memberValidator = this.getBasicValidator();
        if (validateBinaryFile) {
            memberValidator.property("binaryFile").add(new BinaryFileValidation());
        }
        memberValidator.property("member").required();
        memberValidator.property("visibility").required();
        return memberValidator;
    }

    private Validator getStaticValidator(boolean validateBinaryFile) {
        Validator staticValidator = this.getBasicValidator();
        if (validateBinaryFile) {
            staticValidator.property("binaryFile").add(new BinaryFileValidation());
        }
        return staticValidator;
    }

    private BinaryFile retrieveBinaryFile(InputStream stream, int size, String fileName, String contentType) {
        if (stream != null && size > 0) {
            Blob contents = this.documentDao.createBlob(stream, size);
            BinaryFile binaryFile = new BinaryFile();
            binaryFile.setContentType(contentType);
            binaryFile.setName(fileName);
            binaryFile.setSize(size);
            binaryFile.setLastModified(Calendar.getInstance());
            binaryFile.setContents(contents);
            return binaryFile;
        }
        return null;
    }

    private DocumentPage save(DocumentPage page) {
        page.setLastModified(Calendar.getInstance());
        if (page.isTransient()) {
            return this.documentPageDao.insert(page);
        }
        return this.documentPageDao.update(page);
    }

    public class BinaryFileValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 7546191238179831809L;

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            StaticDocument document = (StaticDocument)object;
            if (document.isTransient() && document.getBinaryFile() == null) {
                return new RequiredError(new Object[0]);
            }
            return null;
        }
    }
}

