/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.documents.Document;
import nl.strohalm.cyclos.entities.customization.documents.DocumentQuery;
import nl.strohalm.cyclos.entities.customization.documents.DynamicDocument;
import nl.strohalm.cyclos.entities.customization.documents.MemberDocument;
import nl.strohalm.cyclos.entities.customization.documents.StaticDocument;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.DocumentService;
import nl.strohalm.cyclos.services.customization.DocumentServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;

public class DocumentServiceSecurity
extends BaseServiceSecurity
implements DocumentService {
    private DocumentServiceLocal documentService;

    @Override
    public Document load(Long id, Relationship ... fetch) {
        Document doc = this.documentService.load(id, fetch);
        this.checkView(doc);
        return doc;
    }

    @Override
    public int remove(Long ... ids) {
        for (Long id : ids) {
            Document md = this.documentService.load(id, new Relationship[0]);
            this.checkManage(md);
        }
        return this.documentService.remove(ids);
    }

    @Override
    public Document saveDynamic(DynamicDocument document) {
        this.checkManage(document);
        return this.documentService.saveDynamic(document);
    }

    @Override
    public Document saveStatic(StaticDocument document, InputStream stream, int size, String fileName, String contentType) {
        this.checkManage(document);
        return this.documentService.saveStatic(document, stream, size, fileName, contentType);
    }

    @Override
    public List<Document> search(DocumentQuery documentQuery) {
        if (!this.applyQueryRestrictions(documentQuery)) {
            return Collections.emptyList();
        }
        return this.documentService.search(documentQuery);
    }

    public void setDocumentServiceLocal(DocumentServiceLocal documentService) {
        this.documentService = documentService;
    }

    @Override
    public void validate(Document document, boolean validateBinaryFile) {
        this.documentService.validate(document, validateBinaryFile);
    }

    private boolean applyAllowedDocumentNatures(DocumentQuery documentQuery) {
        ArrayList<Document.Nature> allowedNatures = new ArrayList<Document.Nature>();
        if (LoggedUser.isAdministrator()) {
            if (documentQuery.getMember() != null) {
                allowedNatures.add(Document.Nature.DYNAMIC);
                allowedNatures.add(Document.Nature.MEMBER);
            } else {
                allowedNatures.add(Document.Nature.DYNAMIC);
                allowedNatures.add(Document.Nature.STATIC);
            }
        } else if (LoggedUser.isMember()) {
            Member member = this.fetchService.fetch(documentQuery.getMember(), Member.Relationships.BROKER);
            if (LoggedUser.isBroker() && !LoggedUser.member().equals(member)) {
                if (member.getBroker() != null && member.getBroker().equals(LoggedUser.member())) {
                    allowedNatures.add(Document.Nature.DYNAMIC);
                    allowedNatures.add(Document.Nature.MEMBER);
                } else {
                    allowedNatures.add(Document.Nature.DYNAMIC);
                    allowedNatures.add(Document.Nature.MEMBER);
                    allowedNatures.add(Document.Nature.STATIC);
                }
            } else {
                allowedNatures.add(Document.Nature.DYNAMIC);
                allowedNatures.add(Document.Nature.MEMBER);
                allowedNatures.add(Document.Nature.STATIC);
            }
        }
        Collection<Document.Nature> natures = PermissionHelper.checkSelection(allowedNatures, documentQuery.getNatures());
        documentQuery.setNatures(natures);
        return natures != null;
    }

    private boolean applyQueryRestrictions(DocumentQuery query) {
        Collection<Group> visibleGroups = PermissionHelper.checkSelection(this.permissionService.getAllVisibleGroups(), query.getVisibleGroups());
        if (visibleGroups == null) {
            return false;
        }
        query.setViewer((Element)LoggedUser.element());
        query.setVisibleGroups(visibleGroups);
        if (LoggedUser.isBroker()) {
            if (query.getMember() == null) {
                query.setMember(LoggedUser.member());
            }
            query.setBrokerCanViewMemberDocuments(this.permissionService.hasPermission(BrokerPermission.DOCUMENTS_VIEW_MEMBER));
        } else if (LoggedUser.isMember()) {
            query.setMember(LoggedUser.member());
        }
        if (query.getMember() != null && !this.permissionService.manages(query.getMember())) {
            return false;
        }
        return this.applyAllowedDocumentNatures(query);
    }

    private boolean canManage(Document document) {
        if (document instanceof MemberDocument) {
            if (!this.permissionService.permission().admin(AdminMemberPermission.DOCUMENTS_MANAGE_MEMBER).broker(BrokerPermission.DOCUMENTS_MANAGE_MEMBER).hasPermission()) {
                return false;
            }
            return this.permissionService.manages(((MemberDocument)document).getMember());
        }
        if (document instanceof StaticDocument) {
            return this.permissionService.permission().admin(AdminMemberPermission.DOCUMENTS_MANAGE_STATIC).hasPermission();
        }
        return this.permissionService.permission().admin(AdminMemberPermission.DOCUMENTS_MANAGE_DYNAMIC).hasPermission();
    }

    private void checkManage(Document document) {
        if (!this.canManage(document)) {
            throw new PermissionDeniedException();
        }
    }

    private void checkView(Document doc) {
        if (doc instanceof MemberDocument) {
            MemberDocument mDoc = (MemberDocument)doc;
            mDoc = this.fetchService.fetch(mDoc, MemberDocument.Relationships.MEMBER);
            MemberDocument.Visibility visibility = mDoc.getVisibility();
            if (((Group)LoggedUser.group()).getNature() == Group.Nature.MEMBER && visibility != MemberDocument.Visibility.MEMBER || LoggedUser.isBroker() && visibility == MemberDocument.Visibility.ADMIN) {
                throw new PermissionDeniedException();
            }
            this.permissionService.permission(mDoc.getMember()).admin(AdminMemberPermission.DOCUMENTS_MANAGE_MEMBER).broker(BrokerPermission.DOCUMENTS_VIEW_MEMBER).member(new MemberPermission[0]).check();
        } else {
            this.permissionService.permission().adminFor(AdminMemberPermission.DOCUMENTS_DETAILS, doc).brokerFor(BrokerPermission.DOCUMENTS_VIEW, doc).memberFor(MemberPermission.DOCUMENTS_VIEW, doc).check();
        }
    }
}

