/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import nl.strohalm.cyclos.dao.customizations.ImageDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFile;
import nl.strohalm.cyclos.entities.customization.files.CustomizedFileQuery;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.customization.images.CustomImage;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.ImageCaptionDTO;
import nl.strohalm.cyclos.entities.customization.images.ImageDetailsDTO;
import nl.strohalm.cyclos.entities.customization.images.MemberImage;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.customization.images.StyleImage;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.customization.CustomizedFileServiceLocal;
import nl.strohalm.cyclos.services.customization.ImageServiceLocal;
import nl.strohalm.cyclos.services.customization.exceptions.ImageException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.Dimensions;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.webservices.model.ImageVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.web.context.ServletContextAware;

public class ImageServiceImpl
implements ImageServiceLocal,
InitializingService,
ServletContextAware {
    private static final String SYSTEM_IMAGES_PATH = "/WEB-INF/images/system";
    private static final String STYLE_IMAGES_PATH = "/WEB-INF/images/style";
    private static final int MAX_IMAGE_SIZE_MULTIPLIER = 5;
    private FetchServiceLocal fetchService;
    private ImageDAO imageDao;
    private SettingsServiceLocal settingsService;
    private ServletContext servletContext;
    private CustomizedFileServiceLocal customizedFileService;
    private nl.strohalm.cyclos.webservices.utils.ImageHelper imageHelper;
    private static final Dimensions SYSTEM_IMAGE_DIMENSIONS = new Dimensions(3000, 3000);

    @Override
    public ImageVO getImageVO(SystemImage systemImage) {
        return this.imageHelper.toVO(systemImage);
    }

    @Override
    public void initializeService() {
        if (this.servletContext == null) {
            return;
        }
        File systemImagesDir = new File(this.servletContext.getRealPath(SYSTEM_IMAGES_PATH));
        this.importNewImages(systemImagesDir.listFiles(), Image.Nature.SYSTEM);
        CustomizedFileQuery query = new CustomizedFileQuery();
        query.setType(CustomizedFile.Type.STYLE);
        query.setPageForCount();
        boolean hasCssFiles = PageHelper.hasResults(this.customizedFileService.search(query));
        if (!hasCssFiles) {
            File styleImagesDir = new File(this.servletContext.getRealPath(STYLE_IMAGES_PATH));
            this.importNewImages(styleImagesDir.listFiles(), Image.Nature.STYLE);
        }
    }

    @Override
    public List<? extends Image> listByNature(Image.Nature nature) {
        return this.imageDao.listByNature(nature);
    }

    @Override
    public List<? extends OwneredImage> listByOwner(Entity owner) {
        return this.imageDao.listByOwner(owner);
    }

    @Override
    public Image load(Long id, Relationship ... fetch) {
        return (Image)this.imageDao.load(id, fetch);
    }

    public File[] newSystemImages() {
        File dir = new File(this.servletContext.getRealPath(SYSTEM_IMAGES_PATH));
        return dir.listFiles();
    }

    @Override
    public Image reload(Long id, Relationship ... fetch) throws EntityNotFoundException {
        return (Image)this.imageDao.reload(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        return this.imageDao.delete(ids);
    }

    @Override
    public int removeStyleImage(String imageName) {
        try {
            Image img = this.imageDao.load(Image.Nature.STYLE, imageName);
            return this.imageDao.delete(img.getId());
        }
        catch (EntityNotFoundException e) {
            return 0;
        }
    }

    @Override
    public <T extends OwneredImage> T save(Entity owner, String caption, ImageHelper.ImageType type, String name, InputStream in) {
        if (owner instanceof Ad) {
            return (T)this.doSaveAdImage((Ad)owner, caption, type, name, in);
        }
        if (owner instanceof Member) {
            return (T)this.doSaveMemberImage((Member)owner, caption, type, name, in);
        }
        throw new IllegalArgumentException("Unsupported owner image: " + owner);
    }

    @Override
    public Image save(Image.Nature nature, ImageHelper.ImageType type, String name, InputStream in) {
        Image image = null;
        switch (nature) {
            case SYSTEM: {
                try {
                    image = this.load(Image.Nature.SYSTEM, name);
                }
                catch (EntityNotFoundException e) {
                    image = new SystemImage();
                }
                break;
            }
            case STYLE: {
                try {
                    image = this.load(Image.Nature.STYLE, name);
                }
                catch (EntityNotFoundException e) {
                    image = new StyleImage();
                }
                break;
            }
            case CUSTOM: {
                try {
                    image = this.load(Image.Nature.CUSTOM, name);
                }
                catch (EntityNotFoundException e) {
                    image = new CustomImage();
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid nature: " + nature);
            }
        }
        image = this.save(image, in, type.getContentType(), name);
        this.fetchService.reload(image, new Relationship[0]);
        return image;
    }

    @Override
    public void saveDetails(ImageDetailsDTO details) {
        Entity owner = details.getImageOwner();
        int order = 0;
        for (ImageCaptionDTO dto : details.getDetails()) {
            OwneredImage image = (OwneredImage)this.imageDao.load(dto.getId(), new Relationship[0]);
            if (!image.getOwner().equals(owner)) {
                throw new PermissionDeniedException();
            }
            image.setOrder(order++);
            image.setCaption(dto.getCaption());
            this.imageDao.update(image);
        }
    }

    public void setCustomizedFileServiceLocal(CustomizedFileServiceLocal customizedFileService) {
        this.customizedFileService = customizedFileService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setImageDao(ImageDAO imageDao) {
        this.imageDao = imageDao;
    }

    public void setImageHelper(nl.strohalm.cyclos.webservices.utils.ImageHelper imageHelper) {
        this.imageHelper = imageHelper;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    private AdImage doSaveAdImage(Ad ad, String caption, ImageHelper.ImageType type, String name, InputStream in) {
        ad = this.fetchService.fetch(ad, RelationshipHelper.nested(Ad.Relationships.OWNER, Element.Relationships.GROUP));
        int maxImages = ad.getOwner().getMemberGroup().getMemberSettings().getMaxAdImagesPerMember();
        int count = this.imageDao.countAdImages(ad);
        if (count >= maxImages) {
            throw new PermissionDeniedException();
        }
        AdImage image = new AdImage();
        image.setAd(ad);
        image.setCaption(caption);
        image.setOrder(count + 1);
        return this.save(image, in, type.getContentType(), name);
    }

    private MemberImage doSaveMemberImage(Member member, String caption, ImageHelper.ImageType type, String name, InputStream in) {
        member = this.fetchService.fetch(member, Element.Relationships.GROUP);
        int maxImages = member.getMemberGroup().getMemberSettings().getMaxImagesPerMember();
        int count = this.imageDao.countMemberImages(member);
        if (count >= maxImages) {
            throw new PermissionDeniedException();
        }
        MemberImage image = new MemberImage();
        image.setMember(member);
        image.setCaption(caption);
        image.setOrder(count + 1);
        return this.save(image, in, type.getContentType(), name);
    }

    private Set<File> generateBlobs(Image image, InputStream in) throws IOException {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        File originalFile = File.createTempFile("cyclos", "image");
        IOUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(originalFile));
        ImageHelper.ImageType type = ImageHelper.ImageType.getByContentType(image.getContentType());
        File imageFile = null;
        File thumbnailFile = null;
        if (type.isResizeSupported()) {
            Dimensions maxImageDimensions = image instanceof SystemImage ? SYSTEM_IMAGE_DIMENSIONS : localSettings.getMaxImageDimensions();
            Dimensions maxThumbnailDimensions = localSettings.getMaxThumbnailDimensions();
            BufferedImage bufImage = ImageIO.read(originalFile);
            Dimensions originalDimensions = new Dimensions(bufImage.getWidth(), bufImage.getHeight());
            if (originalDimensions.isGreaterThan(new Dimensions(maxImageDimensions.getWidth() * 5, maxImageDimensions.getHeight() * 5))) {
                throw new ImageException(ImageException.INVALID_DIMENSION);
            }
            if (image.getNature() != Image.Nature.STYLE && originalDimensions.isGreaterThan(maxImageDimensions)) {
                imageFile = ImageHelper.resizeGivenMaxDimensions(bufImage, type.getContentType(), maxImageDimensions);
            }
            if (originalDimensions.isGreaterThan(maxThumbnailDimensions)) {
                thumbnailFile = ImageHelper.resizeGivenMaxDimensions(bufImage, type.getContentType(), maxThumbnailDimensions);
            }
        }
        if (imageFile == null) {
            imageFile = originalFile;
        }
        if (thumbnailFile == null) {
            thumbnailFile = originalFile;
        }
        int imageSize = (int)imageFile.length();
        image.setImage(this.imageDao.createBlob(new FileInputStream(imageFile), imageSize));
        image.setImageSize(imageSize);
        int thumbnailSize = (int)thumbnailFile.length();
        image.setThumbnail(this.imageDao.createBlob(new FileInputStream(thumbnailFile), thumbnailSize));
        image.setThumbnailSize(thumbnailSize);
        return new HashSet<File>(Arrays.asList(originalFile, imageFile, thumbnailFile));
    }

    private void importNewImages(File[] newImages, Image.Nature nature) {
        for (File file : newImages) {
            ImageHelper.ImageType type;
            String fileName = file.getName();
            try {
                type = ImageHelper.ImageType.getByFileName(fileName);
            }
            catch (Exception e) {
                continue;
            }
            try {
                this.load(nature, fileName);
            }
            catch (EntityNotFoundException e) {
                try {
                    this.save(nature, type, fileName, new FileInputStream(file));
                }
                catch (FileNotFoundException e1) {
                    throw new IllegalStateException("File not found?!? " + e1);
                }
            }
        }
    }

    private Image load(Image.Nature nature, String name) {
        if (nature.getOwnerProperty() != null) {
            throw new EntityNotFoundException(Image.class);
        }
        return this.imageDao.load(nature, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <I extends Image> I save(I image, InputStream in, String contentType, String name) {
        image.setContentType(contentType);
        image.setName(name);
        image.setLastModified(Calendar.getInstance());
        Set<File> openFiles = null;
        try {
            try {
                openFiles = this.generateBlobs(image, in);
            }
            catch (ImageException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ImageException(e);
            }
            image = image.isTransient() ? this.imageDao.insert(image, true) : this.imageDao.update(image, true);
            I i = image;
            return i;
        }
        finally {
            if (CollectionUtils.isNotEmpty(openFiles)) {
                for (File file : openFiles) {
                    file.delete();
                }
            }
        }
    }
}

