/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.InputStream;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.access.OperatorPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.EntityReference;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.customization.images.AdImage;
import nl.strohalm.cyclos.entities.customization.images.Image;
import nl.strohalm.cyclos.entities.customization.images.ImageDetailsDTO;
import nl.strohalm.cyclos.entities.customization.images.MemberImage;
import nl.strohalm.cyclos.entities.customization.images.OwneredImage;
import nl.strohalm.cyclos.entities.customization.images.SystemImage;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.ImageService;
import nl.strohalm.cyclos.services.customization.ImageServiceLocal;
import nl.strohalm.cyclos.utils.EntityHelper;
import nl.strohalm.cyclos.utils.ImageHelper;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.webservices.model.ImageVO;

public class ImageServiceSecurity
extends BaseServiceSecurity
implements ImageService {
    private ImageServiceLocal imageService;

    @Override
    public ImageVO getImageVO(SystemImage systemImage) {
        return this.imageService.getImageVO(systemImage);
    }

    @Override
    public List<? extends Image> listByNature(Image.Nature nature) {
        return this.imageService.listByNature(nature);
    }

    @Override
    public List<? extends OwneredImage> listByOwner(Entity owner) {
        this.permissionService.checkRelatesTo(this.getOwnerMember(owner));
        return this.imageService.listByOwner(owner);
    }

    @Override
    public Image load(Long id, Relationship ... fetch) {
        return this.imageService.load(id, fetch);
    }

    @Override
    public Image reload(Long id, Relationship ... fetch) throws EntityNotFoundException {
        this.checkIsSystem();
        return this.imageService.reload(id, fetch);
    }

    @Override
    public int remove(Long ... ids) {
        if (ids == null) {
            return 0;
        }
        for (Long id : ids) {
            this.checkManagement(this.imageService.load(id, RelationshipHelper.nested(AdImage.Relationships.AD, Ad.Relationships.OWNER), MemberImage.Relationships.MEMBER));
        }
        return this.imageService.remove(ids);
    }

    @Override
    public int removeStyleImage(String imageName) {
        this.permissionService.permission().admin(AdminSystemPermission.THEMES_SELECT).check();
        return this.imageService.removeStyleImage(imageName);
    }

    @Override
    public <T extends OwneredImage> T save(Entity owner, String caption, ImageHelper.ImageType type, String name, InputStream in) {
        this.checkManagement(owner instanceof Ad ? Image.Nature.AD : Image.Nature.MEMBER, this.getOwnerMember(owner));
        return this.imageService.save(owner, caption, type, name, in);
    }

    @Override
    public Image save(Image.Nature nature, ImageHelper.ImageType type, String name, InputStream in) {
        if (!this.permissionService.hasPermission(AdminSystemPermission.THEMES_SELECT)) {
            this.checkManagement(nature, null);
        }
        return this.imageService.save(nature, type, name, in);
    }

    @Override
    public void saveDetails(ImageDetailsDTO details) {
        Entity owner = details.getOwner();
        if (owner instanceof EntityReference) {
            owner = EntityHelper.reference(details.getNature() == Image.Nature.AD ? Ad.class : Member.class, details.getOwner().getId());
        }
        this.checkManagement(details.getNature(), this.getOwnerMember(owner));
        this.imageService.saveDetails(details);
    }

    public void setImageServiceLocal(ImageServiceLocal imageService) {
        this.imageService = imageService;
    }

    private void checkManagement(Image image) {
        switch (image.getNature()) {
            case AD: {
                this.checkManagement(image.getNature(), ((Ad)((AdImage)image).getOwner()).getOwner());
                break;
            }
            case MEMBER: {
                this.checkManagement(image.getNature(), ((MemberImage)image).getMember());
                break;
            }
            case SYSTEM: 
            case CUSTOM: 
            case STYLE: {
                this.checkManagement(image.getNature(), null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image's nature: " + image.getNature());
            }
        }
    }

    private void checkManagement(Image.Nature nature, Member member) {
        switch (nature) {
            case AD: {
                this.permissionService.permission(member).admin(AdminMemberPermission.ADS_MANAGE).broker(BrokerPermission.ADS_MANAGE).member(MemberPermission.ADS_PUBLISH).operator(OperatorPermission.ADS_PUBLISH).check();
                break;
            }
            case MEMBER: {
                this.permissionService.permission(member).admin(AdminMemberPermission.MEMBERS_CHANGE_PROFILE).broker(BrokerPermission.MEMBERS_CHANGE_PROFILE).member(new MemberPermission[0]).check();
                break;
            }
            case SYSTEM: 
            case CUSTOM: 
            case STYLE: {
                this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_IMAGES_MANAGE).check();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown image's nature: " + nature);
            }
        }
    }

    private Member getOwnerMember(Entity owner) {
        if (owner instanceof Ad) {
            return this.fetchService.fetch((Ad)owner, Ad.Relationships.OWNER).getOwner();
        }
        if (owner instanceof Member) {
            return (Member)owner;
        }
        throw new PermissionDeniedException();
    }
}

