/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.accounts.loans.LoanGroupQuery;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.LoanGroupCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldService;
import nl.strohalm.cyclos.services.customization.LoanGroupCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.loangroups.LoanGroupServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class LoanGroupCustomFieldServiceSecurity
extends BaseServiceSecurity
implements LoanGroupCustomFieldService {
    private LoanGroupCustomFieldServiceLocal loanGroupCustomFieldService;
    private LoanGroupServiceLocal loanGroupService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView();
        return this.loanGroupCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        this.checkView();
        return this.loanGroupCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView();
        return this.loanGroupCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<LoanGroupCustomField> list() {
        this.checkView();
        return this.loanGroupCustomFieldService.list();
    }

    @Override
    public List<LoanGroupCustomField> listPossibleParentFields(LoanGroupCustomField field) {
        this.checkView();
        return this.loanGroupCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<LoanGroupCustomField> load(Collection<Long> ids) {
        this.checkView();
        return this.loanGroupCustomFieldService.load(ids);
    }

    @Override
    public LoanGroupCustomField load(Long id) {
        this.checkView();
        return (LoanGroupCustomField)this.loanGroupCustomFieldService.load(id);
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        this.checkView();
        return this.loanGroupCustomFieldService.loadPossibleValue(id);
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        this.checkView();
        return this.loanGroupCustomFieldService.loadPossibleValues(ids);
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.loanGroupCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.loanGroupCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.loanGroupCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.loanGroupCustomFieldService.save(possibleValue);
    }

    @Override
    public LoanGroupCustomField save(LoanGroupCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.loanGroupCustomFieldService.save(field);
    }

    public void setLoanGroupCustomFieldServiceLocal(LoanGroupCustomFieldServiceLocal loanGroupCustomFieldService) {
        this.loanGroupCustomFieldService = loanGroupCustomFieldService;
    }

    public void setLoanGroupServiceLocal(LoanGroupServiceLocal loanGroupService) {
        this.loanGroupService = loanGroupService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.loanGroupCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.loanGroupCustomFieldService.validate(possibleValue);
    }

    @Override
    public void validate(LoanGroupCustomField field) throws ValidationException {
        this.loanGroupCustomFieldService.validate(field);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_MANAGE).check();
    }

    private void checkView() {
        if (LoggedUser.isAdministrator()) {
            this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_VIEW, AdminSystemPermission.LOAN_GROUPS_VIEW, AdminMemberPermission.LOAN_GROUPS_VIEW).check();
            return;
        }
        Member member = LoggedUser.member();
        if (member != null) {
            boolean hasLoanGroups;
            LoanGroupQuery lgq = new LoanGroupQuery();
            lgq.setPageForCount();
            lgq.setMember(member);
            boolean bl = hasLoanGroups = PageHelper.getTotalCount(this.loanGroupService.search(lgq)) > 0;
            if (hasLoanGroups) {
                return;
            }
        }
        throw new PermissionDeniedException();
    }
}

