/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomField;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomFieldValue;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.PendingMember;
import nl.strohalm.cyclos.entities.members.RegisteredMember;
import nl.strohalm.cyclos.entities.members.imports.ImportedMember;
import nl.strohalm.cyclos.services.customization.BaseGlobalCustomFieldServiceImpl;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;

public class MemberCustomFieldServiceImpl
extends BaseGlobalCustomFieldServiceImpl<MemberCustomField>
implements MemberCustomFieldServiceLocal {
    public MemberCustomFieldServiceImpl() {
        super(MemberCustomField.class, CustomField.Nature.MEMBER);
    }

    @Override
    public Validator getValueValidator(MemberGroup group, MemberCustomField.Access access) {
        ArrayList<MemberCustomField> fields = new ArrayList<MemberCustomField>(this.list());
        if (access != null) {
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                MemberCustomField field = (MemberCustomField)iterator.next();
                if (access == MemberCustomField.Access.REGISTRATION && (field.getUpdateAccess() == MemberCustomField.Access.MEMBER_NOT_REGISTRATION || field.getVisibilityAccess() == MemberCustomField.Access.MEMBER_NOT_REGISTRATION)) {
                    iterator.remove();
                    continue;
                }
                if (access.compareTo(field.getUpdateAccess()) <= 0 && access.compareTo(field.getVisibilityAccess()) <= 0) continue;
                iterator.remove();
            }
        }
        return this.getValueValidator(this.customFieldHelper.onlyForGroup(fields, group));
    }

    @Override
    public void saveValues(ImportedMember importedMember) {
        this.getValueValidator(importedMember.getImport().getGroup(), MemberCustomField.Access.REGISTRATION).validate(importedMember);
        this.doSaveValues(importedMember);
    }

    @Override
    public void saveValues(RegisteredMember registeredMember) {
        boolean isPublic = !LoggedUser.hasUser();
        boolean byOwner = false;
        boolean byBroker = false;
        Element element = null;
        Group group = null;
        if (isPublic) {
            group = registeredMember.getMemberGroup();
            byOwner = true;
        } else {
            element = (Element)LoggedUser.element();
            group = element.getGroup();
            byOwner = element.equals(registeredMember);
            byBroker = element.equals(registeredMember.getBroker());
        }
        MemberCustomField.Access access = null;
        if (isPublic) {
            access = MemberCustomField.Access.REGISTRATION;
        } else if (byOwner) {
            access = MemberCustomField.Access.MEMBER;
        } else if (byBroker) {
            access = MemberCustomField.Access.BROKER;
        } else if (LoggedUser.hasUser() && LoggedUser.isAdministrator()) {
            access = MemberCustomField.Access.ADMIN;
        }
        Collection customValues = registeredMember.getCustomValues();
        registeredMember = (RegisteredMember)((Object)this.fetchService.fetch((Entity)((Object)registeredMember), Element.Relationships.GROUP, PendingMember.Relationships.MEMBER_GROUP, Member.Relationships.BROKER));
        this.getValueValidator(registeredMember.getMemberGroup(), access).validate(registeredMember);
        if (customValues != null) {
            for (MemberCustomFieldValue value : customValues) {
                CustomFieldValue current;
                MemberCustomField field = (MemberCustomField)this.fetchService.fetch(value.getField(), new Relationship[0]);
                MemberCustomField.Access updateAccess = field.getUpdateAccess();
                if (updateAccess.granted(group, byOwner, byBroker, isPublic, LoggedUser.isWebService())) continue;
                try {
                    current = this.customFieldValueDao.load(field, registeredMember, new Relationship[0]);
                }
                catch (EntityNotFoundException e) {
                    current = new MemberCustomFieldValue();
                }
                value.setStringValue(current.getStringValue());
                value.setPossibleValue(current.getPossibleValue());
            }
        }
        this.doSaveValues(registeredMember);
    }

    @Override
    protected void appendValidations(Validator validator) {
        validator.general(new GeneralValidation(){
            private static final long serialVersionUID = -7872725176651230479L;

            @Override
            public ValidationError validate(Object object) {
                MemberCustomField field = (MemberCustomField)object;
                if (field.getIndexing() != MemberCustomField.Indexing.NONE && field.getVisibilityAccess() != MemberCustomField.Access.OTHER) {
                    return new ValidationError("customField.member.error.indexingVisibility", new Object[0]);
                }
                return null;
            }
        });
    }

    @Override
    protected Collection<? extends Relationship> resolveAdditionalFetch() {
        return Arrays.asList(MemberCustomField.Relationships.GROUPS);
    }
}

