/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;
import org.springframework.util.CollectionUtils;

public class MemberCustomFieldServiceSecurity
extends BaseServiceSecurity
implements MemberCustomFieldService {
    private MemberCustomFieldServiceLocal memberCustomFieldService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.memberCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        for (Long customFieldId : customFieldIds) {
            this.checkVisible(this.load(customFieldId));
        }
        return this.memberCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.memberCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<MemberCustomField> list() {
        List<MemberCustomField> fields = this.memberCustomFieldService.list();
        Iterator iterator = fields.iterator();
        while (iterator.hasNext()) {
            MemberCustomField field = (MemberCustomField)iterator.next();
            if (this.isVisible(field)) continue;
            iterator.remove();
        }
        return fields;
    }

    @Override
    public List<MemberCustomField> listPossibleParentFields(MemberCustomField field) {
        this.checkVisible(field);
        return this.memberCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<MemberCustomField> load(Collection<Long> ids) {
        List<MemberCustomField> fields = this.memberCustomFieldService.load(ids);
        for (MemberCustomField field : fields) {
            this.checkVisible(field);
        }
        return fields;
    }

    @Override
    public MemberCustomField load(Long id) {
        MemberCustomField field = (MemberCustomField)this.memberCustomFieldService.load(id);
        this.checkVisible(field);
        return field;
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        CustomFieldPossibleValue possibleValue = this.memberCustomFieldService.loadPossibleValue(id);
        MemberCustomField field = (MemberCustomField)possibleValue.getField();
        this.checkVisible(field);
        return possibleValue;
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        List<CustomFieldPossibleValue> possibleValues = this.memberCustomFieldService.loadPossibleValues(ids);
        HashSet<MemberCustomField> fields = new HashSet<MemberCustomField>();
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            fields.add((MemberCustomField)possibleValue.getField());
        }
        for (MemberCustomField field : fields) {
            this.checkVisible(field);
        }
        return possibleValues;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.memberCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.memberCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.memberCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.memberCustomFieldService.save(possibleValue);
    }

    @Override
    public MemberCustomField save(MemberCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.memberCustomFieldService.save(field);
    }

    public void setMemberCustomFieldServiceLocal(MemberCustomFieldServiceLocal memberCustomFieldService) {
        this.memberCustomFieldService = memberCustomFieldService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.memberCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.memberCustomFieldService.validate(possibleValue);
    }

    @Override
    public void validate(MemberCustomField field) throws ValidationException {
        this.memberCustomFieldService.validate(field);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_MANAGE).check();
    }

    private void checkVisible(MemberCustomField field) {
        if (!this.isVisible(field)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isVisible(MemberCustomField field) {
        if (LoggedUser.isAdministrator() && this.permissionService.permission().admin(AdminSystemPermission.CUSTOM_FIELDS_VIEW).hasPermission()) {
            return true;
        }
        Collection<MemberGroup> visibleGroups = this.permissionService.getVisibleMemberGroups();
        field = this.fetchService.fetch(field, MemberCustomField.Relationships.GROUPS);
        return CollectionUtils.containsAny(field.getGroups(), visibleGroups);
    }
}

