/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.MemberRecordCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.groups.AdminGroup;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.members.records.MemberRecordType;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldService;
import nl.strohalm.cyclos.services.customization.MemberRecordCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class MemberRecordCustomFieldServiceSecurity
extends BaseServiceSecurity
implements MemberRecordCustomFieldService {
    private MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.memberRecordCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        for (Long customFieldId : customFieldIds) {
            this.checkVisible(this.load(customFieldId));
        }
        return this.memberRecordCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.memberRecordCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<MemberRecordCustomField> list(MemberRecordType recordType) {
        List<MemberRecordCustomField> fields = this.memberRecordCustomFieldService.list(recordType);
        Iterator<MemberRecordCustomField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            MemberRecordCustomField field = iterator.next();
            if (this.isVisible(field)) continue;
            iterator.remove();
        }
        return fields;
    }

    @Override
    public List<MemberRecordCustomField> listPossibleParentFields(MemberRecordCustomField field) {
        this.checkVisible(field);
        return this.memberRecordCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<MemberRecordCustomField> load(Collection<Long> ids) {
        List<MemberRecordCustomField> fields = this.memberRecordCustomFieldService.load(ids);
        for (MemberRecordCustomField field : fields) {
            this.checkVisible(field);
        }
        return fields;
    }

    @Override
    public MemberRecordCustomField load(Long id) {
        MemberRecordCustomField field = (MemberRecordCustomField)this.memberRecordCustomFieldService.load(id);
        this.checkVisible(field);
        return field;
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        CustomFieldPossibleValue possibleValue = this.memberRecordCustomFieldService.loadPossibleValue(id);
        this.checkVisible((MemberRecordCustomField)possibleValue.getField());
        return possibleValue;
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        List<CustomFieldPossibleValue> possibleValues = this.memberRecordCustomFieldService.loadPossibleValues(ids);
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            this.checkVisible((MemberRecordCustomField)possibleValue.getField());
        }
        return possibleValues;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.memberRecordCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.memberRecordCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.memberRecordCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.memberRecordCustomFieldService.save(possibleValue);
    }

    @Override
    public MemberRecordCustomField save(MemberRecordCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.memberRecordCustomFieldService.save(field);
    }

    public void setMemberRecordCustomFieldServiceLocal(MemberRecordCustomFieldServiceLocal memberRecordCustomFieldService) {
        this.memberRecordCustomFieldService = memberRecordCustomFieldService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.memberRecordCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.memberRecordCustomFieldService.validate(possibleValue);
    }

    @Override
    public void validate(MemberRecordCustomField field) throws ValidationException {
        this.memberRecordCustomFieldService.validate(field);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.MEMBER_RECORD_TYPES_MANAGE).check();
    }

    private void checkVisible(MemberRecordCustomField field) {
        if (!this.isVisible(field)) {
            throw new PermissionDeniedException();
        }
    }

    private boolean isVisible(MemberRecordCustomField field) {
        if (this.permissionService.hasPermission(AdminSystemPermission.MEMBER_RECORD_TYPES_VIEW)) {
            return true;
        }
        Object group = LoggedUser.group();
        Collection<Object> visibleRecordTypes = Collections.emptyList();
        if (group instanceof AdminGroup) {
            visibleRecordTypes = this.fetchService.fetch((AdminGroup)group, AdminGroup.Relationships.VIEW_MEMBER_RECORD_TYPES).getViewMemberRecordTypes();
        } else if (group instanceof BrokerGroup && field.getBrokerAccess() != MemberRecordCustomField.Access.NONE) {
            visibleRecordTypes = this.fetchService.fetch((BrokerGroup)group, BrokerGroup.Relationships.BROKER_MEMBER_RECORD_TYPES).getBrokerMemberRecordTypes();
        }
        return visibleRecordTypes.contains(field.getMemberRecordType());
    }
}

