/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.Operator;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldServiceImpl;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.validation.Validator;

public class OperatorCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<OperatorCustomField>
implements OperatorCustomFieldServiceLocal {
    protected OperatorCustomFieldServiceImpl() {
        super(OperatorCustomField.class);
    }

    @Override
    public Validator getValueValidator(Member member) {
        return this.getValueValidator(this.list(member));
    }

    @Override
    public List<OperatorCustomField> list(final Member member) {
        return (List)this.getCache().get((Serializable)((Object)("_FIELDS_BY_MEMBER_" + member.getId())), new CacheCallback(){

            @Override
            public Object retrieve() {
                return OperatorCustomFieldServiceImpl.this.customFieldDao.listOperatorFields(member);
            }
        });
    }

    @Override
    public void saveValues(Operator operator) {
        this.getValueValidator(operator.getMember()).validate(operator);
        this.doSaveValues(operator);
    }

    @Override
    protected List<OperatorCustomField> list(OperatorCustomField field) {
        return this.list(field.getMember());
    }

    @Override
    protected Collection<? extends Relationship> resolveAdditionalFetch() {
        return Arrays.asList(OperatorCustomField.Relationships.MEMBER);
    }
}

