/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.OperatorCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldService;
import nl.strohalm.cyclos.services.customization.OperatorCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class OperatorCustomFieldServiceSecurity
extends BaseServiceSecurity
implements OperatorCustomFieldService {
    private OperatorCustomFieldServiceLocal operatorCustomFieldService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView(this.load(customFieldId).getMember());
        return this.operatorCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        for (Long customFieldId : customFieldIds) {
            this.checkView(this.load(customFieldId).getMember());
        }
        return this.operatorCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkView(this.load(customFieldId).getMember());
        return this.operatorCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public List<OperatorCustomField> list(Member member) {
        this.checkView(member);
        return this.operatorCustomFieldService.list(member);
    }

    @Override
    public List<OperatorCustomField> listPossibleParentFields(OperatorCustomField field) {
        Member member = this.fetchService.fetch(field.getMember(), new Relationship[0]);
        this.checkView(member);
        return this.operatorCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<OperatorCustomField> load(Collection<Long> ids) {
        List<OperatorCustomField> fields = this.operatorCustomFieldService.load(ids);
        for (OperatorCustomField field : fields) {
            this.checkView(field.getMember());
        }
        return fields;
    }

    @Override
    public OperatorCustomField load(Long id) {
        OperatorCustomField field = (OperatorCustomField)this.operatorCustomFieldService.load(id);
        this.checkView(field.getMember());
        return field;
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        CustomFieldPossibleValue possibleValue = this.operatorCustomFieldService.loadPossibleValue(id);
        OperatorCustomField field = (OperatorCustomField)possibleValue.getField();
        this.checkView(field.getMember());
        return possibleValue;
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        List<CustomFieldPossibleValue> possibleValues = this.operatorCustomFieldService.loadPossibleValues(ids);
        HashSet<Member> members = new HashSet<Member>();
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            OperatorCustomField field = (OperatorCustomField)possibleValue.getField();
            members.add(field.getMember());
        }
        for (Member member : members) {
            this.checkView(member);
        }
        return possibleValues;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManageIds(Arrays.asList(ids));
        return this.operatorCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        HashSet<Member> members = new HashSet<Member>();
        List<CustomFieldPossibleValue> possibleValues = this.operatorCustomFieldService.loadPossibleValues(Arrays.asList(ids));
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            OperatorCustomField field = (OperatorCustomField)possibleValue.getField();
            members.add(field.getMember());
        }
        for (Member member : members) {
            this.checkManage(member);
        }
        return this.operatorCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        Relationship fetch = RelationshipHelper.nested(CustomFieldPossibleValue.Relationships.FIELD, OperatorCustomField.Relationships.MEMBER);
        oldValue = this.fetchService.fetch(oldValue, fetch);
        newValue = this.fetchService.fetch(newValue, fetch);
        HashSet<Member> members = new HashSet<Member>();
        members.add(((OperatorCustomField)oldValue.getField()).getMember());
        members.add(((OperatorCustomField)newValue.getField()).getMember());
        for (Member member : members) {
            this.checkManage(member);
        }
        return this.operatorCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        OperatorCustomField field = (OperatorCustomField)this.fetchService.fetch(possibleValue.getField(), OperatorCustomField.Relationships.MEMBER);
        this.checkManage(field.getMember());
        return this.operatorCustomFieldService.save(possibleValue);
    }

    @Override
    public OperatorCustomField save(OperatorCustomField field) throws ValidationException, DaoException {
        Member member = this.fetchService.fetch(field.getMember(), new Relationship[0]);
        this.checkManage(member);
        return this.operatorCustomFieldService.save(field);
    }

    public void setOperatorCustomFieldServiceLocal(OperatorCustomFieldServiceLocal operatorCustomFieldService) {
        this.operatorCustomFieldService = operatorCustomFieldService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManageIds(ids);
        this.operatorCustomFieldService.setOrder(ids);
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.operatorCustomFieldService.validate(possibleValue);
    }

    @Override
    public void validate(OperatorCustomField field) throws ValidationException {
        this.operatorCustomFieldService.validate(field);
    }

    private void checkManage(Member member) {
        this.permissionService.permission(member).member(MemberPermission.OPERATORS_MANAGE).check();
    }

    private void checkManageIds(List<Long> ids) {
        HashSet<Member> members = new HashSet<Member>();
        List fields = this.operatorCustomFieldService.load(ids);
        for (OperatorCustomField field : fields) {
            members.add(field.getMember());
        }
        for (Member member : members) {
            this.checkManage(member);
        }
    }

    private void checkView(Member member) {
        this.permissionService.permission(member).member(MemberPermission.OPERATORS_MANAGE).operator().check();
    }
}

