/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.guarantees.Guarantee;
import nl.strohalm.cyclos.entities.accounts.transactions.Invoice;
import nl.strohalm.cyclos.entities.accounts.transactions.Payment;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomFieldValue;
import nl.strohalm.cyclos.services.customization.BaseCustomFieldServiceImpl;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.services.transactions.InvoiceServiceLocal;
import nl.strohalm.cyclos.services.transactions.exceptions.SendingInvoiceWithMultipleTransferTypesWithCustomFields;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.validation.Validator;

public class PaymentCustomFieldServiceImpl
extends BaseCustomFieldServiceImpl<PaymentCustomField>
implements PaymentCustomFieldServiceLocal {
    private InvoiceServiceLocal invoiceService;

    protected PaymentCustomFieldServiceImpl() {
        super(PaymentCustomField.class);
    }

    @Override
    public Validator getValueValidator(TransferType transferType) {
        return this.getValueValidator(this.list(transferType, false));
    }

    @Override
    public void link(TransferType transferType, PaymentCustomField customField) {
        transferType = this.fetchService.fetch(transferType, TransferType.Relationships.LINKED_CUSTOM_FIELDS);
        customField = this.fetchService.fetch(customField, new Relationship[0]);
        Collection<PaymentCustomField> linkedCustomFields = transferType.getLinkedCustomFields();
        if (!linkedCustomFields.contains(customField)) {
            linkedCustomFields.add(customField);
        }
        this.getCache().clear();
    }

    @Override
    public List<PaymentCustomField> list(final TransferType transferType, final boolean includeDisabled) {
        return (List)this.getCache().get((Serializable)((Object)("_FIELDS_BY_TYPE_" + transferType.getId() + "_" + includeDisabled)), new CacheCallback(){

            @Override
            public Object retrieve() {
                return PaymentCustomFieldServiceImpl.this.customFieldDao.listPaymentFields(transferType, includeDisabled, PaymentCustomFieldServiceImpl.this.fetch);
            }
        });
    }

    @Override
    public List<PaymentCustomField> listForList(Account account, boolean loan) {
        return this.customFieldDao.listPaymentFieldForList(account, loan, this.fetch);
    }

    @Override
    public List<PaymentCustomField> listForSearch(Account account, boolean loan) {
        return this.customFieldDao.listPaymentFieldForSearch(account, loan, this.fetch);
    }

    @Override
    public PaymentCustomField loadByInternalName(String internalName, Relationship ... fetch) {
        return this.customFieldDao.loadPaymentFieldByInternalName(internalName, fetch);
    }

    @Override
    public void saveValues(Guarantee guarantee, boolean validate) {
        TransferType loanTransferType = guarantee.getGuaranteeType().getLoanTransferType();
        if (validate) {
            this.getValueValidator(loanTransferType).validate(guarantee);
        }
        this.doSaveValues(guarantee);
    }

    @Override
    public void saveValues(Invoice invoice) throws SendingInvoiceWithMultipleTransferTypesWithCustomFields {
        TransferType transferType = invoice.getTransferType();
        if (transferType == null) {
            List<TransferType> transferTypes = this.invoiceService.getPossibleTransferTypes(invoice);
            if (transferTypes.size() == 1) {
                transferType = transferTypes.iterator().next();
                invoice.setTransferType(transferType);
            } else {
                for (TransferType tt : transferTypes) {
                    if (tt.getCustomFields().isEmpty()) continue;
                    throw new SendingInvoiceWithMultipleTransferTypesWithCustomFields();
                }
                invoice.setCustomValues((Collection<PaymentCustomFieldValue>)null);
                return;
            }
        }
        this.getValueValidator(transferType).validate(invoice);
        this.doSaveValues(invoice);
    }

    @Override
    public void saveValues(Payment payment) {
        this.getValueValidator(payment.getType()).validate(payment);
        this.doSaveValues(payment);
    }

    public void setInvoiceServiceLocal(InvoiceServiceLocal invoiceService) {
        this.invoiceService = invoiceService;
    }

    @Override
    protected List<PaymentCustomField> list(PaymentCustomField field) {
        return this.list(field.getTransferType(), !field.isEnabled());
    }

    @Override
    protected Collection<? extends Relationship> resolveAdditionalFetch() {
        return Arrays.asList(PaymentCustomField.Relationships.TRANSFER_TYPE);
    }
}

