/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.Account;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.transactions.TransferType;
import nl.strohalm.cyclos.entities.customization.fields.CustomFieldPossibleValue;
import nl.strohalm.cyclos.entities.customization.fields.PaymentCustomField;
import nl.strohalm.cyclos.entities.exceptions.DaoException;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.accounts.AccountTypeServiceLocal;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldService;
import nl.strohalm.cyclos.services.customization.PaymentCustomFieldServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.webservices.model.FieldVO;
import nl.strohalm.cyclos.webservices.model.PossibleValueVO;

public class PaymentCustomFieldServiceSecurity
extends BaseServiceSecurity
implements PaymentCustomFieldService {
    private PaymentCustomFieldServiceLocal paymentCustomFieldService;
    private AccountTypeServiceLocal accountTypeService;

    @Override
    public FieldVO getFieldVO(Long customFieldId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.paymentCustomFieldService.getFieldVO(customFieldId);
    }

    @Override
    public List<FieldVO> getFieldVOs(List<Long> customFieldIds) {
        if (customFieldIds == null) {
            return null;
        }
        for (Long customFieldId : customFieldIds) {
            this.checkVisible(this.load(customFieldId));
        }
        return this.paymentCustomFieldService.getFieldVOs(customFieldIds);
    }

    @Override
    public List<PossibleValueVO> getPossibleValueVOs(Long customFieldId, Long possibleValueParentId) {
        if (customFieldId == null) {
            return null;
        }
        this.checkVisible(this.load(customFieldId));
        return this.paymentCustomFieldService.getPossibleValueVOs(customFieldId, possibleValueParentId);
    }

    @Override
    public void link(TransferType transferType, PaymentCustomField customField) {
        this.checkManage();
        this.paymentCustomFieldService.link(transferType, customField);
    }

    @Override
    public List<PaymentCustomField> list(TransferType transferType, boolean includeDisabled) {
        return this.filterVisible(this.paymentCustomFieldService.list(transferType, includeDisabled));
    }

    @Override
    public List<PaymentCustomField> listForList(Account account, boolean loan) {
        return this.filterVisible(this.paymentCustomFieldService.listForList(account, loan));
    }

    @Override
    public List<PaymentCustomField> listForSearch(Account account, boolean loan) {
        return this.filterVisible(this.paymentCustomFieldService.listForSearch(account, loan));
    }

    @Override
    public List<PaymentCustomField> listPossibleParentFields(PaymentCustomField field) {
        this.checkVisible(field);
        return this.paymentCustomFieldService.listPossibleParentFields(field);
    }

    @Override
    public List<PaymentCustomField> load(Collection<Long> ids) {
        List<PaymentCustomField> fields = this.paymentCustomFieldService.load(ids);
        for (PaymentCustomField field : fields) {
            this.checkVisible(field);
        }
        return fields;
    }

    @Override
    public PaymentCustomField load(Long id) {
        PaymentCustomField field = (PaymentCustomField)this.paymentCustomFieldService.load(id);
        this.checkVisible(field);
        return field;
    }

    @Override
    public PaymentCustomField loadByInternalName(String internalName, Relationship ... fetch) {
        PaymentCustomField field = this.paymentCustomFieldService.loadByInternalName(internalName, fetch);
        this.checkVisible(field);
        return field;
    }

    @Override
    public CustomFieldPossibleValue loadPossibleValue(Long id) {
        CustomFieldPossibleValue possibleValue = this.paymentCustomFieldService.loadPossibleValue(id);
        this.checkVisible((PaymentCustomField)possibleValue.getField());
        return possibleValue;
    }

    @Override
    public List<CustomFieldPossibleValue> loadPossibleValues(Collection<Long> ids) {
        List<CustomFieldPossibleValue> possibleValues = this.paymentCustomFieldService.loadPossibleValues(ids);
        for (CustomFieldPossibleValue possibleValue : possibleValues) {
            this.checkVisible((PaymentCustomField)possibleValue.getField());
        }
        return possibleValues;
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.paymentCustomFieldService.remove(ids);
    }

    @Override
    public int removePossibleValue(Long ... ids) {
        this.checkManage();
        return this.paymentCustomFieldService.removePossibleValue(ids);
    }

    @Override
    public int replacePossibleValues(CustomFieldPossibleValue oldValue, CustomFieldPossibleValue newValue) {
        this.checkManage();
        return this.paymentCustomFieldService.replacePossibleValues(oldValue, newValue);
    }

    @Override
    public CustomFieldPossibleValue save(CustomFieldPossibleValue possibleValue) throws ValidationException, DaoException {
        this.checkManage();
        return this.paymentCustomFieldService.save(possibleValue);
    }

    @Override
    public PaymentCustomField save(PaymentCustomField field) throws ValidationException, DaoException {
        this.checkManage();
        return this.paymentCustomFieldService.save(field);
    }

    public void setAccountTypeServiceLocal(AccountTypeServiceLocal accountTypeService) {
        this.accountTypeService = accountTypeService;
    }

    @Override
    public void setOrder(List<Long> ids) {
        this.checkManage();
        this.paymentCustomFieldService.setOrder(ids);
    }

    public void setPaymentCustomFieldServiceLocal(PaymentCustomFieldServiceLocal paymentCustomFieldService) {
        this.paymentCustomFieldService = paymentCustomFieldService;
    }

    @Override
    public void validate(CustomFieldPossibleValue possibleValue) throws ValidationException {
        this.paymentCustomFieldService.validate(possibleValue);
    }

    @Override
    public void validate(PaymentCustomField field) throws ValidationException {
        this.paymentCustomFieldService.validate(field);
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.ACCOUNTS_MANAGE).check();
    }

    private void checkVisible(PaymentCustomField field) {
        if (!this.isVisible(field)) {
            throw new PermissionDeniedException();
        }
    }

    private List<PaymentCustomField> filterVisible(List<PaymentCustomField> fields) {
        Iterator<PaymentCustomField> iterator = fields.iterator();
        while (iterator.hasNext()) {
            PaymentCustomField field = iterator.next();
            if (this.isVisible(field)) continue;
            iterator.remove();
        }
        return fields;
    }

    private boolean isVisible(PaymentCustomField field) {
        if (this.permissionService.hasPermission(AdminSystemPermission.ACCOUNTS_VIEW)) {
            return true;
        }
        field = this.fetchService.fetch(field, PaymentCustomField.Relationships.TRANSFER_TYPE, PaymentCustomField.Relationships.LINKED_TRANSFER_TYPES);
        Collection<AccountType> visibleAccountTypes = this.accountTypeService.getVisibleAccountTypes();
        HashSet<TransferType> transferTypes = new HashSet<TransferType>();
        transferTypes.add(field.getTransferType());
        transferTypes.addAll(field.getLinkedTransferTypes());
        for (TransferType transferType : transferTypes) {
            if (!visibleAccountTypes.contains(transferType.getFrom()) && !visibleAccountTypes.contains(transferType.getTo())) continue;
            return true;
        }
        return false;
    }
}

