/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import nl.strohalm.cyclos.dao.customizations.TranslationMessageDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessage;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessageQuery;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.customization.MessageImportType;
import nl.strohalm.cyclos.services.customization.TranslationChangeListener;
import nl.strohalm.cyclos.services.customization.TranslationMessageServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.TransactionHelper;
import nl.strohalm.cyclos.utils.cache.Cache;
import nl.strohalm.cyclos.utils.cache.CacheAdapter;
import nl.strohalm.cyclos.utils.cache.CacheCallback;
import nl.strohalm.cyclos.utils.cache.CacheManager;
import nl.strohalm.cyclos.utils.conversion.LocaleConverter;
import nl.strohalm.cyclos.utils.transaction.CurrentTransactionData;
import nl.strohalm.cyclos.utils.transaction.TransactionCommitListener;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;

public class TranslationMessageServiceImpl
implements TranslationMessageServiceLocal,
InitializingBean,
InitializingService {
    private static final String PROPERTIES_KEY = "_PROPERTIES";
    private TranslationMessageDAO translationMessageDao;
    private FetchServiceLocal fetchService;
    private CacheManager cacheManager;
    private SettingsServiceLocal settingsService;
    private TransactionHelper transactionHelper;
    private final List<TranslationChangeListener> listeners = new ArrayList<TranslationChangeListener>();

    @Override
    public void addTranslationChangeListener(TranslationChangeListener listener) {
        this.listeners.add(listener);
    }

    public void afterPropertiesSet() throws Exception {
        this.getCache().addListener(new CacheAdapter(){

            @Override
            public void onCacheCleared(Cache cache) {
                TranslationMessageServiceImpl.this.transactionHelper.runInCurrentThread(new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        TranslationMessageServiceImpl.this.notifyListeners(TranslationMessageServiceImpl.this.exportAsProperties());
                    }
                });
            }
        });
    }

    @Override
    public synchronized Properties exportAsProperties() {
        return (Properties)this.getCache().get((Serializable)((Object)PROPERTIES_KEY), new CacheCallback(){

            @Override
            public Object retrieve() {
                return TranslationMessageServiceImpl.this.translationMessageDao.listAsProperties();
            }
        });
    }

    @Override
    public void importFromProperties(Properties properties, MessageImportType importType) {
        if (importType == MessageImportType.REPLACE) {
            this.translationMessageDao.deleteAll();
            importType = MessageImportType.ONLY_NEW;
        }
        if (importType == MessageImportType.ONLY_NEW) {
            this.importOnlyNewProperties(properties);
        } else {
            boolean emptyOnly = importType == MessageImportType.NEW_AND_EMPTY;
            this.importNewAndModifiedProperties(properties, emptyOnly);
        }
        this.clearCacheOnCommit();
    }

    @Override
    public void initializeService() {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        Properties properties = this.readFile(localSettings.getLocale());
        this.importFromProperties(properties, MessageImportType.NEW_AND_EMPTY);
    }

    @Override
    public TranslationMessage load(Long id) {
        return (TranslationMessage)this.translationMessageDao.load(id, new Relationship[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties readFile(Locale locale) {
        String language = LocaleConverter.instance().toString(locale);
        String propertiesName = "ApplicationResources_" + language + ".properties";
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("/" + propertiesName);
        Properties properties = new Properties();
        try {
            InputStreamReader reader = new InputStreamReader(in, "UTF-8");
            properties.load(reader);
        }
        catch (Exception e) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return properties;
    }

    @Override
    public int remove(Long ... ids) {
        int count = this.translationMessageDao.delete(ids);
        this.clearCacheOnCommit();
        return count;
    }

    @Override
    public TranslationMessage save(TranslationMessage translationMessage) {
        this.validate(translationMessage);
        translationMessage = translationMessage.isTransient() ? this.translationMessageDao.insert(translationMessage) : this.translationMessageDao.update(translationMessage);
        this.clearCacheOnCommit();
        return translationMessage;
    }

    @Override
    public List<TranslationMessage> search(TranslationMessageQuery query) {
        return this.translationMessageDao.search(query);
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionHelper(TransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setTranslationMessageDao(TranslationMessageDAO translationMessageDao) {
        this.translationMessageDao = translationMessageDao;
    }

    @Override
    public void validate(TranslationMessage translationMessage) {
        this.getValidator().validate(translationMessage);
    }

    private void clearCacheOnCommit() {
        CurrentTransactionData.addTransactionCommitListener(new TransactionCommitListener(){

            @Override
            public void onTransactionCommit() {
                TranslationMessageServiceImpl.this.getCache().clear();
            }
        });
    }

    private Cache getCache() {
        return this.cacheManager.getCache("cyclos.TranslationMessages");
    }

    private Validator getValidator() {
        Validator validator = new Validator();
        validator.property("key").required().maxLength(100);
        validator.property("value").maxLength(4000);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importNewAndModifiedProperties(Properties properties, boolean emptyOnly) {
        Iterator<Object[]> existing = this.translationMessageDao.listData();
        try {
            while (existing.hasNext()) {
                boolean shallUpdate;
                Object[] data = existing.next();
                String key = (String)data[1];
                String currentValue = (String)data[2];
                String newValue = properties.getProperty(key);
                if (newValue == null) continue;
                boolean bl = shallUpdate = !newValue.equals(currentValue) && (!emptyOnly || StringUtils.isEmpty((String)currentValue));
                if (shallUpdate) {
                    TranslationMessage message = new TranslationMessage();
                    message.setId((Long)data[0]);
                    message.setKey(key);
                    message.setValue(newValue);
                    this.translationMessageDao.update(message, false);
                }
                properties.remove(key);
            }
        }
        finally {
            DataIteratorHelper.close(existing);
        }
        this.fetchService.clearCache();
        this.insertAll(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importOnlyNewProperties(Properties properties) {
        Iterator<String> allKeys = this.translationMessageDao.listAllKeys();
        try {
            while (allKeys.hasNext()) {
                String key = allKeys.next();
                properties.remove(key);
            }
        }
        finally {
            DataIteratorHelper.close(allKeys);
        }
        this.insertAll(properties);
    }

    private void insertAll(Properties properties) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            TranslationMessage translationMessage = new TranslationMessage();
            translationMessage.setKey(key);
            translationMessage.setValue(value);
            try {
                TranslationMessage existing = this.translationMessageDao.load(key);
                existing.setValue(value);
                this.translationMessageDao.update(existing, false);
            }
            catch (EntityNotFoundException e) {
                this.translationMessageDao.insert(translationMessage);
            }
            cacheCleaner.clearCache();
        }
    }

    private void notifyListeners(Properties properties) {
        for (TranslationChangeListener listener : this.listeners) {
            listener.onTranslationsChanged(properties);
        }
    }
}

