/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.customization;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import nl.strohalm.cyclos.access.AdminSystemPermission;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessage;
import nl.strohalm.cyclos.entities.customization.translationMessages.TranslationMessageQuery;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.customization.MessageImportType;
import nl.strohalm.cyclos.services.customization.TranslationChangeListener;
import nl.strohalm.cyclos.services.customization.TranslationMessageService;
import nl.strohalm.cyclos.services.customization.TranslationMessageServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class TranslationMessageServiceSecurity
extends BaseServiceSecurity
implements TranslationMessageService {
    private TranslationMessageServiceLocal translationMessageService;

    @Override
    public void addTranslationChangeListener(TranslationChangeListener listener) {
        this.translationMessageService.addTranslationChangeListener(listener);
    }

    @Override
    public Properties exportAsProperties() {
        this.checkFilePermission();
        return this.translationMessageService.exportAsProperties();
    }

    @Override
    public void importFromProperties(Properties properties, MessageImportType importType) {
        this.checkFilePermission();
        this.translationMessageService.importFromProperties(properties, importType);
    }

    @Override
    public TranslationMessage load(Long id) {
        this.checkView();
        return this.translationMessageService.load(id);
    }

    @Override
    public Properties readFile(Locale locale) {
        return this.translationMessageService.readFile(locale);
    }

    @Override
    public int remove(Long ... ids) {
        this.checkManage();
        return this.translationMessageService.remove(ids);
    }

    @Override
    public TranslationMessage save(TranslationMessage translationMessage) {
        this.checkManage();
        return this.translationMessageService.save(translationMessage);
    }

    @Override
    public List<TranslationMessage> search(TranslationMessageQuery query) {
        this.checkView();
        return this.translationMessageService.search(query);
    }

    public void setTranslationMessageServiceLocal(TranslationMessageServiceLocal translationMessageService) {
        this.translationMessageService = translationMessageService;
    }

    @Override
    public void validate(TranslationMessage translationMessage) throws ValidationException {
        this.translationMessageService.validate(translationMessage);
    }

    private void checkFilePermission() {
        this.permissionService.permission().admin(AdminSystemPermission.TRANSLATION_FILE).check();
    }

    private void checkManage() {
        this.permissionService.permission().admin(AdminSystemPermission.TRANSLATION_MANAGE).check();
    }

    private void checkView() {
        this.permissionService.permission().admin(AdminSystemPermission.TRANSLATION_VIEW).check();
    }
}

