/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map;
import nl.strohalm.cyclos.entities.ads.Ad;
import nl.strohalm.cyclos.entities.members.Reference;
import nl.strohalm.cyclos.services.elements.AccountActivitiesVO;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.utils.DataObject;

public class ActivitiesVO
extends DataObject {
    private static final long serialVersionUID = -347229469387541880L;
    private Map<String, AccountActivitiesVO> accountActivities;
    private TransactionSummaryVO incomingInvoices;
    private TransactionSummaryVO outgoingInvoices;
    private int numberBrokeredMembers;
    private Calendar sinceActive;
    private Map<Reference.Level, Integer> givenReferencesByLevel;
    private Map<Reference.Level, Integer> receivedReferencesByLevel;
    private Map<Ad.Status, Integer> adsByStatus;
    private boolean showAccountInformation;
    private boolean showAdsInformation;
    private boolean showNonActiveAdsInformation;
    private boolean showReferencesInformation;
    private boolean showInvoicesInformation;

    public void addAccountActivities(String account, AccountActivitiesVO vo) {
        if (this.accountActivities == null) {
            this.accountActivities = new LinkedHashMap<String, AccountActivitiesVO>();
        }
        this.accountActivities.put(account, vo);
    }

    public Map<String, AccountActivitiesVO> getAccountActivities() {
        return this.accountActivities;
    }

    public Map<Ad.Status, Integer> getAdsByStatus() {
        return this.adsByStatus;
    }

    public Map<Reference.Level, Integer> getGivenReferencesByLevel() {
        return this.givenReferencesByLevel;
    }

    public TransactionSummaryVO getIncomingInvoices() {
        if (this.incomingInvoices == null) {
            this.incomingInvoices = new TransactionSummaryVO();
        }
        return this.incomingInvoices;
    }

    public int getNumberBrokeredMembers() {
        return this.numberBrokeredMembers;
    }

    public TransactionSummaryVO getOutgoingInvoices() {
        if (this.outgoingInvoices == null) {
            this.outgoingInvoices = new TransactionSummaryVO();
        }
        return this.outgoingInvoices;
    }

    public Map<Reference.Level, Integer> getReceivedReferencesByLevel() {
        return this.receivedReferencesByLevel;
    }

    public Calendar getSinceActive() {
        return this.sinceActive;
    }

    public boolean isShowAccountInformation() {
        return this.showAccountInformation;
    }

    public boolean isShowAdsInformation() {
        return this.showAdsInformation;
    }

    public boolean isShowInvoicesInformation() {
        return this.showInvoicesInformation;
    }

    public boolean isShowNonActiveAdsInformation() {
        return this.showNonActiveAdsInformation;
    }

    public boolean isShowReferencesInformation() {
        return this.showReferencesInformation;
    }

    public boolean isSingleAccount() {
        return this.accountActivities == null ? false : this.accountActivities.size() == 1;
    }

    public void setAccountActivities(Map<String, AccountActivitiesVO> accountActivities) {
        this.accountActivities = accountActivities;
    }

    public void setAdsByStatus(Map<Ad.Status, Integer> adsByStatus) {
        this.adsByStatus = adsByStatus;
    }

    public void setGivenReferencesByLevel(Map<Reference.Level, Integer> givenReferencesByLevel) {
        this.givenReferencesByLevel = givenReferencesByLevel;
    }

    public void setIncomingInvoices(TransactionSummaryVO incomingInvoices) {
        this.incomingInvoices = incomingInvoices;
    }

    public void setNumberBrokeredMembers(int numberBrokeredMembers) {
        this.numberBrokeredMembers = numberBrokeredMembers;
    }

    public void setOutgoingInvoices(TransactionSummaryVO invoices) {
        this.outgoingInvoices = invoices;
    }

    public void setReceivedReferencesByLevel(Map<Reference.Level, Integer> receivedReferencesByLevel) {
        this.receivedReferencesByLevel = receivedReferencesByLevel;
    }

    public void setShowAccountInformation(boolean showAccountInformation) {
        this.showAccountInformation = showAccountInformation;
    }

    public void setShowAdsInformation(boolean showAdsInformation) {
        this.showAdsInformation = showAdsInformation;
    }

    public void setShowInvoicesInformation(boolean showInvoicesInformation) {
        this.showInvoicesInformation = showInvoicesInformation;
    }

    public void setShowNonActiveAdsInformation(boolean showNonActiveAdsInformation) {
        this.showNonActiveAdsInformation = showNonActiveAdsInformation;
    }

    public void setShowReferencesInformation(boolean showReferencesInformation) {
        this.showReferencesInformation = showReferencesInformation;
    }

    public void setSinceActive(Calendar sinceActive) {
        if (sinceActive != null) {
            this.sinceActive = sinceActive;
        }
    }
}

