/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.dao.members.AdInterestDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterest;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterestQuery;
import nl.strohalm.cyclos.services.elements.AdInterestServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;

public class AdInterestServiceImpl
implements AdInterestServiceLocal {
    private AdInterestDAO adInterestDao;

    @Override
    public AdInterest load(Long id, Relationship ... fetch) {
        return (AdInterest)this.adInterestDao.load(id, fetch);
    }

    @Override
    public int remove(Long[] ids) {
        return this.adInterestDao.delete(ids);
    }

    @Override
    public AdInterest save(AdInterest adInterest) {
        if (adInterest.getInitialPrice() == null && adInterest.getFinalPrice() == null) {
            adInterest.setCurrency(null);
        }
        this.validate(adInterest);
        adInterest = adInterest.isTransient() ? this.adInterestDao.insert(adInterest) : this.adInterestDao.update(adInterest);
        return adInterest;
    }

    @Override
    public List<AdInterest> search(AdInterestQuery query) {
        return this.adInterestDao.search(query);
    }

    public void setAdInterestDao(AdInterestDAO adInterestDao) {
        this.adInterestDao = adInterestDao;
    }

    @Override
    public void validate(AdInterest adInterest) throws ValidationException {
        this.getValidator().validate(adInterest);
    }

    private Validator getValidator() {
        Validator validator = new Validator("adInterest");
        validator.property("title").required().maxLength(100);
        validator.property("type").required();
        validator.property("initialPrice").key("adInterest.priceRange").positive();
        validator.property("finalPrice").key("adInterest.priceRange").positiveNonZero();
        return validator;
    }
}

