/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterest;
import nl.strohalm.cyclos.entities.members.adInterests.AdInterestQuery;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.AdInterestService;
import nl.strohalm.cyclos.services.elements.AdInterestServiceLocal;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class AdInterestServiceSecurity
extends BaseServiceSecurity
implements AdInterestService {
    private AdInterestServiceLocal adInterestService;

    @Override
    public AdInterest load(Long id, Relationship ... fetch) {
        AdInterest adInterest = this.checkManages(id, fetch);
        return adInterest;
    }

    @Override
    public int remove(Long[] ids) {
        for (Long id : ids) {
            this.checkManages(id, new Relationship[0]);
        }
        return this.adInterestService.remove(ids);
    }

    @Override
    public AdInterest save(AdInterest adInterest) {
        this.checkManages(adInterest.getOwner());
        return this.adInterestService.save(adInterest);
    }

    @Override
    public List<AdInterest> search(AdInterestQuery query) {
        this.checkManages(query.getOwner());
        return this.adInterestService.search(query);
    }

    public void setAdInterestServiceLocal(AdInterestServiceLocal adInterestService) {
        this.adInterestService = adInterestService;
    }

    @Override
    public void validate(AdInterest adInterest) throws ValidationException {
        this.adInterestService.validate(adInterest);
    }

    private AdInterest checkManages(Long id, Relationship ... fetch) {
        AdInterest adInterest = this.adInterestService.load(id, fetch);
        this.checkManages(adInterest.getOwner());
        return adInterest;
    }

    private void checkManages(Member member) {
        if (member == null) {
            throw new PermissionDeniedException();
        }
        this.permissionService.permission(member).member(MemberPermission.PREFERENCES_MANAGE_AD_INTERESTS).check();
    }
}

