/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Calendar;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import nl.strohalm.cyclos.dao.members.ElementDAO;
import nl.strohalm.cyclos.dao.members.RemarkDAO;
import nl.strohalm.cyclos.dao.members.brokerings.BrokerCommissionContractDAO;
import nl.strohalm.cyclos.dao.members.brokerings.BrokeringCommissionStatusDAO;
import nl.strohalm.cyclos.dao.members.brokerings.BrokeringDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.exceptions.UnexpectedEntityException;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatus;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatusQuery;
import nl.strohalm.cyclos.entities.members.remarks.BrokerRemark;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.ChangeBrokerDTO;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.elements.ElementServiceLocal;
import nl.strohalm.cyclos.services.elements.exceptions.MemberAlreadyInBrokeringsException;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeServiceLocal;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.RequiredError;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class BrokeringServiceImpl
implements BrokeringServiceLocal,
InitializingService {
    private BrokerCommissionContractDAO brokerCommissionContractDao;
    private BrokeringCommissionStatusDAO brokeringCommissionStatusDao;
    private BrokeringDAO brokeringDao;
    private CommissionServiceLocal commissionService;
    private ElementServiceLocal elementService;
    private ElementDAO elementDao;
    private FetchServiceLocal fetchService;
    private RemarkDAO remarkDao;
    private SettingsServiceLocal settingsService;
    private TransactionFeeServiceLocal transactionFeeService;
    private MemberNotificationHandler memberNotificationHandler;

    @Override
    public BulkMemberActionResultVO bulkChangeMemberBroker(FullTextMemberQuery query, Member newBroker, boolean suspendCommission, String comments) {
        if (newBroker == null || newBroker.isTransient()) {
            throw new ValidationException();
        }
        if (StringUtils.isEmpty((String)comments)) {
            throw new ValidationException();
        }
        newBroker = this.fetchService.fetch(newBroker, new Relationship[0]);
        int changed = 0;
        int unchanged = 0;
        query.setIterateAll();
        List<? extends Element> members = this.elementService.fullTextSearch(query);
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        for (Member member : members) {
            if (newBroker.equals(member.getBroker())) {
                ++unchanged;
                continue;
            }
            ChangeBrokerDTO dto = new ChangeBrokerDTO();
            dto.setMember(member);
            dto.setNewBroker(newBroker);
            dto.setSuspendCommission(suspendCommission);
            dto.setComments(comments);
            this.changeBroker(dto);
            ++changed;
            cacheCleaner.clearCache();
        }
        return new BulkMemberActionResultVO(changed, unchanged);
    }

    @Override
    public Brokering changeBroker(ChangeBrokerDTO dto) {
        this.memberNotificationHandler.removedBrokeringNotification(dto);
        return this.doChangeBroker(dto);
    }

    @Override
    public Brokering create(Member broker, Member brokered) {
        Brokering brokering = new Brokering();
        brokering.setBroker(broker);
        brokering.setBrokered(brokered);
        brokering.setStartDate(Calendar.getInstance());
        brokering = this.brokeringDao.insert(brokering);
        this.createBrokeringCommissionStatus(brokering);
        return brokering;
    }

    @Override
    public Brokering getActiveBrokering(Member member) {
        if ((member = this.fetchService.fetch(member, Member.Relationships.BROKER)).getBroker() == null) {
            return null;
        }
        BrokeringQuery query = new BrokeringQuery();
        query.fetch(Brokering.Relationships.BROKER);
        query.setBroker(member.getBroker());
        query.setBrokered(member);
        query.setStatus(BrokeringQuery.Status.ACTIVE);
        query.setUniqueResult();
        List<Brokering> list = this.search(query);
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public Brokering getBrokering(Member broker, Member member) throws ValidationException {
        BrokeringQuery brokeringQuery = new BrokeringQuery();
        brokeringQuery.setBroker(broker);
        brokeringQuery.setBrokered(member);
        brokeringQuery.setStatus(BrokeringQuery.Status.ACTIVE);
        List<Brokering> brokerings = this.search(brokeringQuery);
        if (CollectionUtils.isEmpty(brokerings)) {
            throw new ValidationException();
        }
        Brokering brokering = brokerings.iterator().next();
        return brokering;
    }

    public ElementDAO getElementDao() {
        return this.elementDao;
    }

    @Override
    public void initializeService() {
        this.removeExpiredBrokerings(Calendar.getInstance());
    }

    @Override
    public Collection<BrokeringQuery.Status> listPossibleStatuses(BrokerGroup brokerGroup) {
        brokerGroup = this.fetchService.fetch(brokerGroup, BrokerGroup.Relationships.POSSIBLE_INITIAL_GROUPS);
        boolean hasInactive = false;
        Collection<MemberGroup> possibleInitialGroups = brokerGroup.getPossibleInitialGroups();
        for (MemberGroup group : possibleInitialGroups) {
            if (group.isActive()) continue;
            hasInactive = true;
            break;
        }
        return hasInactive ? EnumSet.allOf(BrokeringQuery.Status.class) : EnumSet.complementOf(EnumSet.of(BrokeringQuery.Status.PENDING));
    }

    @Override
    public Brokering load(Long id, Relationship ... fetch) {
        return (Brokering)this.brokeringDao.load(id, fetch);
    }

    @Override
    public Brokering remove(Brokering brokering, String remark) throws UnexpectedEntityException {
        if (brokering == null || brokering.isTransient() || brokering.getEndDate() != null) {
            throw new UnexpectedEntityException();
        }
        ChangeBrokerDTO dto = new ChangeBrokerDTO();
        dto.setComments(remark);
        dto.setMember(brokering.getBrokered());
        dto.setNewBroker(null);
        return this.doChangeBroker(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExpiredBrokerings(Calendar time) {
        LocalSettings localSettings = this.settingsService.getLocalSettings();
        TimePeriod brokeringExpirationPeriod = localSettings.getBrokeringExpirationPeriod();
        if (brokeringExpirationPeriod == null || brokeringExpirationPeriod.getNumber() <= 0) {
            return;
        }
        Calendar startDate = brokeringExpirationPeriod.remove(DateHelper.truncate(time));
        BrokeringQuery query = new BrokeringQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setStatus(BrokeringQuery.Status.ACTIVE);
        query.setStartExpirationDate(startDate);
        CacheCleaner cleaner = new CacheCleaner(this.fetchService);
        List<Brokering> expired = this.search(query);
        try {
            for (Brokering brokering : expired) {
                brokering.setEndDate(time);
                this.brokeringDao.update(brokering);
                this.memberNotificationHandler.expiredBrokeringNotification(brokering);
                cleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(expired);
        }
    }

    @Override
    public List<Brokering> search(BrokeringQuery query) {
        return this.brokeringDao.search(query);
    }

    public void setBrokerCommissionContractDao(BrokerCommissionContractDAO brokerCommissionContractDao) {
        this.brokerCommissionContractDao = brokerCommissionContractDao;
    }

    public void setBrokeringCommissionStatusDao(BrokeringCommissionStatusDAO brokeringCommissionStatusDao) {
        this.brokeringCommissionStatusDao = brokeringCommissionStatusDao;
    }

    public void setBrokeringDao(BrokeringDAO brokeringDAO) {
        this.brokeringDao = brokeringDAO;
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    public void setElementDao(ElementDAO elementDao) {
        this.elementDao = elementDao;
    }

    public void setElementServiceLocal(ElementServiceLocal elementService) {
        this.elementService = elementService;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setRemarkDao(RemarkDAO remarkDao) {
        this.remarkDao = remarkDao;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionFeeServiceLocal(TransactionFeeServiceLocal transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    @Override
    public void validate(Brokering brokering) throws ValidationException {
        this.getBrokeringValidator().validate(brokering);
    }

    @Override
    public void validate(ChangeBrokerDTO dto) throws ValidationException {
        this.getDtoValidator().validate(dto);
    }

    private void closeBrokerContractsAndBrokeringStatus(Brokering brokering) {
        BrokerCommissionContractQuery bccQuery = new BrokerCommissionContractQuery();
        bccQuery.setBroker(brokering.getBroker());
        bccQuery.setMember(brokering.getBrokered());
        bccQuery.setStatus(BrokerCommissionContract.Status.ACTIVE);
        List<BrokerCommissionContract> brokerCommissionContracts = this.brokerCommissionContractDao.search(bccQuery);
        for (BrokerCommissionContract brokerCommissionContract : brokerCommissionContracts) {
            brokerCommissionContract.setStatus(BrokerCommissionContract.Status.CLOSED);
            this.brokerCommissionContractDao.update(brokerCommissionContract);
        }
        Calendar now = Calendar.getInstance();
        BrokeringCommissionStatusQuery bcsQuery = new BrokeringCommissionStatusQuery();
        bcsQuery.setBrokering(brokering);
        bcsQuery.setOnlyActive(true);
        List<BrokeringCommissionStatus> brokeringCommissionStatusList = this.brokeringCommissionStatusDao.search(bcsQuery);
        for (BrokeringCommissionStatus brokeringCommissionStatus : brokeringCommissionStatusList) {
            brokeringCommissionStatus.getPeriod().setEnd(now);
            this.brokeringCommissionStatusDao.update(brokeringCommissionStatus);
        }
    }

    private void createBrokeringCommissionStatus(Brokering brokering) {
        Member broker = this.fetchService.fetch(brokering.getBroker(), Element.Relationships.GROUP);
        BrokerGroup brokerGroup = (BrokerGroup)broker.getGroup();
        TransactionFeeQuery query = new TransactionFeeQuery();
        query.setEntityType(BrokerCommission.class);
        query.setBrokerGroup(brokerGroup);
        query.setReturnDisabled(true);
        List<? extends TransactionFee> brokerCommissions = this.transactionFeeService.search(query);
        for (BrokerCommission brokerCommission : brokerCommissions) {
            this.commissionService.createBrokeringCommissionStatus(brokering, brokerCommission);
        }
    }

    private Brokering doChangeBroker(ChangeBrokerDTO dto) {
        Brokering brokering;
        boolean justSuspendCommission;
        this.validate(dto);
        Calendar now = Calendar.getInstance();
        Member member = this.fetchService.reload(dto.getMember(), Element.Relationships.USER);
        Brokering oldBrokering = this.getActiveBrokering(member);
        Member oldBroker = oldBrokering == null ? null : oldBrokering.getBroker();
        Member newBroker = this.fetchService.fetch(dto.getNewBroker(), Member.Relationships.BROKER);
        boolean bl = justSuspendCommission = oldBroker != null && oldBroker.equals(newBroker) && dto.isSuspendCommission();
        if (!justSuspendCommission) {
            if (member.equals(newBroker)) {
                throw new ValidationException("brokering.error.circularBrokering", new Object[0]);
            }
            Member current = newBroker;
            HashSet<Member> visited = new HashSet<Member>();
            while (current != null) {
                if (visited.contains(current)) {
                    throw new ValidationException("brokering.error.circularBrokering", new Object[0]);
                }
                visited.add(current);
                current = this.fetchService.fetch(current, Member.Relationships.BROKER).getBroker();
            }
            if (newBroker != null) {
                BrokeringQuery query = new BrokeringQuery();
                query.setBroker(newBroker);
                query.setBrokered(member);
                query.setStatus(BrokeringQuery.Status.ACTIVE);
                if (!this.search(query).isEmpty()) {
                    throw new MemberAlreadyInBrokeringsException();
                }
            }
            member.setBroker(newBroker);
            this.elementDao.update(member, false);
            this.elementDao.addToIndex(member);
        }
        if (oldBrokering != null) {
            if (!justSuspendCommission) {
                oldBrokering.setEndDate(now);
            }
            this.brokeringDao.update(oldBrokering, false);
            this.closeBrokerContractsAndBrokeringStatus(oldBrokering);
        }
        if (justSuspendCommission) {
            brokering = oldBrokering;
        } else if (newBroker != null) {
            brokering = new Brokering();
            brokering.setBroker(newBroker);
            brokering.setBrokered(member);
            brokering.setStartDate(now);
            brokering = this.brokeringDao.insert(brokering, false);
            this.createBrokeringCommissionStatus(brokering);
        } else {
            brokering = null;
        }
        BrokerRemark remark = new BrokerRemark();
        remark.setWriter((Element)LoggedUser.element());
        remark.setSubject(member);
        remark.setDate(now);
        remark.setComments(dto.getComments());
        remark.setOldBroker(oldBroker);
        remark.setNewBroker(newBroker);
        remark.setSuspendCommission(dto.isSuspendCommission());
        this.remarkDao.insert(remark);
        return brokering;
    }

    private Validator getBrokeringValidator() {
        Validator brokeringValidator = new Validator();
        brokeringValidator.property("broker").key("member.broker").required().add(new BrokerValidation());
        brokeringValidator.property("brokered").key("member.member").required();
        brokeringValidator.property("notes").key("brokering.notes").maxLength(1000);
        return brokeringValidator;
    }

    private Validator getDtoValidator() {
        Validator dtoValidator = new Validator();
        dtoValidator.property("member").required();
        dtoValidator.property("newBroker").key("changeBroker.new").add(new BrokerValidation()).add(new PropertyValidation(){
            private static final long serialVersionUID = 580603314020373024L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                ChangeBrokerDTO dto = (ChangeBrokerDTO)object;
                Member newBroker = (Member)value;
                if (dto.isSuspendCommission()) {
                    if (newBroker == null || newBroker.isTransient()) {
                        return new RequiredError(new Object[0]);
                    }
                } else {
                    Member member = BrokeringServiceImpl.this.fetchService.fetch(dto.getMember(), new Relationship[0]);
                    if (member != null && newBroker != null && newBroker.equals(member.getBroker())) {
                        return new InvalidError();
                    }
                }
                return null;
            }
        });
        dtoValidator.property("comments").key("remark.comments").required().maxLength(4000);
        return dtoValidator;
    }

    public final class BrokerValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 580603314020373024L;

        @Override
        public ValidationError validate(Object object, Object name, Object value) {
            ChangeBrokerDTO dto = (ChangeBrokerDTO)object;
            Member member = BrokeringServiceImpl.this.fetchService.fetch((Member)value, Element.Relationships.GROUP);
            if (value == null) {
                return null;
            }
            if (member != null && !member.getMemberGroup().isBroker()) {
                return new InvalidError();
            }
            MemberGroup viewerGroup = (MemberGroup)member.getGroup();
            Member brokeredMember = BrokeringServiceImpl.this.fetchService.fetch(dto.getMember(), new Relationship[0]);
            if (!viewerGroup.getCanViewProfileOfGroups().contains(brokeredMember.getGroup())) {
                throw new ValidationException();
            }
            return null;
        }
    }
}

