/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.FullTextMemberQuery;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.BrokeringService;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.BulkMemberActionResultVO;
import nl.strohalm.cyclos.services.elements.ChangeBrokerDTO;
import nl.strohalm.cyclos.services.elements.exceptions.CircularBrokeringException;
import nl.strohalm.cyclos.services.elements.exceptions.MemberAlreadyInBrokeringsException;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class BrokeringServiceSecurity
extends BaseServiceSecurity
implements BrokeringService {
    private BrokeringServiceLocal brokeringService;

    @Override
    public BulkMemberActionResultVO bulkChangeMemberBroker(FullTextMemberQuery query, Member newBroker, boolean suspendCommission, String comments) {
        this.permissionService.permission(newBroker).admin(AdminMemberPermission.BULK_ACTIONS_CHANGE_BROKER).check();
        Collection<? extends Group> queryGroups = query.getGroups();
        queryGroups = this.fetchService.fetch(queryGroups, new Relationship[0]);
        Collection<? extends Group> allowedGroups = PermissionHelper.checkSelection(this.permissionService.getManagedMemberGroups(), queryGroups);
        Iterator<? extends Group> it = allowedGroups.iterator();
        while (it.hasNext()) {
            if (!((MemberGroup)it.next()).isRemoved()) continue;
            it.remove();
        }
        query.setGroups(allowedGroups);
        return this.brokeringService.bulkChangeMemberBroker(query, newBroker, suspendCommission, comments);
    }

    @Override
    public Brokering changeBroker(ChangeBrokerDTO dto) throws MemberAlreadyInBrokeringsException, CircularBrokeringException {
        if (dto.getNewBroker() != null) {
            this.permissionService.checkManages(dto.getNewBroker());
        }
        this.permissionService.permission(dto.getMember()).admin(AdminMemberPermission.BROKERINGS_CHANGE_BROKER).check();
        return this.brokeringService.changeBroker(dto);
    }

    @Override
    public Brokering getBrokering(Member broker, Member member) throws ValidationException {
        this.permissionService.checkRelatesTo(broker);
        this.permissionService.permission(member).admin(AdminMemberPermission.BROKERINGS_VIEW_MEMBERS).broker(new BrokerPermission[0]).check();
        return this.brokeringService.getBrokering(broker, member);
    }

    @Override
    public Collection<BrokeringQuery.Status> listPossibleStatuses(BrokerGroup brokerGroup) {
        this.permissionService.checkManages(brokerGroup);
        return this.brokeringService.listPossibleStatuses(brokerGroup);
    }

    @Override
    public List<Brokering> search(BrokeringQuery query) {
        if (query.getBrokered() != null) {
            this.permissionService.checkRelatesTo(query.getBrokered());
        }
        if (query.getBroker() == null) {
            throw new ValidationException();
        }
        query.setGroups(PermissionHelper.checkSelection(this.permissionService.getVisibleMemberGroups(), query.getGroups()));
        this.permissionService.permission(query.getBroker()).admin(AdminMemberPermission.BROKERINGS_VIEW_MEMBERS).member(new MemberPermission[0]).check();
        return this.brokeringService.search(query);
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    @Override
    public void validate(ChangeBrokerDTO dto) throws ValidationException {
        this.brokeringService.validate(dto);
    }
}

