/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.dao.members.brokerings.BrokerCommissionContractDAO;
import nl.strohalm.cyclos.dao.members.brokerings.BrokeringCommissionStatusDAO;
import nl.strohalm.cyclos.dao.members.brokerings.DefaultBrokerCommissionDAO;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.AccountType;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFee;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.TransactionFeeQuery;
import nl.strohalm.cyclos.entities.groups.BrokerGroup;
import nl.strohalm.cyclos.entities.groups.Group;
import nl.strohalm.cyclos.entities.groups.GroupQuery;
import nl.strohalm.cyclos.entities.groups.MemberGroup;
import nl.strohalm.cyclos.entities.members.BrokeringQuery;
import nl.strohalm.cyclos.entities.members.Element;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatus;
import nl.strohalm.cyclos.entities.members.brokerings.BrokeringCommissionStatusQuery;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommissionQuery;
import nl.strohalm.cyclos.entities.settings.LocalSettings;
import nl.strohalm.cyclos.services.InitializingService;
import nl.strohalm.cyclos.services.elements.BrokeringServiceLocal;
import nl.strohalm.cyclos.services.elements.CommissionChargeStatusDTO;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.services.elements.MemberServiceLocal;
import nl.strohalm.cyclos.services.fetch.FetchServiceLocal;
import nl.strohalm.cyclos.services.groups.GroupServiceLocal;
import nl.strohalm.cyclos.services.permissions.PermissionServiceLocal;
import nl.strohalm.cyclos.services.settings.SettingsServiceLocal;
import nl.strohalm.cyclos.services.transactions.TransactionSummaryVO;
import nl.strohalm.cyclos.services.transfertypes.TransactionFeeServiceLocal;
import nl.strohalm.cyclos.utils.Amount;
import nl.strohalm.cyclos.utils.CacheCleaner;
import nl.strohalm.cyclos.utils.DataIteratorHelper;
import nl.strohalm.cyclos.utils.DateHelper;
import nl.strohalm.cyclos.utils.Period;
import nl.strohalm.cyclos.utils.TimePeriod;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.notifications.MemberNotificationHandler;
import nl.strohalm.cyclos.utils.query.IteratorList;
import nl.strohalm.cyclos.utils.query.PageHelper;
import nl.strohalm.cyclos.utils.query.QueryParameters;
import nl.strohalm.cyclos.utils.validation.GeneralValidation;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.ValidationException;
import nl.strohalm.cyclos.utils.validation.Validator;
import org.apache.commons.collections.CollectionUtils;

public class CommissionServiceImpl
implements CommissionServiceLocal,
InitializingService {
    private PermissionServiceLocal permissionService;
    private BrokerCommissionContractDAO brokerCommissionContractDao;
    private BrokeringCommissionStatusDAO brokeringCommissionStatusDao;
    private BrokeringServiceLocal brokeringService;
    private DefaultBrokerCommissionDAO defaultBrokerCommissionDao;
    private FetchServiceLocal fetchService;
    private GroupServiceLocal groupService;
    private MemberServiceLocal memberService;
    private SettingsServiceLocal settingsService;
    private TransactionFeeServiceLocal transactionFeeService;
    private MemberNotificationHandler memberNotificationHandler;

    @Override
    public BrokerCommissionContract acceptBrokerCommissionContract(Long brokerCommissionContractId) {
        BrokerCommissionContract brokerCommissionContract = this.loadBrokerCommissionContract(brokerCommissionContractId, new Relationship[0]);
        Period period = brokerCommissionContract.getPeriod();
        boolean alreadyActive = period != null && period.includes(Calendar.getInstance());
        brokerCommissionContract.setStatus(alreadyActive ? BrokerCommissionContract.Status.ACTIVE : BrokerCommissionContract.Status.ACCEPTED);
        brokerCommissionContract = this.brokerCommissionContractDao.update(brokerCommissionContract);
        this.memberNotificationHandler.commissionContractAcceptedNotification(brokerCommissionContract);
        return brokerCommissionContract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateAcceptedBrokerCommissionContracts(Calendar time) {
        Period today = Period.endingAt(DateHelper.truncate(time));
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setStatus(BrokerCommissionContract.Status.ACCEPTED);
        query.setStartPeriod(today);
        List<BrokerCommissionContract> contractsToActivate = this.brokerCommissionContractDao.search(query);
        try {
            for (BrokerCommissionContract contractToActivate : contractsToActivate) {
                contractToActivate.setStatus(BrokerCommissionContract.Status.ACTIVE);
                this.brokerCommissionContractDao.update(contractToActivate);
            }
        }
        finally {
            DataIteratorHelper.close(contractsToActivate);
        }
    }

    @Override
    public BrokerCommissionContract cancelBrokerCommissionContract(Long brokerCommissionContractId) {
        Object cancelledBy = LoggedUser.element();
        BrokerCommissionContract brokerCommissionContract = this.loadBrokerCommissionContract(brokerCommissionContractId, new Relationship[0]);
        brokerCommissionContract.setStatus(BrokerCommissionContract.Status.CANCELLED);
        brokerCommissionContract.setCancelledBy((Element)cancelledBy);
        brokerCommissionContract = this.brokerCommissionContractDao.update(brokerCommissionContract);
        this.memberNotificationHandler.commissionContractCancelledNotification(brokerCommissionContract);
        return brokerCommissionContract;
    }

    @Override
    public BrokeringCommissionStatus closeBrokeringCommissionStatus(BrokeringCommissionStatus brokeringCommissionStatus) {
        brokeringCommissionStatus.getPeriod().setEnd(Calendar.getInstance());
        brokeringCommissionStatus = this.brokeringCommissionStatusDao.update(brokeringCommissionStatus);
        return brokeringCommissionStatus;
    }

    @Override
    public void createBrokeringCommissionStatus(BrokerCommission brokerCommission) {
        Collection<BrokerGroup> brokerGroups = null;
        if (brokerCommission.isAllBrokerGroups()) {
            GroupQuery query = new GroupQuery();
            query.setNature(Group.Nature.BROKER);
            query.setStatus(Group.Status.NORMAL);
            query.setOnlyActive(true);
            brokerGroups = this.groupService.search(query);
        } else {
            brokerGroups = this.fetchService.fetch(brokerCommission.getBrokerGroups(), new Relationship[0]);
        }
        for (BrokerGroup brokerGroup : brokerGroups) {
            this.createBrokeringCommissionStatus(brokerGroup, brokerCommission);
        }
    }

    @Override
    public BrokeringCommissionStatus createBrokeringCommissionStatus(Brokering brokering, BrokerCommission brokerCommission) {
        DefaultBrokerCommission defaultBrokerCommission;
        BrokeringCommissionStatus brokeringCommissionStatus = new BrokeringCommissionStatus();
        brokeringCommissionStatus.setBrokering(brokering);
        brokeringCommissionStatus.setBrokerCommission(brokerCommission);
        brokeringCommissionStatus.setCreationDate(Calendar.getInstance());
        boolean fillFromCommission = true;
        if (brokerCommission.isFromMember() && (defaultBrokerCommission = this.getDefaultBrokerCommission(brokering.getBroker(), brokerCommission)) != null) {
            brokeringCommissionStatus.setAmount(defaultBrokerCommission.getAmount());
            brokeringCommissionStatus.setWhen(defaultBrokerCommission.getWhen());
            brokeringCommissionStatus.setMaxCount(defaultBrokerCommission.getCount());
            fillFromCommission = false;
        }
        if (fillFromCommission) {
            brokeringCommissionStatus.setAmount(brokerCommission.getAmount());
            brokeringCommissionStatus.setWhen(brokerCommission.getWhen());
            brokeringCommissionStatus.setMaxCount(brokerCommission.getCount());
        }
        TransactionSummaryVO total = new TransactionSummaryVO();
        total.setCount(0);
        total.setAmount(new BigDecimal(0));
        brokeringCommissionStatus.setTotal(total);
        Period period = new Period();
        period.setBegin(brokering.getStartDate());
        if (brokeringCommissionStatus.getWhen() == BrokerCommission.When.DAYS) {
            Calendar brokeringStartDate = brokering.getStartDate();
            int daysCount = brokeringCommissionStatus.getMaxCount();
            Calendar expirationDate = new TimePeriod(daysCount, TimePeriod.Field.DAYS).add(brokeringStartDate);
            brokeringCommissionStatus.setExpiryDate(expirationDate);
            Calendar now = Calendar.getInstance();
            if (now.compareTo(expirationDate) >= 0) {
                period.setEnd(expirationDate);
            }
        }
        brokeringCommissionStatus.setPeriod(period);
        return this.brokeringCommissionStatusDao.insert(brokeringCommissionStatus);
    }

    @Override
    public void createDefaultBrokerCommissions(BrokerCommission brokerCommission) {
        Collection<BrokerGroup> brokerGroups = null;
        if (brokerCommission.isAllBrokerGroups()) {
            GroupQuery query = new GroupQuery();
            query.setNature(Group.Nature.BROKER);
            query.setStatus(Group.Status.NORMAL);
            query.setOnlyActive(true);
            brokerGroups = this.groupService.search(query);
        } else {
            brokerGroups = this.fetchService.fetch(brokerCommission.getBrokerGroups(), new Relationship[0]);
        }
        for (BrokerGroup brokerGroup : brokerGroups) {
            this.createDefaultBrokerCommissions(brokerCommission, brokerGroup);
        }
    }

    @Override
    public BrokerCommissionContract denyBrokerCommissionContract(Long brokerCommissionContractId) {
        BrokerCommissionContract brokerCommissionContract = this.loadBrokerCommissionContract(brokerCommissionContractId, new Relationship[0]);
        brokerCommissionContract.setStatus(BrokerCommissionContract.Status.DENIED);
        brokerCommissionContract = this.brokerCommissionContractDao.update(brokerCommissionContract);
        this.memberNotificationHandler.commissionContractDeniedNotification(brokerCommissionContract);
        return brokerCommissionContract;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireBrokerCommissionContracts(Calendar time) {
        Period endOfYesterday = Period.endingAt(DateHelper.truncatePreviosDay(time));
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setStatus(BrokerCommissionContract.Status.ACTIVE);
        query.setEndPeriod(endOfYesterday);
        List<BrokerCommissionContract> contractsToClose = this.brokerCommissionContractDao.search(query);
        try {
            for (BrokerCommissionContract contractToClose : contractsToClose) {
                contractToClose.setStatus(BrokerCommissionContract.Status.CLOSED);
                this.brokerCommissionContractDao.update(contractToClose);
            }
        }
        finally {
            DataIteratorHelper.close(contractsToClose);
        }
        query = new BrokerCommissionContractQuery();
        query.setResultType(QueryParameters.ResultType.ITERATOR);
        query.setStatus(BrokerCommissionContract.Status.PENDING);
        query.setStartPeriod(endOfYesterday);
        List<BrokerCommissionContract> contractsToExpire = this.brokerCommissionContractDao.search(query);
        try {
            for (BrokerCommissionContract contractToExpire : contractsToExpire) {
                contractToExpire.setStatus(BrokerCommissionContract.Status.EXPIRED);
                this.brokerCommissionContractDao.update(contractToExpire);
            }
        }
        finally {
            DataIteratorHelper.close(contractsToExpire);
        }
    }

    @Override
    public void expireBrokeringCommissionStatus(Calendar date) {
        this.brokeringCommissionStatusDao.expireBrokeringCommissionStatus(date);
    }

    @Override
    public BrokerCommissionContract getActiveBrokerCommissionContract(Brokering brokering, BrokerCommission brokerCommission) {
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(brokering.getBroker());
        query.setMember(brokering.getBrokered());
        query.setBrokerCommission(brokerCommission);
        query.setStatus(BrokerCommissionContract.Status.ACTIVE);
        query.setUniqueResult();
        List<BrokerCommissionContract> contracts = this.brokerCommissionContractDao.search(query);
        if (CollectionUtils.isEmpty(contracts)) {
            return null;
        }
        return contracts.iterator().next();
    }

    @Override
    public BrokeringCommissionStatus getBrokeringCommissionStatus(Brokering brokering, BrokerCommission brokerCommission) {
        return this.brokeringCommissionStatusDao.load(brokering, brokerCommission, new Relationship[0]);
    }

    @Override
    public List<CommissionChargeStatusDTO> getCommissionChargeStatus(Member member) {
        ArrayList<CommissionChargeStatusDTO> commissionChargeStatusList = new ArrayList<CommissionChargeStatusDTO>();
        Brokering brokering = this.brokeringService.getActiveBrokering(member);
        if (brokering != null) {
            Member broker = this.fetchService.fetch(brokering.getBroker(), Element.Relationships.GROUP);
            TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
            transactionFeeQuery.setGeneratedTransferTypeFromNature(AccountType.Nature.MEMBER);
            transactionFeeQuery.setEntityType(BrokerCommission.class);
            transactionFeeQuery.setBrokerGroup((BrokerGroup)broker.getGroup());
            transactionFeeQuery.setMemberGroup((MemberGroup)member.getGroup());
            List<? extends TransactionFee> brokerCommissions = this.transactionFeeService.search(transactionFeeQuery);
            for (BrokerCommission brokerCommission : brokerCommissions) {
                CommissionChargeStatusDTO commissionChargeStatusDto = new CommissionChargeStatusDTO();
                commissionChargeStatusDto.setBrokerCommission(brokerCommission);
                BrokerCommissionContract contract = this.getBrokerCommissionContract(member, broker, brokerCommission);
                if (contract != null) {
                    commissionChargeStatusDto.setBrokerCommissionContract(contract);
                    commissionChargeStatusDto.setChargeStatus(CommissionChargeStatusDTO.ChargeStatus.CONTRACT);
                } else {
                    BrokeringCommissionStatus status = this.getBrokeringCommissionStatus(brokering, brokerCommission);
                    DefaultBrokerCommission defaultBrokerCommission = this.getDefaultBrokerCommission(broker, brokerCommission);
                    if (defaultBrokerCommission != null && status.getPeriod().getEnd() == null) {
                        commissionChargeStatusDto.setBrokeringCommissionStatus(status);
                        commissionChargeStatusDto.setChargeStatus(CommissionChargeStatusDTO.ChargeStatus.DEFAULT_COMMISSION);
                    } else {
                        commissionChargeStatusDto.setChargeStatus(CommissionChargeStatusDTO.ChargeStatus.NONE);
                    }
                }
                commissionChargeStatusList.add(commissionChargeStatusDto);
            }
        }
        return commissionChargeStatusList;
    }

    @Override
    public DefaultBrokerCommission getDefaultBrokerCommission(Member broker, BrokerCommission brokerCommission) {
        DefaultBrokerCommissionQuery query = new DefaultBrokerCommissionQuery();
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setUniqueResult();
        List<DefaultBrokerCommission> defaultBrokerCommissions = this.defaultBrokerCommissionDao.search(query);
        if (CollectionUtils.isEmpty(defaultBrokerCommissions)) {
            return null;
        }
        return defaultBrokerCommissions.iterator().next();
    }

    @Override
    public BrokeringCommissionStatus getOrUpdateBrokeringCommissionStatus(Brokering brokering, BrokerCommission brokerCommission) {
        return this.getOrUpdateBrokeringCommissionStatus(brokering, brokerCommission, brokerCommission.getAmount(), brokerCommission.getWhen(), brokerCommission.getCount());
    }

    @Override
    public boolean hasAllPermissions() {
        return this.permissionService.permission().admin(AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS).broker(BrokerPermission.MEMBERS_MANAGE_CONTRACTS).member(new MemberPermission[0]).hasPermission();
    }

    @Override
    public boolean hasBrokerCommissionContracts() {
        if (!this.hasAllPermissions()) {
            return false;
        }
        BrokerCommissionContractQuery commissionQuery = new BrokerCommissionContractQuery();
        commissionQuery.setPageForCount();
        commissionQuery.setMember(LoggedUser.member());
        return PageHelper.hasResults(this.brokerCommissionContractDao.search(commissionQuery));
    }

    @Override
    public void initializeService() {
        Calendar now = Calendar.getInstance();
        this.activateAcceptedBrokerCommissionContracts(now);
        this.expireBrokerCommissionContracts(now);
        this.expireBrokeringCommissionStatus(now);
    }

    @Override
    public List<BrokerCommission> listPossibleCommissionsForNewContract(Member brokered) {
        brokered = this.fetchService.fetch(brokered, Element.Relationships.GROUP);
        BrokerGroup brokerGroup = (BrokerGroup)LoggedUser.group();
        MemberGroup memberGroup = brokered.getMemberGroup();
        TransactionFeeQuery transactionFeeQuery = new TransactionFeeQuery();
        transactionFeeQuery.setGeneratedTransferTypeFromNature(AccountType.Nature.MEMBER);
        transactionFeeQuery.setEntityType(BrokerCommission.class);
        transactionFeeQuery.setBrokerGroup(brokerGroup);
        transactionFeeQuery.setMemberGroup(memberGroup);
        ArrayList<? extends TransactionFee> brokerCommissions = new ArrayList<TransactionFee>(this.transactionFeeService.search(transactionFeeQuery));
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(LoggedUser.member());
        query.setMember(brokered);
        query.setStatusList(Arrays.asList(BrokerCommissionContract.Status.ACCEPTED, BrokerCommissionContract.Status.ACTIVE, BrokerCommissionContract.Status.PENDING));
        List<BrokerCommissionContract> contracts = this.searchBrokerCommissionContracts(query);
        Iterator it = brokerCommissions.iterator();
        block0: while (it.hasNext()) {
            BrokerCommission brokerCommission = (BrokerCommission)it.next();
            for (BrokerCommissionContract contract : contracts) {
                if (!contract.getBrokerCommission().equals(brokerCommission)) continue;
                it.remove();
                continue block0;
            }
        }
        return brokerCommissions;
    }

    @Override
    public BrokerCommissionContract loadBrokerCommissionContract(Long id, Relationship ... fetch) {
        return (BrokerCommissionContract)this.brokerCommissionContractDao.load(id, fetch);
    }

    public BrokeringCommissionStatus loadBrokeringCommissionStatus(Long id, Relationship ... fetch) {
        return (BrokeringCommissionStatus)this.brokeringCommissionStatusDao.load(id, fetch);
    }

    @Override
    public List<DefaultBrokerCommission> loadDefaultBrokerCommissions(Member broker, Relationship ... fetch) {
        return this.defaultBrokerCommissionDao.load(broker, fetch);
    }

    @Override
    public int removeBrokerCommissionContracts(Long ... ids) {
        return this.brokerCommissionContractDao.delete(ids);
    }

    @Override
    public BrokerCommissionContract saveBrokerCommissionContract(BrokerCommissionContract brokerCommissionContract) {
        this.validateBrokerCommissionContract(brokerCommissionContract);
        if (brokerCommissionContract.isTransient()) {
            brokerCommissionContract = this.brokerCommissionContractDao.insert(brokerCommissionContract);
            this.memberNotificationHandler.newCommissionContractNotification(brokerCommissionContract);
            return brokerCommissionContract;
        }
        return this.brokerCommissionContractDao.update(brokerCommissionContract);
    }

    @Override
    public List<DefaultBrokerCommission> saveDefaultBrokerCommissions(List<DefaultBrokerCommission> commissions) {
        ArrayList<DefaultBrokerCommission> savedList = new ArrayList<DefaultBrokerCommission>();
        for (DefaultBrokerCommission defaultBrokerCommission : commissions) {
            if (defaultBrokerCommission.isSuspended()) continue;
            defaultBrokerCommission.setSetByBroker(true);
            defaultBrokerCommission = this.saveDefaultBrokerCommission(defaultBrokerCommission);
            savedList.add(defaultBrokerCommission);
        }
        return savedList;
    }

    @Override
    public List<BrokerCommissionContract> searchBrokerCommissionContracts(BrokerCommissionContractQuery query) {
        return this.brokerCommissionContractDao.search(query);
    }

    public void setBrokerCommissionContractDao(BrokerCommissionContractDAO brokerCommissionContractDao) {
        this.brokerCommissionContractDao = brokerCommissionContractDao;
    }

    public void setBrokeringCommissionStatusDao(BrokeringCommissionStatusDAO brokeringCommissionStatusDao) {
        this.brokeringCommissionStatusDao = brokeringCommissionStatusDao;
    }

    public void setBrokeringServiceLocal(BrokeringServiceLocal brokeringService) {
        this.brokeringService = brokeringService;
    }

    public void setDefaultBrokerCommissionDao(DefaultBrokerCommissionDAO defaultBrokerCommissionDao) {
        this.defaultBrokerCommissionDao = defaultBrokerCommissionDao;
    }

    public void setFetchServiceLocal(FetchServiceLocal fetchService) {
        this.fetchService = fetchService;
    }

    public void setGroupServiceLocal(GroupServiceLocal groupService) {
        this.groupService = groupService;
    }

    public void setMemberNotificationHandler(MemberNotificationHandler memberNotificationHandler) {
        this.memberNotificationHandler = memberNotificationHandler;
    }

    public void setMemberServiceLocal(MemberServiceLocal memberService) {
        this.memberService = memberService;
    }

    public void setPermissionServiceLocal(PermissionServiceLocal permissionService) {
        this.permissionService = permissionService;
    }

    public void setSettingsServiceLocal(SettingsServiceLocal settingsService) {
        this.settingsService = settingsService;
    }

    public void setTransactionFeeServiceLocal(TransactionFeeServiceLocal transactionFeeService) {
        this.transactionFeeService = transactionFeeService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCommissions(BrokerCommission brokerCommission, BrokerGroup brokerGroup) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        IteratorList<Member> brokers = this.memberService.iterateByGroup(brokerGroup);
        try {
            for (Member broker : brokers) {
                this.stopCommissions(brokerCommission, broker, true);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(brokers);
        }
    }

    @Override
    public void stopCommissions(BrokerCommission brokerCommission, Member broker, boolean removeDefaultBrokerCommission) {
        if ((brokerCommission = this.fetchService.fetch(brokerCommission, new Relationship[0])).isFromMember()) {
            DefaultBrokerCommission defaultBrokerCommission = this.getDefaultBrokerCommission(broker, brokerCommission);
            if (defaultBrokerCommission != null) {
                if (removeDefaultBrokerCommission) {
                    this.defaultBrokerCommissionDao.delete(defaultBrokerCommission.getId());
                } else {
                    Amount zeroAmount = new Amount();
                    zeroAmount.setType(defaultBrokerCommission.getAmount().getType());
                    zeroAmount.setValue(new BigDecimal(0));
                    defaultBrokerCommission.setAmount(zeroAmount);
                    this.defaultBrokerCommissionDao.update(defaultBrokerCommission);
                }
            }
            this.closeBrokerCommissionContracts(broker, brokerCommission);
        }
        this.closeBrokeringCommissionStatus(broker, brokerCommission);
    }

    @Override
    public void suspendCommissions(BrokerCommission brokerCommission, Member broker) {
        if ((brokerCommission = this.fetchService.fetch(brokerCommission, new Relationship[0])).isFromMember()) {
            DefaultBrokerCommission defaultBrokerCommission = this.getDefaultBrokerCommission(broker, brokerCommission);
            if (defaultBrokerCommission != null) {
                defaultBrokerCommission.setSuspended(true);
                this.defaultBrokerCommissionDao.update(defaultBrokerCommission);
            }
            this.suspendBrokerCommissionContracts(broker, brokerCommission);
        }
    }

    @Override
    public void unsuspendCommissions(BrokerCommission brokerCommission, Member broker) {
        if ((brokerCommission = this.fetchService.fetch(brokerCommission, new Relationship[0])).isFromMember()) {
            DefaultBrokerCommission defaultBrokerCommission = this.getDefaultBrokerCommission(broker, brokerCommission);
            if (defaultBrokerCommission != null) {
                defaultBrokerCommission.setSuspended(false);
                this.defaultBrokerCommissionDao.update(defaultBrokerCommission);
            }
            this.unsuspendBrokerCommissionContracts(broker, brokerCommission);
        }
    }

    @Override
    public void updateBrokerCommissions(Member broker, MemberGroup oldGroup, MemberGroup newGroup) {
        TransactionFeeQuery query;
        List<Object> oldBrokerCommissions = new ArrayList();
        List<Object> newBrokerCommissions = new ArrayList();
        if (oldGroup instanceof BrokerGroup) {
            BrokerGroup oldBrokerGroup = (BrokerGroup)oldGroup;
            query = new TransactionFeeQuery();
            query.setEntityType(BrokerCommission.class);
            query.setBrokerGroup(oldBrokerGroup);
            query.setReturnDisabled(true);
            oldBrokerCommissions = this.transactionFeeService.search(query);
        }
        if (newGroup instanceof BrokerGroup) {
            BrokerGroup newBrokerGroup = (BrokerGroup)newGroup;
            query = new TransactionFeeQuery();
            query.setEntityType(BrokerCommission.class);
            query.setBrokerGroup(newBrokerGroup);
            query.setReturnDisabled(true);
            newBrokerCommissions = this.transactionFeeService.search(query);
        }
        for (BrokerCommission oldBrokerCommission : oldBrokerCommissions) {
            if (newBrokerCommissions.contains(oldBrokerCommission)) continue;
            this.stopCommissions(oldBrokerCommission, broker, true);
        }
        for (BrokerCommission newBrokerCommission : newBrokerCommissions) {
            if (oldBrokerCommissions.contains(newBrokerCommission)) continue;
            if (newBrokerCommission.isFromMember()) {
                this.createDefaultBrokerCommission(newBrokerCommission, broker);
            }
            this.createBrokeringCommissionStatus(broker, newBrokerCommission);
        }
    }

    @Override
    public void updateBrokeringCommissionStatus(BrokerCommission brokerCommission, BrokerCommission savedBrokerCommission) {
        Collection<BrokerGroup> allBrokerGroups = null;
        if (brokerCommission.isAllBrokerGroups() || savedBrokerCommission.isAllBrokerGroups()) {
            GroupQuery query = new GroupQuery();
            query.setNature(Group.Nature.BROKER);
            query.setStatus(Group.Status.NORMAL);
            query.setOnlyActive(true);
            allBrokerGroups = this.groupService.search(query);
        }
        Collection<BrokerGroup> brokerGroups = null;
        Collection<BrokerGroup> savedBrokerGroups = null;
        brokerGroups = brokerCommission.isAllBrokerGroups() ? allBrokerGroups : this.fetchService.fetch(brokerCommission.getBrokerGroups(), new Relationship[0]);
        savedBrokerGroups = savedBrokerCommission.isAllBrokerGroups() ? allBrokerGroups : savedBrokerCommission.getBrokerGroups();
        for (BrokerGroup brokerGroup : brokerGroups) {
            if (!savedBrokerGroups.contains(brokerGroup)) {
                this.createBrokeringCommissionStatus(brokerGroup, brokerCommission);
                continue;
            }
            this.updateBrokeringCommissionStatus(brokerGroup, brokerCommission);
        }
        for (BrokerGroup savedBrokerGroup : savedBrokerGroups) {
            if (brokerGroups.contains(savedBrokerGroup)) continue;
            this.stopCommissions(brokerCommission, savedBrokerGroup);
        }
    }

    @Override
    public BrokeringCommissionStatus updateBrokeringCommissionStatus(BrokeringCommissionStatus brokeringCommissionStatus) {
        return this.brokeringCommissionStatusDao.update(brokeringCommissionStatus);
    }

    @Override
    public void updateDefaultBrokerCommissions(BrokerCommission brokerCommission, BrokerCommission savedBrokerCommission) {
        Collection<BrokerGroup> allBrokerGroups = null;
        if (brokerCommission.isAllBrokerGroups() || savedBrokerCommission.isAllBrokerGroups()) {
            GroupQuery query = new GroupQuery();
            query.setNature(Group.Nature.BROKER);
            query.setStatus(Group.Status.NORMAL);
            query.setOnlyActive(true);
            allBrokerGroups = this.groupService.search(query);
        }
        Collection<BrokerGroup> brokerGroups = null;
        Collection<BrokerGroup> savedBrokerGroups = null;
        brokerGroups = brokerCommission.isAllBrokerGroups() ? allBrokerGroups : this.fetchService.fetch(brokerCommission.getBrokerGroups(), new Relationship[0]);
        savedBrokerGroups = savedBrokerCommission.isAllBrokerGroups() ? allBrokerGroups : savedBrokerCommission.getBrokerGroups();
        for (BrokerGroup brokerGroup : brokerGroups) {
            if (!savedBrokerGroups.contains(brokerGroup)) {
                this.createDefaultBrokerCommissions(brokerCommission, brokerGroup);
                continue;
            }
            this.updateDefaultBrokerCommissions(brokerCommission, brokerGroup);
        }
        for (BrokerGroup savedBrokerGroup : savedBrokerGroups) {
            if (brokerGroups.contains(savedBrokerGroup)) continue;
            this.stopCommissions(brokerCommission, savedBrokerGroup);
        }
    }

    @Override
    public void validateBrokerCommissionContract(BrokerCommissionContract brokerCommissionContract) throws ValidationException {
        this.getBrokerCommissionContractValidator().validate(brokerCommissionContract);
    }

    @Override
    public void validateDefaultBrokerCommissions(List<DefaultBrokerCommission> defaultBrokerCommissions) throws ValidationException {
        Validator defaultBrokerCommissionValidator = this.getDefaultBrokerCommissionValidator();
        for (DefaultBrokerCommission defaultBrokerCommission : defaultBrokerCommissions) {
            defaultBrokerCommissionValidator.validate(defaultBrokerCommission);
        }
    }

    private void closeBrokerCommissionContracts(Member broker, BrokerCommission brokerCommission) {
        ArrayList<BrokerCommissionContract.Status> statusList = new ArrayList<BrokerCommissionContract.Status>();
        statusList.add(BrokerCommissionContract.Status.PENDING);
        statusList.add(BrokerCommissionContract.Status.ACTIVE);
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setStatusList(statusList);
        List<BrokerCommissionContract> brokerCommissionContracts = this.brokerCommissionContractDao.search(query);
        for (BrokerCommissionContract brokerCommissionContract : brokerCommissionContracts) {
            brokerCommissionContract.setStatus(BrokerCommissionContract.Status.CLOSED);
            this.brokerCommissionContractDao.update(brokerCommissionContract);
        }
    }

    private void closeBrokeringCommissionStatus(Member broker, BrokerCommission brokerCommission) {
        Calendar now = Calendar.getInstance();
        BrokeringCommissionStatusQuery query = new BrokeringCommissionStatusQuery();
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setOnlyActive(true);
        List<BrokeringCommissionStatus> statusList = this.brokeringCommissionStatusDao.search(query);
        for (BrokeringCommissionStatus status : statusList) {
            status.getPeriod().setEnd(now);
            this.brokeringCommissionStatusDao.update(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBrokeringCommissionStatus(BrokerGroup brokerGroup, BrokerCommission brokerCommission) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        IteratorList<Member> brokers = this.memberService.iterateByGroup(brokerGroup);
        try {
            for (Member broker : brokers) {
                this.createBrokeringCommissionStatus(broker, brokerCommission);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(brokers);
        }
    }

    private void createBrokeringCommissionStatus(Member broker, BrokerCommission brokerCommission) {
        BrokeringQuery brokeringQuery = new BrokeringQuery();
        brokeringQuery.setBroker(broker);
        List<Brokering> brokerings = this.brokeringService.search(brokeringQuery);
        for (Brokering brokering : brokerings) {
            this.getOrUpdateBrokeringCommissionStatus(brokering, brokerCommission);
        }
    }

    private DefaultBrokerCommission createDefaultBrokerCommission(BrokerCommission brokerCommission, Member broker) {
        DefaultBrokerCommission defaultBrokerCommission = new DefaultBrokerCommission();
        defaultBrokerCommission.setBroker(broker);
        defaultBrokerCommission.setBrokerCommission(brokerCommission);
        defaultBrokerCommission.setAmount(brokerCommission.getAmount());
        defaultBrokerCommission.setWhen(brokerCommission.getWhen());
        defaultBrokerCommission.setCount(brokerCommission.getCount());
        this.saveDefaultBrokerCommission(defaultBrokerCommission);
        return defaultBrokerCommission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultBrokerCommissions(BrokerCommission brokerCommission, BrokerGroup brokerGroup) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        IteratorList<Member> brokers = this.memberService.iterateByGroup(brokerGroup);
        try {
            for (Member broker : brokers) {
                this.createDefaultBrokerCommission(brokerCommission, broker);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(brokers);
        }
    }

    private BrokerCommissionContract getBrokerCommissionContract(Member member, Member broker, BrokerCommission brokerCommission) {
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setMember(member);
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setStatus(BrokerCommissionContract.Status.ACTIVE);
        query.setUniqueResult();
        List<BrokerCommissionContract> contracts = this.searchBrokerCommissionContracts(query);
        if (CollectionUtils.isNotEmpty(contracts)) {
            return (BrokerCommissionContract)contracts.iterator().next();
        }
        query.setStatus(BrokerCommissionContract.Status.PENDING);
        contracts = this.searchBrokerCommissionContracts(query);
        if (CollectionUtils.isNotEmpty(contracts)) {
            return (BrokerCommissionContract)contracts.iterator().next();
        }
        return null;
    }

    private Validator getBrokerCommissionContractValidator() {
        Validator brokerCommissionContractValidator = new Validator("brokerCommissionContract");
        brokerCommissionContractValidator.property("brokering").required();
        brokerCommissionContractValidator.property("brokerCommission").required();
        brokerCommissionContractValidator.property("period.begin").key("brokerCommissionContract.startDate").required().futureOrToday();
        brokerCommissionContractValidator.property("amount.type").key("brokerCommissionContract.amount").required();
        brokerCommissionContractValidator.property("amount.value").key("brokerCommissionContract.amount").required();
        brokerCommissionContractValidator.property("status").required().add(new StatusValidation());
        brokerCommissionContractValidator.general(new ConflictingContractValidation());
        return brokerCommissionContractValidator;
    }

    private Validator getDefaultBrokerCommissionValidator() {
        Validator defaultBrokerCommissionValidator = new Validator("defaultBrokerCommission");
        defaultBrokerCommissionValidator.property("broker").required();
        defaultBrokerCommissionValidator.property("brokerCommission").required();
        defaultBrokerCommissionValidator.property("amount.type").key("transactionFee.amount").required();
        defaultBrokerCommissionValidator.property("amount.value").key("transactionFee.amount").required();
        defaultBrokerCommissionValidator.property("when").required();
        defaultBrokerCommissionValidator.general(new DefaultBrokerCommissionValidation());
        return defaultBrokerCommissionValidator;
    }

    private BrokeringCommissionStatus getOrUpdateBrokeringCommissionStatus(Brokering brokering, BrokerCommission brokerCommission, Amount amount, BrokerCommission.When when, Integer count) {
        BrokeringCommissionStatus brokeringCommissionStatus = this.getBrokeringCommissionStatus(brokering, brokerCommission);
        if (brokeringCommissionStatus == null) {
            brokeringCommissionStatus = this.createBrokeringCommissionStatus(brokering, brokerCommission);
        } else if (brokeringCommissionStatus.getTotal().getCount() == 0 && brokeringCommissionStatus.getPeriod().getEnd() == null) {
            brokeringCommissionStatus.setAmount(amount);
            brokeringCommissionStatus.setWhen(when);
            brokeringCommissionStatus.setMaxCount(count);
            brokeringCommissionStatus = this.brokeringCommissionStatusDao.update(brokeringCommissionStatus);
        }
        return brokeringCommissionStatus;
    }

    private DefaultBrokerCommission saveDefaultBrokerCommission(DefaultBrokerCommission defaultBrokerCommission) {
        if (defaultBrokerCommission.getWhen() == BrokerCommission.When.ALWAYS) {
            defaultBrokerCommission.setCount(null);
        }
        defaultBrokerCommission = defaultBrokerCommission.isTransient() ? this.defaultBrokerCommissionDao.insert(defaultBrokerCommission) : this.defaultBrokerCommissionDao.update(defaultBrokerCommission);
        this.updateBrokeringCommissionStatus(defaultBrokerCommission);
        return defaultBrokerCommission;
    }

    private void suspendBrokerCommissionContracts(Member broker, BrokerCommission brokerCommission) {
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setStatusList(Arrays.asList(BrokerCommissionContract.Status.PENDING, BrokerCommissionContract.Status.ACCEPTED, BrokerCommissionContract.Status.ACTIVE));
        List<BrokerCommissionContract> brokerCommissionContracts = this.brokerCommissionContractDao.search(query);
        for (BrokerCommissionContract brokerCommissionContract : brokerCommissionContracts) {
            brokerCommissionContract.setStatusBeforeSuspension(brokerCommissionContract.getStatus());
            brokerCommissionContract.setStatus(BrokerCommissionContract.Status.SUSPENDED);
            this.brokerCommissionContractDao.update(brokerCommissionContract);
        }
    }

    private void unsuspendBrokerCommissionContracts(Member broker, BrokerCommission brokerCommission) {
        Calendar today = DateHelper.truncate(Calendar.getInstance());
        BrokerCommissionContractQuery query = new BrokerCommissionContractQuery();
        query.setBroker(broker);
        query.setBrokerCommission(brokerCommission);
        query.setStatus(BrokerCommissionContract.Status.SUSPENDED);
        List<BrokerCommissionContract> brokerCommissionContracts = this.brokerCommissionContractDao.search(query);
        for (BrokerCommissionContract brokerCommissionContract : brokerCommissionContracts) {
            BrokerCommissionContract.Status statusBeforeSuspension = brokerCommissionContract.getStatusBeforeSuspension();
            Calendar beginOfContract = brokerCommissionContract.getPeriod().getBegin();
            Calendar endOfContract = brokerCommissionContract.getPeriod().getEnd();
            if (statusBeforeSuspension == BrokerCommissionContract.Status.ACTIVE) {
                if (endOfContract.compareTo(today) < 0) {
                    brokerCommissionContract.setStatus(BrokerCommissionContract.Status.CLOSED);
                } else {
                    brokerCommissionContract.setStatus(BrokerCommissionContract.Status.ACTIVE);
                }
            } else if (statusBeforeSuspension == BrokerCommissionContract.Status.ACCEPTED) {
                if (endOfContract.compareTo(today) < 0) {
                    brokerCommissionContract.setStatus(BrokerCommissionContract.Status.CLOSED);
                } else if (beginOfContract.compareTo(today) <= 0) {
                    brokerCommissionContract.setStatus(BrokerCommissionContract.Status.ACTIVE);
                } else {
                    brokerCommissionContract.setStatus(BrokerCommissionContract.Status.ACCEPTED);
                }
            } else if (beginOfContract.compareTo(today) <= 0) {
                brokerCommissionContract.setStatus(BrokerCommissionContract.Status.EXPIRED);
            } else {
                brokerCommissionContract.setStatus(BrokerCommissionContract.Status.PENDING);
            }
            brokerCommissionContract.setStatusBeforeSuspension(null);
            this.brokerCommissionContractDao.update(brokerCommissionContract);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBrokeringCommissionStatus(BrokerGroup brokerGroup, BrokerCommission brokerCommission) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        IteratorList<Member> brokers = this.memberService.iterateByGroup(brokerGroup);
        try {
            for (Member broker : brokers) {
                this.updateBrokeringCommissionStatus(broker, brokerCommission);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(brokers);
        }
    }

    private void updateBrokeringCommissionStatus(DefaultBrokerCommission defaultBrokerCommission) {
        Member broker = defaultBrokerCommission.getBroker();
        BrokerCommission brokerCommission = defaultBrokerCommission.getBrokerCommission();
        BrokeringQuery brokeringQuery = new BrokeringQuery();
        brokeringQuery.setBroker(broker);
        List<Brokering> brokerings = this.brokeringService.search(brokeringQuery);
        for (Brokering brokering : brokerings) {
            this.getOrUpdateBrokeringCommissionStatus(brokering, brokerCommission, defaultBrokerCommission.getAmount(), defaultBrokerCommission.getWhen(), defaultBrokerCommission.getCount());
        }
    }

    private void updateBrokeringCommissionStatus(Member broker, BrokerCommission brokerCommission) {
        BrokeringQuery brokeringQuery = new BrokeringQuery();
        brokeringQuery.setBroker(broker);
        List<Brokering> brokerings = this.brokeringService.search(brokeringQuery);
        for (Brokering brokering : brokerings) {
            this.getOrUpdateBrokeringCommissionStatus(brokering, brokerCommission);
        }
    }

    private void updateDefaultBrokerCommission(BrokerCommission brokerCommission, Member broker) {
        DefaultBrokerCommission defaultBrokerCommission = this.getDefaultBrokerCommission(broker, brokerCommission);
        if (defaultBrokerCommission == null) {
            defaultBrokerCommission = this.createDefaultBrokerCommission(brokerCommission, broker);
        }
        if (!defaultBrokerCommission.isSetByBroker()) {
            BrokeringCommissionStatusQuery query = new BrokeringCommissionStatusQuery();
            query.setBroker(broker);
            query.setBrokerCommission(brokerCommission);
            List<BrokeringCommissionStatus> statusList = this.brokeringCommissionStatusDao.search(query);
            boolean canUpdate = true;
            for (BrokeringCommissionStatus status : statusList) {
                if (status.getTotal().getAmount().compareTo(new BigDecimal(0)) <= 0) continue;
                canUpdate = false;
                break;
            }
            if (canUpdate) {
                defaultBrokerCommission.setAmount(brokerCommission.getAmount());
                this.defaultBrokerCommissionDao.update(defaultBrokerCommission);
                this.updateBrokeringCommissionStatus(defaultBrokerCommission);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultBrokerCommissions(BrokerCommission brokerCommission, BrokerGroup brokerGroup) {
        CacheCleaner cacheCleaner = new CacheCleaner(this.fetchService);
        IteratorList<Member> brokers = this.memberService.iterateByGroup(brokerGroup);
        try {
            for (Member broker : brokers) {
                this.updateDefaultBrokerCommission(brokerCommission, broker);
                cacheCleaner.clearCache();
            }
        }
        finally {
            DataIteratorHelper.close(brokers);
        }
    }

    public class StatusValidation
    implements PropertyValidation {
        private static final long serialVersionUID = 1390235157926363221L;

        @Override
        public ValidationError validate(Object object, Object property, Object value) {
            BrokerCommissionContract.Status status = (BrokerCommissionContract.Status)value;
            if (status != BrokerCommissionContract.Status.PENDING) {
                return new ValidationError("brokerCommissionContract.error.notPendingStatus", new Object[0]);
            }
            return null;
        }
    }

    public class DefaultBrokerCommissionValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -7493901526206665521L;

        @Override
        public ValidationError validate(Object object) {
            DefaultBrokerCommission defaultBrokerCommission = (DefaultBrokerCommission)object;
            if (defaultBrokerCommission.getBrokerCommission() != null) {
                BrokerCommission brokerCommission = CommissionServiceImpl.this.fetchService.fetch(defaultBrokerCommission.getBrokerCommission(), new Relationship[0]);
                Amount defaultAmount = defaultBrokerCommission.getAmount();
                Amount.Type type = defaultAmount.getType();
                BigDecimal defaultValue = defaultAmount.getValue();
                BigDecimal feeValue = null;
                feeValue = type == Amount.Type.FIXED ? brokerCommission.getMaxFixedValue() : brokerCommission.getMaxPercentageValue();
                if (defaultValue != null && feeValue != null && defaultValue.compareTo(feeValue) > 0) {
                    LocalSettings localSettings = CommissionServiceImpl.this.settingsService.getLocalSettings();
                    String brokerCommissionName = brokerCommission.getName();
                    Amount feeAmount = new Amount(feeValue, type);
                    String formattedFeeAmount = localSettings.getAmountConverter().toString(feeAmount);
                    return new ValidationError("defaultBrokerCommission.error.maxValueExceeded", brokerCommissionName, formattedFeeAmount);
                }
            }
            return null;
        }
    }

    public class ConflictingContractValidation
    implements GeneralValidation {
        private static final long serialVersionUID = -2265778870845933590L;

        @Override
        public ValidationError validate(Object object) {
            BrokerCommissionContract brokerCommissionContract = (BrokerCommissionContract)object;
            if (CommissionServiceImpl.this.brokerCommissionContractDao.isConflictingContract(brokerCommissionContract)) {
                return new ValidationError("brokerCommissionContract.error.conflictingContract", new Object[0]);
            }
            return null;
        }
    }
}

