/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.Collections;
import java.util.List;
import nl.strohalm.cyclos.access.AdminMemberPermission;
import nl.strohalm.cyclos.access.BrokerPermission;
import nl.strohalm.cyclos.access.MemberPermission;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.accounts.fees.transaction.BrokerCommission;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContract;
import nl.strohalm.cyclos.entities.members.brokerings.BrokerCommissionContractQuery;
import nl.strohalm.cyclos.entities.members.brokerings.Brokering;
import nl.strohalm.cyclos.entities.members.brokerings.DefaultBrokerCommission;
import nl.strohalm.cyclos.exceptions.PermissionDeniedException;
import nl.strohalm.cyclos.services.BaseServiceSecurity;
import nl.strohalm.cyclos.services.elements.CommissionChargeStatusDTO;
import nl.strohalm.cyclos.services.elements.CommissionService;
import nl.strohalm.cyclos.services.elements.CommissionServiceLocal;
import nl.strohalm.cyclos.utils.RelationshipHelper;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.access.PermissionHelper;
import nl.strohalm.cyclos.utils.validation.ValidationException;

public class CommissionServiceSecurity
extends BaseServiceSecurity
implements CommissionService {
    private CommissionServiceLocal commissionService;

    @Override
    public BrokerCommissionContract acceptBrokerCommissionContract(Long brokerCommissionContractId) {
        this.checkMemberPermission(brokerCommissionContractId);
        return this.commissionService.acceptBrokerCommissionContract(brokerCommissionContractId);
    }

    @Override
    public BrokerCommissionContract cancelBrokerCommissionContract(Long brokerCommissionContractId) {
        Member member = this.getMemberFromContractId(brokerCommissionContractId);
        this.checkAdminBrokerPermission(member);
        return this.commissionService.cancelBrokerCommissionContract(brokerCommissionContractId);
    }

    @Override
    public BrokerCommissionContract denyBrokerCommissionContract(Long brokerCommissionContractId) {
        this.checkMemberPermission(brokerCommissionContractId);
        return this.commissionService.denyBrokerCommissionContract(brokerCommissionContractId);
    }

    @Override
    public List<CommissionChargeStatusDTO> getCommissionChargeStatus(Member member) {
        this.checkBrokerMemberPermission(member);
        return this.commissionService.getCommissionChargeStatus(member);
    }

    @Override
    public boolean hasBrokerCommissionContracts() {
        return this.commissionService.hasBrokerCommissionContracts();
    }

    @Override
    public List<BrokerCommission> listPossibleCommissionsForNewContract(Member brokered) {
        if (!this.permissionService.permission(brokered).broker(BrokerPermission.MEMBERS_MANAGE_CONTRACTS).hasPermission()) {
            return Collections.emptyList();
        }
        return this.commissionService.listPossibleCommissionsForNewContract(brokered);
    }

    @Override
    public BrokerCommissionContract loadBrokerCommissionContract(Long id, Relationship ... fetch) {
        Relationship[] newFetch = this.addToFetch(fetch, RelationshipHelper.nested(BrokerCommissionContract.Relationships.BROKERING, Brokering.Relationships.BROKERED));
        BrokerCommissionContract contract = this.commissionService.loadBrokerCommissionContract(id, newFetch);
        if (!this.permissionService.manages(contract.getBrokering().getBrokered()) && !this.permissionService.manages(contract.getBrokering().getBroker())) {
            throw new PermissionDeniedException();
        }
        this.checkAllPermissions();
        return contract;
    }

    @Override
    public List<DefaultBrokerCommission> loadDefaultBrokerCommissions(Member broker, Relationship ... fetch) {
        this.permissionService.checkManages(broker);
        this.permissionService.permission().admin(AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS).broker(BrokerPermission.MEMBERS_MANAGE_DEFAULTS).check();
        return this.commissionService.loadDefaultBrokerCommissions(broker, fetch);
    }

    @Override
    public int removeBrokerCommissionContracts(Long ... ids) {
        for (Long id : ids) {
            Member member = this.getMemberFromContractId(id);
            this.checkBrokerContracts(member);
        }
        return this.commissionService.removeBrokerCommissionContracts(ids);
    }

    @Override
    public BrokerCommissionContract saveBrokerCommissionContract(BrokerCommissionContract brokerCommissionContract) {
        Member member = null;
        if (brokerCommissionContract.isTransient()) {
            member = this.fetchService.fetch(brokerCommissionContract.getBrokering(), Brokering.Relationships.BROKERED).getBrokered();
            BrokerCommission brokerCommission = brokerCommissionContract.getBrokerCommission();
            if (brokerCommission != null) {
                List<BrokerCommission> possibleCommissions = this.commissionService.listPossibleCommissionsForNewContract(member);
                PermissionHelper.checkContains(possibleCommissions, brokerCommission);
            }
        } else {
            member = this.getMemberFromContractId(brokerCommissionContract.getId());
        }
        this.checkBrokerContracts(member);
        return this.commissionService.saveBrokerCommissionContract(brokerCommissionContract);
    }

    @Override
    public List<DefaultBrokerCommission> saveDefaultBrokerCommissions(List<DefaultBrokerCommission> commissions) {
        if (!this.permissionService.hasPermission(BrokerPermission.MEMBERS_MANAGE_DEFAULTS)) {
            throw new PermissionDeniedException();
        }
        for (DefaultBrokerCommission commission : commissions) {
            if (((Entity)LoggedUser.element()).equals(commission.getBroker())) continue;
            throw new PermissionDeniedException();
        }
        return this.commissionService.saveDefaultBrokerCommissions(commissions);
    }

    @Override
    public List<BrokerCommissionContract> searchBrokerCommissionContracts(BrokerCommissionContractQuery query) {
        this.checkAllPermissions();
        if (LoggedUser.isBroker()) {
            query.setBroker((Member)LoggedUser.element());
        } else if (LoggedUser.isMember()) {
            query.setMember((Member)LoggedUser.element());
        } else {
            query.setManagedMemberGroups(this.permissionService.getManagedMemberGroups());
        }
        return this.commissionService.searchBrokerCommissionContracts(query);
    }

    public void setCommissionServiceLocal(CommissionServiceLocal commissionService) {
        this.commissionService = commissionService;
    }

    @Override
    public void stopCommissions(BrokerCommission brokerCommission, Member broker, boolean removeDefaulBrokerCommission) {
        this.checkAdminPermission(broker);
        this.commissionService.stopCommissions(brokerCommission, broker, removeDefaulBrokerCommission);
    }

    @Override
    public void suspendCommissions(BrokerCommission brokerCommission, Member broker) {
        this.checkAdminPermission(broker);
        this.commissionService.suspendCommissions(brokerCommission, broker);
    }

    @Override
    public void unsuspendCommissions(BrokerCommission brokerCommission, Member broker) {
        this.checkAdminPermission(broker);
        this.commissionService.unsuspendCommissions(brokerCommission, broker);
    }

    @Override
    public void validateBrokerCommissionContract(BrokerCommissionContract brokerCommissionContract) throws ValidationException {
        this.commissionService.validateBrokerCommissionContract(brokerCommissionContract);
    }

    @Override
    public void validateDefaultBrokerCommissions(List<DefaultBrokerCommission> defaultBrokerCommissions) throws ValidationException {
        this.commissionService.validateDefaultBrokerCommissions(defaultBrokerCommissions);
    }

    private void checkAdminBrokerPermission(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS).broker(BrokerPermission.MEMBERS_MANAGE_CONTRACTS).check();
    }

    private void checkAdminPermission(Member member) {
        this.permissionService.permission(member).admin(AdminMemberPermission.BROKERINGS_MANAGE_COMMISSIONS).check();
    }

    private void checkAllPermissions() {
        if (!this.commissionService.hasAllPermissions()) {
            throw new PermissionDeniedException();
        }
    }

    private void checkBrokerContracts(Member member) {
        this.permissionService.checkManages(member);
        this.permissionService.permission().broker(BrokerPermission.MEMBERS_MANAGE_CONTRACTS).check();
    }

    private void checkBrokerMemberPermission(Member member) {
        this.permissionService.permission(member).broker(BrokerPermission.MEMBERS_MANAGE_CONTRACTS).member(new MemberPermission[0]).check();
    }

    private void checkMemberPermission(Long brokerCommissionContractId) {
        Member member = this.getMemberFromContractId(brokerCommissionContractId);
        if (!((Entity)LoggedUser.element()).equals(member)) {
            throw new PermissionDeniedException();
        }
    }

    private Member getMemberFromContractId(Long brokerCommissionContractId) {
        BrokerCommissionContract contract = this.commissionService.loadBrokerCommissionContract(brokerCommissionContractId, RelationshipHelper.nested(BrokerCommissionContract.Relationships.BROKERING, Brokering.Relationships.BROKERED));
        return contract.getBrokering().getBrokered();
    }
}

