/*
 * Decompiled with CFR 0.152.
 */
package nl.strohalm.cyclos.services.elements;

import java.util.List;
import nl.strohalm.cyclos.dao.members.ContactDAO;
import nl.strohalm.cyclos.entities.Entity;
import nl.strohalm.cyclos.entities.Relationship;
import nl.strohalm.cyclos.entities.exceptions.EntityNotFoundException;
import nl.strohalm.cyclos.entities.members.Contact;
import nl.strohalm.cyclos.entities.members.Member;
import nl.strohalm.cyclos.services.elements.ContactServiceLocal;
import nl.strohalm.cyclos.services.elements.exceptions.ContactAlreadyExistException;
import nl.strohalm.cyclos.utils.access.LoggedUser;
import nl.strohalm.cyclos.utils.validation.InvalidError;
import nl.strohalm.cyclos.utils.validation.PropertyValidation;
import nl.strohalm.cyclos.utils.validation.ValidationError;
import nl.strohalm.cyclos.utils.validation.Validator;
import nl.strohalm.cyclos.webservices.model.ContactVO;
import nl.strohalm.cyclos.webservices.utils.ContactHelper;

public class ContactServiceImpl
implements ContactServiceLocal {
    private ContactDAO contactDao;
    private ContactHelper contactHelper;

    public ContactDAO getContactDao() {
        return this.contactDao;
    }

    @Override
    public ContactVO getContactVO(Long contactId, boolean useFields, boolean useImages) {
        if (contactId == null) {
            return null;
        }
        Contact contact = this.load(contactId, new Relationship[0]);
        return this.contactHelper.toVO(contact, useFields, useImages);
    }

    @Override
    public List<ContactVO> getContactVOs(List<Contact> contacts, boolean useFields, boolean useImages) {
        return this.contactHelper.toList(contacts, useFields, useImages);
    }

    @Override
    public List<Contact> list(Member owner) {
        return this.contactDao.listByMember(owner);
    }

    @Override
    public Contact load(Long id, Relationship ... fetch) {
        return (Contact)this.contactDao.load(id, fetch);
    }

    @Override
    public Contact load(Member owner, Member contact, Relationship ... fetch) {
        return this.contactDao.load(owner, contact, fetch);
    }

    @Override
    public Contact loadIfExists(Member owner, Member member, Relationship ... fetch) {
        try {
            return this.load(owner, member, fetch);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public int remove(Long ... id) {
        return this.contactDao.delete(id);
    }

    @Override
    public Contact save(Contact contact) {
        contact.setOwner((Member)LoggedUser.accountOwner());
        this.validate(contact);
        if (contact.isTransient()) {
            List<Contact> list = this.contactDao.listByMember(contact.getOwner());
            for (Contact current : list) {
                if (!current.getContact().equals(contact.getContact())) continue;
                throw new ContactAlreadyExistException();
            }
            return this.contactDao.insert(contact);
        }
        return this.contactDao.update(contact);
    }

    public void setContactDao(ContactDAO contactDao) {
        this.contactDao = contactDao;
    }

    public void setContactHelper(ContactHelper contactHelper) {
        this.contactHelper = contactHelper;
    }

    @Override
    public void validate(Contact contact) {
        this.getValidator().validate(contact);
    }

    private Validator getValidator() {
        Validator validator = new Validator("contact");
        validator.property("contact").required().add(new PropertyValidation(){
            private static final long serialVersionUID = -8708862725308048695L;

            @Override
            public ValidationError validate(Object object, Object name, Object value) {
                Object loggedElement;
                Contact contact = (Contact)object;
                Object object2 = loggedElement = LoggedUser.hasUser() ? LoggedUser.element() : null;
                if (loggedElement != null && ((Entity)loggedElement).equals(contact.getContact())) {
                    return new InvalidError();
                }
                return null;
            }
        });
        validator.property("notes").maxLength(1000);
        return validator;
    }
}

